/*
 * Decompiled with CFR 0.152.
 */
package com.digi.xbee.api;

import android.content.Context;
import com.digi.xbee.api.DigiPointNetwork;
import com.digi.xbee.api.RemoteXBeeDevice;
import com.digi.xbee.api.XBee;
import com.digi.xbee.api.XBeeDevice;
import com.digi.xbee.api.XBeeNetwork;
import com.digi.xbee.api.connection.IConnectionInterface;
import com.digi.xbee.api.connection.android.AndroidUSBPermissionListener;
import com.digi.xbee.api.connection.serial.SerialPortParameters;
import com.digi.xbee.api.exceptions.InterfaceNotOpenException;
import com.digi.xbee.api.exceptions.TimeoutException;
import com.digi.xbee.api.exceptions.XBeeDeviceException;
import com.digi.xbee.api.exceptions.XBeeException;
import com.digi.xbee.api.listeners.IExplicitDataReceiveListener;
import com.digi.xbee.api.models.APIOutputMode;
import com.digi.xbee.api.models.ExplicitXBeeMessage;
import com.digi.xbee.api.models.XBee16BitAddress;
import com.digi.xbee.api.models.XBee64BitAddress;
import com.digi.xbee.api.models.XBeeProtocol;
import java.net.Inet6Address;

public class DigiPointDevice
extends XBeeDevice {
    private static final String OPERATION_EXCEPTION = "Operation not supported in DigiPoint protocol.";

    public DigiPointDevice(String port, int baudRate) {
        this(XBee.createConnectiontionInterface(port, baudRate));
    }

    public DigiPointDevice(String port, int baudRate, int dataBits, int stopBits, int parity, int flowControl) {
        this(port, new SerialPortParameters(baudRate, dataBits, stopBits, parity, flowControl));
    }

    public DigiPointDevice(String port, SerialPortParameters serialPortParameters) {
        this(XBee.createConnectiontionInterface(port, serialPortParameters));
    }

    public DigiPointDevice(Context context, int baudRate) {
        super(XBee.createConnectiontionInterface(context, baudRate));
    }

    public DigiPointDevice(Context context, int baudRate, AndroidUSBPermissionListener permissionListener) {
        super(XBee.createConnectiontionInterface(context, baudRate, permissionListener));
    }

    public DigiPointDevice(Context context, String port, int baudRate) {
        super(XBee.createConnectiontionInterface(context, port, baudRate));
    }

    public DigiPointDevice(Context context, String port, SerialPortParameters parameters) {
        super(XBee.createConnectiontionInterface(context, port, parameters));
    }

    public DigiPointDevice(IConnectionInterface connectionInterface) {
        super(connectionInterface);
    }

    @Override
    public void open() throws XBeeException {
        super.open();
        if (this.isRemote()) {
            return;
        }
        if (this.xbeeProtocol != XBeeProtocol.DIGI_POINT) {
            throw new XBeeDeviceException("XBee device is not a " + this.getXBeeProtocol().getDescription() + " device, it is a " + this.xbeeProtocol.getDescription() + " device.");
        }
    }

    @Override
    public XBeeNetwork getNetwork() {
        if (!this.isOpen()) {
            throw new InterfaceNotOpenException();
        }
        if (this.network == null) {
            this.network = new DigiPointNetwork(this);
        }
        return this.network;
    }

    @Override
    public XBeeProtocol getXBeeProtocol() {
        return XBeeProtocol.DIGI_POINT;
    }

    @Override
    public void sendDataAsync(XBee64BitAddress address64Bit, XBee16BitAddress address16bit, byte[] data) throws XBeeException {
        super.sendDataAsync(address64Bit, address16bit, data);
    }

    @Override
    public void sendData(XBee64BitAddress address64Bit, XBee16BitAddress address16bit, byte[] data) throws TimeoutException, XBeeException {
        super.sendData(address64Bit, address16bit, data);
    }

    @Override
    public ExplicitXBeeMessage readExplicitData() {
        return super.readExplicitData();
    }

    @Override
    public ExplicitXBeeMessage readExplicitData(int timeout) {
        return super.readExplicitData(timeout);
    }

    @Override
    public ExplicitXBeeMessage readExplicitDataFrom(RemoteXBeeDevice remoteXBeeDevice) {
        return super.readExplicitDataFrom(remoteXBeeDevice);
    }

    @Override
    public ExplicitXBeeMessage readExplicitDataFrom(RemoteXBeeDevice remoteXBeeDevice, int timeout) {
        return super.readExplicitDataFrom(remoteXBeeDevice, timeout);
    }

    @Override
    public void addExplicitDataListener(IExplicitDataReceiveListener listener) {
        super.addExplicitDataListener(listener);
    }

    @Override
    public void removeExplicitDataListener(IExplicitDataReceiveListener listener) {
        super.removeExplicitDataListener(listener);
    }

    @Override
    public APIOutputMode getAPIOutputMode() throws TimeoutException, XBeeException {
        return super.getAPIOutputMode();
    }

    @Override
    public void setAPIOutputMode(APIOutputMode apiOutputMode) throws TimeoutException, XBeeException {
        super.setAPIOutputMode(apiOutputMode);
    }

    @Override
    public void sendExplicitData(RemoteXBeeDevice remoteXBeeDevice, int sourceEndpoint, int destEndpoint, int clusterID, int profileID, byte[] data) throws TimeoutException, XBeeException {
        super.sendExplicitData(remoteXBeeDevice, sourceEndpoint, destEndpoint, clusterID, profileID, data);
    }

    @Override
    public void sendExplicitData(XBee64BitAddress address64Bit, XBee16BitAddress address16bit, int sourceEndpoint, int destEndpoint, int clusterID, int profileID, byte[] data) throws TimeoutException, XBeeException {
        super.sendExplicitData(address64Bit, address16bit, sourceEndpoint, destEndpoint, clusterID, profileID, data);
    }

    @Override
    public void sendBroadcastExplicitData(int sourceEndpoint, int destEndpoint, int clusterID, int profileID, byte[] data) throws TimeoutException, XBeeException {
        super.sendBroadcastExplicitData(sourceEndpoint, destEndpoint, clusterID, profileID, data);
    }

    @Override
    public void sendExplicitDataAsync(RemoteXBeeDevice xbeeDevice, int sourceEndpoint, int destEndpoint, int clusterID, int profileID, byte[] data) throws XBeeException {
        super.sendExplicitDataAsync(xbeeDevice, sourceEndpoint, destEndpoint, clusterID, profileID, data);
    }

    @Override
    public void sendExplicitDataAsync(XBee64BitAddress address64Bit, XBee16BitAddress address16Bit, int sourceEndpoint, int destEndpoint, int clusterID, int profileID, byte[] data) throws XBeeException {
        super.sendExplicitDataAsync(address64Bit, address16Bit, sourceEndpoint, destEndpoint, clusterID, profileID, data);
    }

    @Override
    public Inet6Address getIPv6Address() {
        return null;
    }

    @Override
    public Inet6Address getIPv6DestinationAddress() throws TimeoutException, XBeeException {
        throw new UnsupportedOperationException(OPERATION_EXCEPTION);
    }

    @Override
    public void setIPv6DestinationAddress(Inet6Address ipv6Address) throws TimeoutException, XBeeException {
        throw new UnsupportedOperationException(OPERATION_EXCEPTION);
    }
}

