/*
 * Decompiled with CFR 0.152.
 */
package com.digi.xbee.api;

import android.content.Context;
import com.digi.xbee.api.DigiMeshNetwork;
import com.digi.xbee.api.RemoteXBeeDevice;
import com.digi.xbee.api.XBee;
import com.digi.xbee.api.XBeeDevice;
import com.digi.xbee.api.XBeeNetwork;
import com.digi.xbee.api.connection.IConnectionInterface;
import com.digi.xbee.api.connection.android.AndroidUSBPermissionListener;
import com.digi.xbee.api.connection.serial.SerialPortParameters;
import com.digi.xbee.api.exceptions.InterfaceNotOpenException;
import com.digi.xbee.api.exceptions.TimeoutException;
import com.digi.xbee.api.exceptions.XBeeDeviceException;
import com.digi.xbee.api.exceptions.XBeeException;
import com.digi.xbee.api.listeners.IExplicitDataReceiveListener;
import com.digi.xbee.api.models.APIOutputMode;
import com.digi.xbee.api.models.ExplicitXBeeMessage;
import com.digi.xbee.api.models.XBee64BitAddress;
import com.digi.xbee.api.models.XBeeProtocol;
import java.net.Inet6Address;

public class DigiMeshDevice
extends XBeeDevice {
    private static final String OPERATION_EXCEPTION = "Operation not supported in DigiMesh protocol.";

    public DigiMeshDevice(String port, int baudRate) {
        this(XBee.createConnectiontionInterface(port, baudRate));
    }

    public DigiMeshDevice(String port, int baudRate, int dataBits, int stopBits, int parity, int flowControl) {
        this(port, new SerialPortParameters(baudRate, dataBits, stopBits, parity, flowControl));
    }

    public DigiMeshDevice(String port, SerialPortParameters serialPortParameters) {
        this(XBee.createConnectiontionInterface(port, serialPortParameters));
    }

    public DigiMeshDevice(Context context, int baudRate) {
        super(XBee.createConnectiontionInterface(context, baudRate));
    }

    public DigiMeshDevice(Context context, int baudRate, AndroidUSBPermissionListener permissionListener) {
        super(XBee.createConnectiontionInterface(context, baudRate, permissionListener));
    }

    public DigiMeshDevice(Context context, String port, int baudRate) {
        super(XBee.createConnectiontionInterface(context, port, baudRate));
    }

    public DigiMeshDevice(Context context, String port, SerialPortParameters parameters) {
        super(XBee.createConnectiontionInterface(context, port, parameters));
    }

    public DigiMeshDevice(IConnectionInterface connectionInterface) {
        super(connectionInterface);
    }

    @Override
    public void open() throws XBeeException {
        super.open();
        if (this.xbeeProtocol != XBeeProtocol.DIGI_MESH) {
            throw new XBeeDeviceException("XBee device is not a " + this.getXBeeProtocol().getDescription() + " device, it is a " + this.xbeeProtocol.getDescription() + " device.");
        }
    }

    @Override
    public XBeeNetwork getNetwork() {
        if (!this.isOpen()) {
            throw new InterfaceNotOpenException();
        }
        if (this.network == null) {
            this.network = new DigiMeshNetwork(this);
        }
        return this.network;
    }

    @Override
    public XBeeProtocol getXBeeProtocol() {
        return XBeeProtocol.DIGI_MESH;
    }

    @Override
    public void sendDataAsync(XBee64BitAddress address, byte[] data) throws XBeeException {
        super.sendDataAsync(address, data);
    }

    @Override
    public void sendData(XBee64BitAddress address, byte[] data) throws TimeoutException, XBeeException {
        super.sendData(address, data);
    }

    @Override
    public ExplicitXBeeMessage readExplicitData() {
        return super.readExplicitData();
    }

    @Override
    public ExplicitXBeeMessage readExplicitData(int timeout) {
        return super.readExplicitData(timeout);
    }

    @Override
    public ExplicitXBeeMessage readExplicitDataFrom(RemoteXBeeDevice remoteXBeeDevice) {
        return super.readExplicitDataFrom(remoteXBeeDevice);
    }

    @Override
    public ExplicitXBeeMessage readExplicitDataFrom(RemoteXBeeDevice remoteXBeeDevice, int timeout) {
        return super.readExplicitDataFrom(remoteXBeeDevice, timeout);
    }

    @Override
    public void addExplicitDataListener(IExplicitDataReceiveListener listener) {
        super.addExplicitDataListener(listener);
    }

    @Override
    public void removeExplicitDataListener(IExplicitDataReceiveListener listener) {
        super.removeExplicitDataListener(listener);
    }

    @Override
    public APIOutputMode getAPIOutputMode() throws TimeoutException, XBeeException {
        return super.getAPIOutputMode();
    }

    @Override
    public void setAPIOutputMode(APIOutputMode apiOutputMode) throws TimeoutException, XBeeException {
        super.setAPIOutputMode(apiOutputMode);
    }

    @Override
    public void sendExplicitData(RemoteXBeeDevice remoteXBeeDevice, int sourceEndpoint, int destEndpoint, int clusterID, int profileID, byte[] data) throws TimeoutException, XBeeException {
        super.sendExplicitData(remoteXBeeDevice, sourceEndpoint, destEndpoint, clusterID, profileID, data);
    }

    @Override
    public void sendExplicitData(XBee64BitAddress address, int sourceEndpoint, int destEndpoint, int clusterID, int profileID, byte[] data) throws TimeoutException, XBeeException {
        super.sendExplicitData(address, sourceEndpoint, destEndpoint, clusterID, profileID, data);
    }

    @Override
    public void sendBroadcastExplicitData(int sourceEndpoint, int destEndpoint, int clusterID, int profileID, byte[] data) throws TimeoutException, XBeeException {
        super.sendBroadcastExplicitData(sourceEndpoint, destEndpoint, clusterID, profileID, data);
    }

    @Override
    public void sendExplicitDataAsync(RemoteXBeeDevice xbeeDevice, int sourceEndpoint, int destEndpoint, int clusterID, int profileID, byte[] data) throws XBeeException {
        super.sendExplicitDataAsync(xbeeDevice, sourceEndpoint, destEndpoint, clusterID, profileID, data);
    }

    @Override
    public void sendExplicitDataAsync(XBee64BitAddress address, int sourceEndpoint, int destEndpoint, int clusterID, int profileID, byte[] data) throws XBeeException {
        super.sendExplicitDataAsync(address, sourceEndpoint, destEndpoint, clusterID, profileID, data);
    }

    @Override
    public Inet6Address getIPv6Address() {
        return null;
    }

    @Override
    public Inet6Address getIPv6DestinationAddress() throws TimeoutException, XBeeException {
        throw new UnsupportedOperationException(OPERATION_EXCEPTION);
    }

    @Override
    public void setIPv6DestinationAddress(Inet6Address ipv6Address) throws TimeoutException, XBeeException {
        throw new UnsupportedOperationException(OPERATION_EXCEPTION);
    }
}

