/*
 * Decompiled with CFR 0.152.
 */
package com.digi.xbee.api;

import android.content.Context;
import com.digi.xbee.api.IPDevice;
import com.digi.xbee.api.XBee;
import com.digi.xbee.api.connection.IConnectionInterface;
import com.digi.xbee.api.connection.android.AndroidUSBPermissionListener;
import com.digi.xbee.api.connection.serial.SerialPortParameters;
import com.digi.xbee.api.exceptions.OperationNotSupportedException;
import com.digi.xbee.api.exceptions.TimeoutException;
import com.digi.xbee.api.exceptions.XBeeDeviceException;
import com.digi.xbee.api.exceptions.XBeeException;
import com.digi.xbee.api.io.IOLine;
import com.digi.xbee.api.listeners.IIOSampleReceiveListener;
import com.digi.xbee.api.listeners.ISMSReceiveListener;
import com.digi.xbee.api.models.AssociationIndicationStatus;
import com.digi.xbee.api.models.CellularAssociationIndicationStatus;
import com.digi.xbee.api.models.PowerLevel;
import com.digi.xbee.api.models.XBee64BitAddress;
import com.digi.xbee.api.models.XBeeIMEIAddress;
import com.digi.xbee.api.models.XBeeProtocol;
import com.digi.xbee.api.packet.cellular.TXSMSPacket;
import com.digi.xbee.api.utils.ByteUtils;
import java.util.Set;

public class CellularDevice
extends IPDevice {
    private static final String OPERATION_EXCEPTION = "Operation not supported in Cellular protocol.";
    private XBeeIMEIAddress imeiAddress;

    public CellularDevice(String port, int baudRate) {
        this(XBee.createConnectiontionInterface(port, baudRate));
    }

    public CellularDevice(String port, int baudRate, int dataBits, int stopBits, int parity, int flowControl) {
        this(port, new SerialPortParameters(baudRate, dataBits, stopBits, parity, flowControl));
    }

    public CellularDevice(String port, SerialPortParameters serialPortParameters) {
        this(XBee.createConnectiontionInterface(port, serialPortParameters));
    }

    public CellularDevice(Context context, int baudRate) {
        super(XBee.createConnectiontionInterface(context, baudRate));
    }

    public CellularDevice(Context context, int baudRate, AndroidUSBPermissionListener permissionListener) {
        super(XBee.createConnectiontionInterface(context, baudRate, permissionListener));
    }

    public CellularDevice(Context context, String port, int baudRate) {
        super(XBee.createConnectiontionInterface(context, port, baudRate));
    }

    public CellularDevice(Context context, String port, SerialPortParameters parameters) {
        super(XBee.createConnectiontionInterface(context, port, parameters));
    }

    public CellularDevice(IConnectionInterface connectionInterface) {
        super(connectionInterface);
    }

    @Override
    public void open() throws XBeeException {
        super.open();
        if (this.xbeeProtocol != XBeeProtocol.CELLULAR && this.xbeeProtocol != XBeeProtocol.CELLULAR_NBIOT) {
            throw new XBeeDeviceException("XBee device is not a " + this.getXBeeProtocol().getDescription() + " device, it is a " + this.xbeeProtocol.getDescription() + " device.");
        }
    }

    @Override
    public XBeeProtocol getXBeeProtocol() {
        return XBeeProtocol.CELLULAR;
    }

    @Override
    public void readDeviceInfo() throws TimeoutException, XBeeException {
        super.readDeviceInfo();
        this.imeiAddress = new XBeeIMEIAddress(this.xbee64BitAddress.getValue());
    }

    public boolean isConnected() throws TimeoutException, XBeeException {
        CellularAssociationIndicationStatus status = this.getCellularAssociationIndicationStatus();
        return status == CellularAssociationIndicationStatus.SUCCESSFULLY_CONNECTED;
    }

    public XBeeIMEIAddress getIMEIAddress() {
        return this.imeiAddress;
    }

    public CellularAssociationIndicationStatus getCellularAssociationIndicationStatus() throws TimeoutException, XBeeException {
        byte[] associationIndicationValue = this.getParameter("AI");
        return CellularAssociationIndicationStatus.get(ByteUtils.byteArrayToInt(associationIndicationValue));
    }

    @Override
    protected AssociationIndicationStatus getAssociationIndicationStatus() throws TimeoutException, XBeeException {
        throw new UnsupportedOperationException(OPERATION_EXCEPTION);
    }

    @Override
    public XBee64BitAddress get64BitAddress() {
        return null;
    }

    @Override
    public void addIOSampleListener(IIOSampleReceiveListener listener) {
        throw new UnsupportedOperationException(OPERATION_EXCEPTION);
    }

    @Override
    public void removeIOSampleListener(IIOSampleReceiveListener listener) {
        throw new UnsupportedOperationException(OPERATION_EXCEPTION);
    }

    @Override
    public Set<IOLine> getDIOChangeDetection() throws TimeoutException, XBeeException {
        throw new UnsupportedOperationException(OPERATION_EXCEPTION);
    }

    @Override
    public void setDIOChangeDetection(Set<IOLine> lines) throws TimeoutException, XBeeException {
        throw new UnsupportedOperationException(OPERATION_EXCEPTION);
    }

    @Override
    public int getIOSamplingRate() throws TimeoutException, XBeeException {
        throw new UnsupportedOperationException(OPERATION_EXCEPTION);
    }

    @Override
    public void setIOSamplingRate(int rate) throws TimeoutException, XBeeException {
        throw new UnsupportedOperationException(OPERATION_EXCEPTION);
    }

    @Override
    public String getNodeID() {
        return null;
    }

    @Override
    public void setNodeID(String nodeID) throws TimeoutException, XBeeException {
        throw new UnsupportedOperationException(OPERATION_EXCEPTION);
    }

    @Override
    public PowerLevel getPowerLevel() throws TimeoutException, XBeeException {
        throw new UnsupportedOperationException(OPERATION_EXCEPTION);
    }

    @Override
    public void setPowerLevel(PowerLevel powerLevel) throws TimeoutException, XBeeException {
        throw new UnsupportedOperationException(OPERATION_EXCEPTION);
    }

    @Override
    public void addSMSListener(ISMSReceiveListener listener) {
        super.addSMSListener(listener);
    }

    @Override
    public void removeSMSListener(ISMSReceiveListener listener) {
        super.removeSMSListener(listener);
    }

    public void sendSMS(String phoneNumber, String data) throws TimeoutException, XBeeException {
        if (phoneNumber == null) {
            throw new NullPointerException("Phone number cannot be null");
        }
        if (data == null) {
            throw new NullPointerException("Data cannot be null");
        }
        if (this.isRemote()) {
            throw new OperationNotSupportedException("Cannot send SMS from a remote device.");
        }
        this.logger.debug(this.toString() + "Sending SMS to {} >> {}.", (Object)phoneNumber, (Object)data);
        TXSMSPacket xbeePacket = new TXSMSPacket(this.getNextFrameID(), phoneNumber, data);
        this.sendAndCheckXBeePacket(xbeePacket, false);
    }

    public void sendSMSAsync(String phoneNumber, String data) throws TimeoutException, XBeeException {
        if (phoneNumber == null) {
            throw new NullPointerException("Phone number cannot be null");
        }
        if (data == null) {
            throw new NullPointerException("Data cannot be null");
        }
        if (this.isRemote()) {
            throw new OperationNotSupportedException("Cannot send SMS from a remote device.");
        }
        this.logger.debug(this.toString() + "Sending SMS asynchronously to {} >> {}.", (Object)phoneNumber, (Object)data);
        TXSMSPacket xbeePacket = new TXSMSPacket(this.getNextFrameID(), phoneNumber, data);
        this.sendAndCheckXBeePacket(xbeePacket, true);
    }
}

