/*
 * Decompiled with CFR 0.152.
 */
package com.digi.xbee.api;

import android.content.Context;
import com.digi.xbee.api.XBee;
import com.digi.xbee.api.XBeeDevice;
import com.digi.xbee.api.connection.DataReader;
import com.digi.xbee.api.connection.IConnectionInterface;
import com.digi.xbee.api.connection.android.AndroidUSBPermissionListener;
import com.digi.xbee.api.connection.serial.SerialPortParameters;
import com.digi.xbee.api.exceptions.ATCommandException;
import com.digi.xbee.api.exceptions.InterfaceNotOpenException;
import com.digi.xbee.api.exceptions.InvalidOperatingModeException;
import com.digi.xbee.api.exceptions.OperationNotSupportedException;
import com.digi.xbee.api.exceptions.TimeoutException;
import com.digi.xbee.api.exceptions.TransmitException;
import com.digi.xbee.api.exceptions.XBeeException;
import com.digi.xbee.api.io.IOLine;
import com.digi.xbee.api.io.IOMode;
import com.digi.xbee.api.io.IOSample;
import com.digi.xbee.api.io.IOValue;
import com.digi.xbee.api.listeners.IDataReceiveListener;
import com.digi.xbee.api.listeners.IExplicitDataReceiveListener;
import com.digi.xbee.api.listeners.IIOSampleReceiveListener;
import com.digi.xbee.api.listeners.IIPDataReceiveListener;
import com.digi.xbee.api.listeners.IModemStatusReceiveListener;
import com.digi.xbee.api.listeners.IPacketReceiveListener;
import com.digi.xbee.api.listeners.ISMSReceiveListener;
import com.digi.xbee.api.models.ATCommand;
import com.digi.xbee.api.models.ATCommandResponse;
import com.digi.xbee.api.models.ATCommandStatus;
import com.digi.xbee.api.models.AssociationIndicationStatus;
import com.digi.xbee.api.models.HardwareVersion;
import com.digi.xbee.api.models.OperatingMode;
import com.digi.xbee.api.models.PowerLevel;
import com.digi.xbee.api.models.RestFulStatusEnum;
import com.digi.xbee.api.models.XBee16BitAddress;
import com.digi.xbee.api.models.XBee64BitAddress;
import com.digi.xbee.api.models.XBeeProtocol;
import com.digi.xbee.api.models.XBeeTransmitStatus;
import com.digi.xbee.api.packet.APIFrameType;
import com.digi.xbee.api.packet.XBeeAPIPacket;
import com.digi.xbee.api.packet.XBeePacket;
import com.digi.xbee.api.packet.common.ATCommandPacket;
import com.digi.xbee.api.packet.common.ATCommandQueuePacket;
import com.digi.xbee.api.packet.common.ATCommandResponsePacket;
import com.digi.xbee.api.packet.common.IODataSampleRxIndicatorPacket;
import com.digi.xbee.api.packet.common.RemoteATCommandPacket;
import com.digi.xbee.api.packet.common.RemoteATCommandResponsePacket;
import com.digi.xbee.api.packet.common.TransmitStatusPacket;
import com.digi.xbee.api.packet.raw.RX16IOPacket;
import com.digi.xbee.api.packet.raw.RX64IOPacket;
import com.digi.xbee.api.packet.raw.TXStatusPacket;
import com.digi.xbee.api.packet.thread.CoAPRxResponsePacket;
import com.digi.xbee.api.packet.thread.CoAPTxRequestPacket;
import com.digi.xbee.api.packet.thread.IPv6RemoteATCommandRequestPacket;
import com.digi.xbee.api.packet.thread.IPv6RemoteATCommandResponsePacket;
import com.digi.xbee.api.utils.ByteUtils;
import com.digi.xbee.api.utils.HexUtils;
import java.io.IOException;
import java.net.Inet6Address;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Set;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractXBeeDevice {
    protected static final int DEFAULT_RECEIVE_TIMETOUT = 2000;
    protected static final int TIMEOUT_BEFORE_COMMAND_MODE = 1200;
    protected static final int TIMEOUT_ENTER_COMMAND_MODE = 1500;
    protected IConnectionInterface connectionInterface;
    protected DataReader dataReader = null;
    protected XBeeProtocol xbeeProtocol = XBeeProtocol.UNKNOWN;
    protected OperatingMode operatingMode = OperatingMode.UNKNOWN;
    protected XBee16BitAddress xbee16BitAddress = XBee16BitAddress.UNKNOWN_ADDRESS;
    protected XBee64BitAddress xbee64BitAddress = XBee64BitAddress.UNKNOWN_ADDRESS;
    protected Inet6Address ipv6Address = null;
    protected int currentFrameID = 255;
    protected int receiveTimeout = 2000;
    protected AbstractXBeeDevice localXBeeDevice;
    protected Logger logger;
    private String nodeID;
    private String firmwareVersion;
    private HardwareVersion hardwareVersion;
    private Object ioLock = new Object();
    private boolean ioPacketReceived = false;
    private boolean applyConfigurationChanges = true;
    private byte[] ioPacketPayload;
    private IPacketReceiveListener IOPacketReceiveListener = new IPacketReceiveListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void packetReceived(XBeePacket receivedPacket) {
            if (!(receivedPacket instanceof XBeeAPIPacket)) {
                return;
            }
            if (AbstractXBeeDevice.this.ioPacketReceived) {
                return;
            }
            switch (((XBeeAPIPacket)receivedPacket).getFrameType()) {
                case IO_DATA_SAMPLE_RX_INDICATOR: {
                    AbstractXBeeDevice.access$102(AbstractXBeeDevice.this, ((IODataSampleRxIndicatorPacket)receivedPacket).getRFData());
                    break;
                }
                case RX_IO_16: {
                    AbstractXBeeDevice.access$102(AbstractXBeeDevice.this, ((RX16IOPacket)receivedPacket).getRFData());
                    break;
                }
                case RX_IO_64: {
                    AbstractXBeeDevice.access$102(AbstractXBeeDevice.this, ((RX64IOPacket)receivedPacket).getRFData());
                    break;
                }
                default: {
                    return;
                }
            }
            AbstractXBeeDevice.this.ioPacketReceived = true;
            Object object = AbstractXBeeDevice.this.ioLock;
            synchronized (object) {
                AbstractXBeeDevice.this.ioLock.notify();
            }
        }
    };

    public AbstractXBeeDevice(String port, int baudRate) {
        this(XBee.createConnectiontionInterface(port, baudRate));
    }

    public AbstractXBeeDevice(String port, int baudRate, int dataBits, int stopBits, int parity, int flowControl) {
        this(port, new SerialPortParameters(baudRate, dataBits, stopBits, parity, flowControl));
    }

    public AbstractXBeeDevice(String port, SerialPortParameters serialPortParameters) {
        this(XBee.createConnectiontionInterface(port, serialPortParameters));
    }

    public AbstractXBeeDevice(Context context, int baudRate) {
        this(XBee.createConnectiontionInterface(context, baudRate));
    }

    public AbstractXBeeDevice(Context context, int baudRate, AndroidUSBPermissionListener permissionListener) {
        this(XBee.createConnectiontionInterface(context, baudRate, permissionListener));
    }

    public AbstractXBeeDevice(IConnectionInterface connectionInterface) {
        if (connectionInterface == null) {
            throw new NullPointerException("ConnectionInterface cannot be null.");
        }
        this.connectionInterface = connectionInterface;
        this.logger = LoggerFactory.getLogger(this.getClass());
        this.logger.debug(this.toString() + "Using the connection interface {}.", (Object)connectionInterface.getClass().getSimpleName());
    }

    public AbstractXBeeDevice(XBeeDevice localXBeeDevice, XBee64BitAddress addr64) {
        this(localXBeeDevice, addr64, null, null);
    }

    public AbstractXBeeDevice(XBeeDevice localXBeeDevice, XBee64BitAddress addr64, XBee16BitAddress addr16, String id) {
        if (localXBeeDevice == null) {
            throw new NullPointerException("Local XBee device cannot be null.");
        }
        if (addr64 == null) {
            throw new NullPointerException("XBee 64-bit address of the device cannot be null.");
        }
        if (localXBeeDevice.isRemote()) {
            throw new IllegalArgumentException("The given local XBee device is remote.");
        }
        this.localXBeeDevice = localXBeeDevice;
        this.connectionInterface = localXBeeDevice.getConnectionInterface();
        this.xbee64BitAddress = addr64;
        this.xbee16BitAddress = addr16;
        if (addr16 == null) {
            this.xbee16BitAddress = XBee16BitAddress.UNKNOWN_ADDRESS;
        }
        this.nodeID = id;
        this.logger = LoggerFactory.getLogger(this.getClass());
        this.logger.debug(this.toString() + "Using the connection interface {}.", (Object)this.connectionInterface.getClass().getSimpleName());
    }

    public AbstractXBeeDevice(XBeeDevice localXBeeDevice, Inet6Address ipv6Addr) {
        this(localXBeeDevice, ipv6Addr, null);
    }

    public AbstractXBeeDevice(XBeeDevice localXBeeDevice, Inet6Address ipv6Addr, String id) {
        if (localXBeeDevice == null) {
            throw new NullPointerException("Local XBee device cannot be null.");
        }
        if (ipv6Addr == null) {
            throw new NullPointerException("XBee IPv6 address of the device cannot be null.");
        }
        if (localXBeeDevice.isRemote()) {
            throw new IllegalArgumentException("The given local XBee device is remote.");
        }
        this.localXBeeDevice = localXBeeDevice;
        this.connectionInterface = localXBeeDevice.getConnectionInterface();
        this.ipv6Address = ipv6Addr;
        this.nodeID = id;
        this.logger = LoggerFactory.getLogger(this.getClass());
        this.logger.debug(this.toString() + "Using the connection interface {}.", (Object)this.connectionInterface.getClass().getSimpleName());
    }

    public IConnectionInterface getConnectionInterface() {
        return this.connectionInterface;
    }

    public abstract boolean isRemote();

    public void readDeviceInfo() throws TimeoutException, XBeeException {
        byte[] response = null;
        if (this.xbee64BitAddress == null || this.xbee64BitAddress.equals(XBee64BitAddress.UNKNOWN_ADDRESS)) {
            response = this.getParameter("SH");
            String addressHigh = HexUtils.byteArrayToHexString(response);
            response = this.getParameter("SL");
            String addressLow = HexUtils.byteArrayToHexString(response);
            while (addressLow.length() < 8) {
                addressLow = "0" + addressLow;
            }
            this.xbee64BitAddress = new XBee64BitAddress(addressHigh + addressLow);
        }
        response = this.getParameter("NI");
        this.nodeID = new String(response);
        if (this.hardwareVersion == null) {
            response = this.getParameter("HV");
            this.hardwareVersion = HardwareVersion.get(response[0]);
        }
        response = this.getParameter("VR");
        this.firmwareVersion = HexUtils.byteArrayToHexString(response);
        XBeeProtocol origProtocol = this.getXBeeProtocol();
        this.xbeeProtocol = XBeeProtocol.determineProtocol(this.hardwareVersion, this.firmwareVersion);
        if (origProtocol != XBeeProtocol.UNKNOWN && origProtocol != this.xbeeProtocol) {
            throw new XBeeException("Error reading device information: Your module seems to be " + (Object)((Object)this.xbeeProtocol) + " and NOT " + (Object)((Object)origProtocol) + ". Check if you are using" + " the appropriate device class.");
        }
        XBeeProtocol protocol = this.getXBeeProtocol();
        if (protocol == XBeeProtocol.ZIGBEE || protocol == XBeeProtocol.RAW_802_15_4 || protocol == XBeeProtocol.XTEND || protocol == XBeeProtocol.SMART_ENERGY || protocol == XBeeProtocol.ZNET) {
            response = this.getParameter("MY");
            this.xbee16BitAddress = new XBee16BitAddress(response);
        }
    }

    public XBee16BitAddress get16BitAddress() {
        return this.xbee16BitAddress;
    }

    public XBee64BitAddress get64BitAddress() {
        return this.xbee64BitAddress;
    }

    public Inet6Address getIPv6Address() {
        return this.ipv6Address;
    }

    protected OperatingMode getOperatingMode() {
        if (this.isRemote()) {
            return this.localXBeeDevice.getOperatingMode();
        }
        return this.operatingMode;
    }

    public XBeeProtocol getXBeeProtocol() {
        return this.xbeeProtocol;
    }

    public String getNodeID() {
        return this.nodeID;
    }

    public void setNodeID(String nodeID) throws TimeoutException, XBeeException {
        if (nodeID == null) {
            throw new NullPointerException("Node ID cannot be null.");
        }
        if (nodeID.length() > 20) {
            throw new IllegalArgumentException("Node ID length must be less than 21.");
        }
        this.setParameter("NI", nodeID.getBytes());
        this.nodeID = nodeID;
    }

    public String getFirmwareVersion() {
        return this.firmwareVersion;
    }

    public HardwareVersion getHardwareVersion() {
        return this.hardwareVersion;
    }

    public void updateDeviceDataFrom(AbstractXBeeDevice device) {
        XBee16BitAddress addr16;
        XBee64BitAddress addr64;
        if (device.getNodeID() != null) {
            this.nodeID = device.getNodeID();
        }
        if (!((addr64 = device.get64BitAddress()) == null || addr64.equals(XBee64BitAddress.UNKNOWN_ADDRESS) || addr64.equals(this.xbee64BitAddress) || this.xbee64BitAddress != null && !this.xbee64BitAddress.equals(XBee64BitAddress.UNKNOWN_ADDRESS))) {
            this.xbee64BitAddress = addr64;
        }
        if ((addr16 = device.get16BitAddress()) != null && !addr16.equals(this.xbee16BitAddress)) {
            this.xbee16BitAddress = addr16;
        }
    }

    protected void addPacketListener(IPacketReceiveListener listener) {
        if (listener == null) {
            throw new NullPointerException("Listener cannot be null.");
        }
        if (this.dataReader == null) {
            return;
        }
        this.dataReader.addPacketReceiveListener(listener);
    }

    protected void removePacketListener(IPacketReceiveListener listener) {
        if (listener == null) {
            throw new NullPointerException("Listener cannot be null.");
        }
        if (this.dataReader == null) {
            return;
        }
        this.dataReader.removePacketReceiveListener(listener);
    }

    protected void addDataListener(IDataReceiveListener listener) {
        if (listener == null) {
            throw new NullPointerException("Listener cannot be null.");
        }
        if (this.dataReader == null) {
            return;
        }
        this.dataReader.addDataReceiveListener(listener);
    }

    protected void removeDataListener(IDataReceiveListener listener) {
        if (listener == null) {
            throw new NullPointerException("Listener cannot be null.");
        }
        if (this.dataReader == null) {
            return;
        }
        this.dataReader.removeDataReceiveListener(listener);
    }

    protected void addIOSampleListener(IIOSampleReceiveListener listener) {
        if (listener == null) {
            throw new NullPointerException("Listener cannot be null.");
        }
        if (this.dataReader == null) {
            return;
        }
        this.dataReader.addIOSampleReceiveListener(listener);
    }

    protected void removeIOSampleListener(IIOSampleReceiveListener listener) {
        if (listener == null) {
            throw new NullPointerException("Listener cannot be null.");
        }
        if (this.dataReader == null) {
            return;
        }
        this.dataReader.removeIOSampleReceiveListener(listener);
    }

    protected void addModemStatusListener(IModemStatusReceiveListener listener) {
        if (listener == null) {
            throw new NullPointerException("Listener cannot be null.");
        }
        if (this.dataReader == null) {
            return;
        }
        this.dataReader.addModemStatusReceiveListener(listener);
    }

    protected void removeModemStatusListener(IModemStatusReceiveListener listener) {
        if (listener == null) {
            throw new NullPointerException("Listener cannot be null.");
        }
        if (this.dataReader == null) {
            return;
        }
        this.dataReader.removeModemStatusReceiveListener(listener);
    }

    protected void addExplicitDataListener(IExplicitDataReceiveListener listener) {
        if (listener == null) {
            throw new NullPointerException("Listener cannot be null.");
        }
        if (this.dataReader == null) {
            return;
        }
        this.dataReader.addExplicitDataReceiveListener(listener);
    }

    protected void removeExplicitDataListener(IExplicitDataReceiveListener listener) {
        if (listener == null) {
            throw new NullPointerException("Listener cannot be null.");
        }
        if (this.dataReader == null) {
            return;
        }
        this.dataReader.removeExplicitDataReceiveListener(listener);
    }

    protected void addIPDataListener(IIPDataReceiveListener listener) {
        if (listener == null) {
            throw new NullPointerException("Listener cannot be null.");
        }
        if (this.dataReader == null) {
            return;
        }
        this.dataReader.addIPDataReceiveListener(listener);
    }

    protected void removeIPDataListener(IIPDataReceiveListener listener) {
        if (listener == null) {
            throw new NullPointerException("Listener cannot be null.");
        }
        if (this.dataReader == null) {
            return;
        }
        this.dataReader.removeIPDataReceiveListener(listener);
    }

    protected void addSMSListener(ISMSReceiveListener listener) {
        if (listener == null) {
            throw new NullPointerException("Listener cannot be null.");
        }
        if (this.dataReader == null) {
            return;
        }
        this.dataReader.addSMSReceiveListener(listener);
    }

    protected void removeSMSListener(ISMSReceiveListener listener) {
        if (listener == null) {
            throw new NullPointerException("Listener cannot be null.");
        }
        if (this.dataReader == null) {
            return;
        }
        this.dataReader.removeSMSReceiveListener(listener);
    }

    protected ATCommandResponse sendATCommand(ATCommand command) throws InvalidOperatingModeException, TimeoutException, IOException {
        XBeeAPIPacket packet;
        if (command == null) {
            throw new NullPointerException("AT command cannot be null.");
        }
        if (!this.connectionInterface.isOpen()) {
            throw new InterfaceNotOpenException();
        }
        ATCommandResponse response = null;
        OperatingMode operatingMode = this.getOperatingMode();
        switch (operatingMode) {
            default: {
                throw new InvalidOperatingModeException(operatingMode);
            }
            case API: 
            case API_ESCAPE: 
        }
        if (this.isRemote()) {
            int remoteATCommandOptions = 0;
            if (this.isApplyConfigurationChangesEnabled()) {
                remoteATCommandOptions |= 2;
            }
            if (this.getXBeeProtocol() == XBeeProtocol.THREAD) {
                packet = new IPv6RemoteATCommandRequestPacket(this.getNextFrameID(), this.ipv6Address, remoteATCommandOptions, command.getCommand(), command.getParameter());
            } else {
                XBee16BitAddress remote16BitAddress = this.get16BitAddress();
                if (remote16BitAddress == null) {
                    remote16BitAddress = XBee16BitAddress.UNKNOWN_ADDRESS;
                }
                packet = new RemoteATCommandPacket(this.getNextFrameID(), this.get64BitAddress(), remote16BitAddress, remoteATCommandOptions, command.getCommand(), command.getParameter());
            }
        } else {
            packet = this.isApplyConfigurationChangesEnabled() ? new ATCommandPacket(this.getNextFrameID(), command.getCommand(), command.getParameter()) : new ATCommandQueuePacket(this.getNextFrameID(), command.getCommand(), command.getParameter());
        }
        if (command.getParameter() == null) {
            this.logger.debug(this.toString() + "Sending AT command '{}'.", (Object)command.getCommand());
        } else {
            this.logger.debug(this.toString() + "Sending AT command '{} {}'.", (Object)command.getCommand(), (Object)HexUtils.prettyHexString(command.getParameter()));
        }
        try {
            XBeeAPIPacket r;
            XBeePacket answerPacket = this.isRemote() ? this.localXBeeDevice.sendXBeePacket(packet) : this.sendXBeePacket(packet);
            if (answerPacket instanceof ATCommandResponsePacket) {
                r = (ATCommandResponsePacket)answerPacket;
                response = new ATCommandResponse(command, ((ATCommandResponsePacket)r).getCommandValue(), ((ATCommandResponsePacket)r).getStatus());
            } else if (answerPacket instanceof RemoteATCommandResponsePacket) {
                r = (RemoteATCommandResponsePacket)answerPacket;
                response = new ATCommandResponse(command, ((RemoteATCommandResponsePacket)r).getCommandValue(), ((RemoteATCommandResponsePacket)r).getStatus());
            } else if (answerPacket instanceof IPv6RemoteATCommandResponsePacket) {
                r = (IPv6RemoteATCommandResponsePacket)answerPacket;
                response = new ATCommandResponse(command, ((IPv6RemoteATCommandResponsePacket)r).getCommandValue(), ((IPv6RemoteATCommandResponsePacket)r).getStatus());
            }
            if (response != null && response.getResponse() != null) {
                this.logger.debug(this.toString() + "AT command response: {}.", (Object)HexUtils.prettyHexString(response.getResponse()));
            } else {
                this.logger.debug(this.toString() + "AT command response: null.");
            }
        }
        catch (ClassCastException e) {
            this.logger.error("Received an invalid packet type after sending an AT command packet." + e);
        }
        return response;
    }

    protected void sendXBeePacketAsync(XBeePacket packet) throws InvalidOperatingModeException, IOException {
        this.sendXBeePacket(packet, null);
    }

    protected void sendXBeePacket(XBeePacket packet, IPacketReceiveListener packetReceiveListener) throws InvalidOperatingModeException, IOException {
        if (packet == null) {
            throw new NullPointerException("XBee packet cannot be null.");
        }
        if (!this.connectionInterface.isOpen()) {
            throw new InterfaceNotOpenException();
        }
        OperatingMode operatingMode = this.getOperatingMode();
        switch (operatingMode) {
            default: {
                throw new InvalidOperatingModeException(operatingMode);
            }
            case API: 
            case API_ESCAPE: 
        }
        if (packet instanceof XBeeAPIPacket) {
            this.insertFrameID(packet);
            XBeeAPIPacket apiPacket = (XBeeAPIPacket)packet;
            if (packetReceiveListener != null && apiPacket.needsAPIFrameID()) {
                this.dataReader.addPacketReceiveListener(packetReceiveListener, apiPacket.getFrameID());
            } else if (packetReceiveListener != null) {
                this.dataReader.addPacketReceiveListener(packetReceiveListener);
            }
        }
        this.writePacket(packet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected XBeePacket sendXBeePacket(XBeePacket packet) throws InvalidOperatingModeException, TimeoutException, IOException {
        if (packet == null) {
            throw new NullPointerException("XBee packet cannot be null.");
        }
        if (!this.connectionInterface.isOpen()) {
            throw new InterfaceNotOpenException();
        }
        OperatingMode operatingMode = this.getOperatingMode();
        switch (operatingMode) {
            default: {
                throw new InvalidOperatingModeException(operatingMode);
            }
            case API: 
            case API_ESCAPE: 
        }
        ArrayList<XBeePacket> responseList = new ArrayList<XBeePacket>();
        if (packet instanceof XBeeAPIPacket) {
            if (!((XBeeAPIPacket)packet).needsAPIFrameID()) {
                this.sendXBeePacketAsync(packet);
                return null;
            }
        } else {
            this.sendXBeePacketAsync(packet);
            return null;
        }
        this.insertFrameID(packet);
        IPacketReceiveListener packetReceiveListener = this.createPacketReceivedListener(packet, responseList);
        this.addPacketListener(packetReceiveListener);
        this.writePacket(packet);
        try {
            Object object = responseList;
            synchronized (object) {
                try {
                    responseList.wait(this.receiveTimeout);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if (responseList.size() < 1) {
                throw new TimeoutException();
            }
            object = responseList.get(0);
            return object;
        }
        finally {
            this.removePacketListener(packetReceiveListener);
        }
    }

    private void insertFrameID(XBeePacket xbeePacket) {
        if (xbeePacket instanceof XBeeAPIPacket) {
            return;
        }
        XBeeAPIPacket apiPacket = (XBeeAPIPacket)xbeePacket;
        if (apiPacket.needsAPIFrameID() && apiPacket.getFrameID() == 9999) {
            apiPacket.setFrameID(this.getNextFrameID());
        }
    }

    private IPacketReceiveListener createPacketReceivedListener(final XBeePacket sentPacket, final ArrayList<XBeePacket> responseList) {
        IPacketReceiveListener packetReceiveListener = new IPacketReceiveListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void packetReceived(XBeePacket receivedPacket) {
                if (((XBeeAPIPacket)receivedPacket).checkFrameID(((XBeeAPIPacket)sentPacket).getFrameID())) {
                    if (sentPacket instanceof XBeeAPIPacket && receivedPacket instanceof XBeeAPIPacket) {
                        XBeeAPIPacket sentAPIPacket = (XBeeAPIPacket)sentPacket;
                        XBeeAPIPacket receivedAPIPacket = (XBeeAPIPacket)receivedPacket;
                        if (sentAPIPacket.getFrameType() == APIFrameType.AT_COMMAND) {
                            if (receivedAPIPacket.getFrameType() != APIFrameType.AT_COMMAND_RESPONSE) {
                                return;
                            }
                            if (!((ATCommandPacket)sentAPIPacket).getCommand().equalsIgnoreCase(((ATCommandResponsePacket)receivedPacket).getCommand())) {
                                return;
                            }
                        }
                        if (sentAPIPacket.getFrameType() == APIFrameType.REMOTE_AT_COMMAND_REQUEST) {
                            if (receivedAPIPacket.getFrameType() != APIFrameType.REMOTE_AT_COMMAND_RESPONSE) {
                                return;
                            }
                            if (!((RemoteATCommandPacket)sentAPIPacket).getCommand().equalsIgnoreCase(((RemoteATCommandResponsePacket)receivedPacket).getCommand())) {
                                return;
                            }
                        }
                    }
                    if (!sentPacket.equals(receivedPacket)) {
                        responseList.add(receivedPacket);
                        ArrayList arrayList = responseList;
                        synchronized (arrayList) {
                            responseList.notify();
                        }
                    }
                }
            }
        };
        return packetReceiveListener;
    }

    private void writePacket(XBeePacket packet) throws IOException {
        this.logger.debug(this.toString() + "Sending XBee packet: \n{}", (Object)packet.toPrettyString());
        switch (this.operatingMode) {
            default: {
                this.connectionInterface.writeData(packet.generateByteArray());
                break;
            }
            case API_ESCAPE: {
                this.connectionInterface.writeData(packet.generateByteArrayEscaped());
            }
        }
    }

    protected int getNextFrameID() {
        if (this.isRemote()) {
            return this.localXBeeDevice.getNextFrameID();
        }
        this.currentFrameID = this.currentFrameID == 255 ? 1 : ++this.currentFrameID;
        return this.currentFrameID;
    }

    protected void sendAndCheckXBeePacket(XBeePacket packet, boolean asyncTransmission) throws TransmitException, XBeeException {
        XBeePacket receivedPacket = null;
        try {
            if (asyncTransmission) {
                this.sendXBeePacketAsync(packet);
            } else {
                receivedPacket = this.sendXBeePacket(packet);
            }
        }
        catch (IOException e) {
            throw new XBeeException("Error writing in the communication interface.", e);
        }
        if (asyncTransmission) {
            return;
        }
        if (receivedPacket == null) {
            throw new TransmitException(null);
        }
        XBeeTransmitStatus status = null;
        if (receivedPacket instanceof TransmitStatusPacket) {
            status = ((TransmitStatusPacket)receivedPacket).getTransmitStatus();
        } else if (receivedPacket instanceof TXStatusPacket) {
            status = ((TXStatusPacket)receivedPacket).getTransmitStatus();
        }
        if (status != XBeeTransmitStatus.SUCCESS && status != XBeeTransmitStatus.SELF_ADDRESSED) {
            throw new TransmitException(status);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] sendAndCheckCoAPPacket(CoAPTxRequestPacket packet, boolean asyncTransmission) throws TransmitException, XBeeException {
        ArrayList<CoAPRxResponsePacket> coapResponsePackets = new ArrayList<CoAPRxResponsePacket>();
        IPacketReceiveListener listener = this.createCoAPResponseListener(coapResponsePackets);
        this.addPacketListener(listener);
        XBeePacket receivedPacket = null;
        try {
            if (asyncTransmission) {
                this.sendXBeePacketAsync(packet);
            } else {
                receivedPacket = this.sendXBeePacket(packet);
            }
        }
        catch (IOException e) {
            throw new XBeeException("Error writing in the communication interface.", e);
        }
        if (asyncTransmission) {
            return null;
        }
        if (receivedPacket == null) {
            throw new TransmitException(null);
        }
        XBeeTransmitStatus status = null;
        if (receivedPacket instanceof TXStatusPacket) {
            status = ((TXStatusPacket)receivedPacket).getTransmitStatus();
        }
        if (status == null || status != XBeeTransmitStatus.SUCCESS && status != XBeeTransmitStatus.SELF_ADDRESSED) {
            throw new TransmitException(status);
        }
        CoAPRxResponsePacket coapRxPacket = null;
        try {
            coapRxPacket = this.waitForCoAPRxResponsePacket(coapResponsePackets);
        }
        finally {
            this.removePacketListener(listener);
        }
        if (coapRxPacket == null) {
            throw new XBeeException("CoAP response was null.");
        }
        return coapRxPacket.getData();
    }

    private IPacketReceiveListener createCoAPResponseListener(final ArrayList<CoAPRxResponsePacket> coapResponsePackets) {
        IPacketReceiveListener listener = new IPacketReceiveListener(){

            @Override
            public void packetReceived(XBeePacket receivedPacket) {
                if (receivedPacket instanceof CoAPRxResponsePacket) {
                    coapResponsePackets.add((CoAPRxResponsePacket)receivedPacket);
                    coapResponsePackets.notifyAll();
                }
            }
        };
        return listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CoAPRxResponsePacket waitForCoAPRxResponsePacket(ArrayList<CoAPRxResponsePacket> coapResponsePackets) throws XBeeException {
        ArrayList<CoAPRxResponsePacket> arrayList = coapResponsePackets;
        synchronized (arrayList) {
            try {
                coapResponsePackets.wait(this.receiveTimeout);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (!coapResponsePackets.isEmpty()) {
            RestFulStatusEnum responseStatus = coapResponsePackets.get(0).getStatus();
            if (responseStatus != RestFulStatusEnum.SUCCESS && responseStatus != RestFulStatusEnum.CREATED && responseStatus != RestFulStatusEnum.ACCEPTED && responseStatus != RestFulStatusEnum.NON_AUTHORITATIVE && responseStatus != RestFulStatusEnum.NO_CONTENT && responseStatus != RestFulStatusEnum.RESET_CONTENT) {
                throw new XBeeException("CoAP response had an unexpected status: " + responseStatus.toString());
            }
        } else {
            throw new XBeeException("CoAP response was not received.");
        }
        return coapResponsePackets.get(0);
    }

    public void setIOConfiguration(IOLine ioLine, IOMode ioMode) throws TimeoutException, XBeeException {
        if (ioLine == null) {
            throw new NullPointerException("IO line cannot be null.");
        }
        if (ioMode == null) {
            throw new NullPointerException("IO mode cannot be null.");
        }
        if (!this.connectionInterface.isOpen()) {
            throw new InterfaceNotOpenException();
        }
        this.setParameter(ioLine.getConfigurationATCommand(), new byte[]{(byte)ioMode.getID()});
    }

    public IOMode getIOConfiguration(IOLine ioLine) throws TimeoutException, XBeeException {
        if (ioLine == null) {
            throw new NullPointerException("DIO pin cannot be null.");
        }
        if (!this.connectionInterface.isOpen()) {
            throw new InterfaceNotOpenException();
        }
        byte ioModeValue = this.getParameter(ioLine.getConfigurationATCommand())[0];
        IOMode dioMode = IOMode.getIOMode(ioModeValue, ioLine);
        if (dioMode == null) {
            throw new OperationNotSupportedException("Received configuration mode '" + HexUtils.integerToHexString(ioModeValue, 1) + "' is not valid.");
        }
        return dioMode;
    }

    public void setDIOValue(IOLine ioLine, IOValue ioValue) throws TimeoutException, XBeeException {
        if (ioLine == null) {
            throw new NullPointerException("IO line cannot be null.");
        }
        if (ioValue == null) {
            throw new NullPointerException("IO value cannot be null.");
        }
        if (!this.connectionInterface.isOpen()) {
            throw new InterfaceNotOpenException();
        }
        this.setParameter(ioLine.getConfigurationATCommand(), new byte[]{(byte)ioValue.getID()});
    }

    public IOValue getDIOValue(IOLine ioLine) throws TimeoutException, XBeeException {
        if (ioLine == null) {
            throw new NullPointerException("IO line cannot be null.");
        }
        IOSample ioSample = this.readIOSample();
        if (!ioSample.hasDigitalValues() || !ioSample.getDigitalValues().containsKey((Object)ioLine)) {
            throw new OperationNotSupportedException("Answer does not contain digital data for " + ioLine.getName() + ".");
        }
        return ioSample.getDigitalValues().get((Object)ioLine);
    }

    public void setPWMDutyCycle(IOLine ioLine, double dutyCycle) throws TimeoutException, XBeeException {
        if (ioLine == null) {
            throw new NullPointerException("IO line cannot be null.");
        }
        if (!ioLine.hasPWMCapability()) {
            throw new IllegalArgumentException("Provided IO line does not have PWM capability.");
        }
        if (dutyCycle < 0.0 || dutyCycle > 100.0) {
            throw new IllegalArgumentException("Duty Cycle must be between 0% and 100%.");
        }
        if (!this.connectionInterface.isOpen()) {
            throw new InterfaceNotOpenException();
        }
        int finaldutyCycle = (int)(dutyCycle * 1023.0 / 100.0);
        this.setParameter(ioLine.getPWMDutyCycleATCommand(), ByteUtils.intToByteArray(finaldutyCycle));
    }

    public double getPWMDutyCycle(IOLine ioLine) throws TimeoutException, XBeeException {
        if (ioLine == null) {
            throw new NullPointerException("IO line cannot be null.");
        }
        if (!ioLine.hasPWMCapability()) {
            throw new IllegalArgumentException("Provided IO line does not have PWM capability.");
        }
        if (!this.connectionInterface.isOpen()) {
            throw new InterfaceNotOpenException();
        }
        byte[] value = this.getParameter(ioLine.getPWMDutyCycleATCommand());
        int readValue = ByteUtils.byteArrayToInt(value);
        return (double)Math.round((double)readValue * 100.0 / 1023.0 * 100.0) / 100.0;
    }

    public int getADCValue(IOLine ioLine) throws TimeoutException, XBeeException {
        if (ioLine == null) {
            throw new NullPointerException("IO line cannot be null.");
        }
        IOSample ioSample = this.readIOSample();
        if (!ioSample.hasAnalogValues() || !ioSample.getAnalogValues().containsKey((Object)ioLine)) {
            throw new OperationNotSupportedException("Answer does not contain analog data for " + ioLine.getName() + ".");
        }
        return ioSample.getAnalogValues().get((Object)ioLine);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDestinationAddress(XBee64BitAddress xbee64BitAddress) throws TimeoutException, XBeeException {
        if (xbee64BitAddress == null) {
            throw new NullPointerException("Address cannot be null.");
        }
        boolean applyChanges = this.isApplyConfigurationChangesEnabled();
        if (applyChanges) {
            this.enableApplyConfigurationChanges(false);
        }
        byte[] address = xbee64BitAddress.getValue();
        try {
            this.setParameter("DH", Arrays.copyOfRange(address, 0, 4));
            this.setParameter("DL", Arrays.copyOfRange(address, 4, 8));
            this.applyChanges();
        }
        finally {
            this.enableApplyConfigurationChanges(applyChanges);
        }
    }

    public XBee64BitAddress getDestinationAddress() throws TimeoutException, XBeeException {
        byte[] dh = this.getParameter("DH");
        byte[] dl = this.getParameter("DL");
        byte[] address = new byte[dh.length + dl.length];
        System.arraycopy(dh, 0, address, 0, dh.length);
        System.arraycopy(dl, 0, address, dh.length, dl.length);
        return new XBee64BitAddress(address);
    }

    public void setIPv6DestinationAddress(Inet6Address ipv6Address) throws TimeoutException, XBeeException {
        if (ipv6Address == null) {
            throw new NullPointerException("Destination IPv6 address cannot be null.");
        }
        this.setParameter("DL", ipv6Address.getAddress());
    }

    public Inet6Address getIPv6DestinationAddress() throws TimeoutException, XBeeException {
        try {
            return (Inet6Address)Inet6Address.getByAddress(this.getParameter("DL"));
        }
        catch (UnknownHostException e) {
            throw new XBeeException(e);
        }
    }

    public void setIOSamplingRate(int rate) throws TimeoutException, XBeeException {
        if (rate < 0 || rate > 65535) {
            throw new IllegalArgumentException("Rate must be between 0 and 0xFFFF.");
        }
        if (!this.connectionInterface.isOpen()) {
            throw new InterfaceNotOpenException();
        }
        this.setParameter("IR", ByteUtils.intToByteArray(rate));
    }

    public int getIOSamplingRate() throws TimeoutException, XBeeException {
        if (!this.connectionInterface.isOpen()) {
            throw new InterfaceNotOpenException();
        }
        byte[] rate = this.getParameter("IR");
        return ByteUtils.byteArrayToInt(rate);
    }

    public void setDIOChangeDetection(Set<IOLine> lines) throws TimeoutException, XBeeException {
        if (!this.connectionInterface.isOpen()) {
            throw new InterfaceNotOpenException();
        }
        byte[] bitfield = new byte[2];
        if (lines != null) {
            for (IOLine line : lines) {
                int i = line.getIndex();
                if (i < 8) {
                    bitfield[1] = (byte)(bitfield[1] | 1 << i);
                    continue;
                }
                bitfield[0] = (byte)(bitfield[0] | 1 << i - 8);
            }
        }
        this.setParameter("IC", bitfield);
    }

    public Set<IOLine> getDIOChangeDetection() throws TimeoutException, XBeeException {
        if (!this.connectionInterface.isOpen()) {
            throw new InterfaceNotOpenException();
        }
        byte[] bitfield = this.getParameter("IC");
        TreeSet<IOLine> lines = new TreeSet<IOLine>();
        int mask = (bitfield[0] << 8) + (bitfield[1] & 0xFF);
        for (int i = 0; i < 16; ++i) {
            if (!ByteUtils.isBitEnabled(mask, i)) continue;
            lines.add(IOLine.getDIO(i));
        }
        if (lines.size() > 0) {
            return lines;
        }
        return null;
    }

    public void applyChanges() throws TimeoutException, XBeeException {
        this.executeParameter("AC");
    }

    protected void checkATCommandResponseIsValid(ATCommandResponse response) throws ATCommandException {
        if (response == null || response.getResponseStatus() == null) {
            throw new ATCommandException(null);
        }
        if (response.getResponseStatus() != ATCommandStatus.OK) {
            throw new ATCommandException(response.getResponseStatus());
        }
    }

    public IOSample readIOSample() throws TimeoutException, XBeeException {
        IOSample ioSample;
        if (!this.connectionInterface.isOpen()) {
            throw new InterfaceNotOpenException();
        }
        byte[] samplePayload = null;
        if (!this.isRemote() && this.getXBeeProtocol() == XBeeProtocol.RAW_802_15_4) {
            this.executeParameter("IS");
            samplePayload = this.receiveRaw802IOPacket();
            if (samplePayload == null) {
                throw new TimeoutException("Timeout waiting for the IO response packet.");
            }
        } else {
            samplePayload = this.getParameter("IS");
        }
        try {
            ioSample = new IOSample(samplePayload);
        }
        catch (IllegalArgumentException e) {
            throw new XBeeException("Couldn't create the IO sample.", e);
        }
        catch (NullPointerException e) {
            throw new XBeeException("Couldn't create the IO sample.", e);
        }
        return ioSample;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] receiveRaw802IOPacket() {
        this.ioPacketReceived = false;
        this.ioPacketPayload = null;
        this.addPacketListener(this.IOPacketReceiveListener);
        Object object = this.ioLock;
        synchronized (object) {
            try {
                this.ioLock.wait(this.receiveTimeout);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.removePacketListener(this.IOPacketReceiveListener);
        if (this.ioPacketReceived) {
            return this.ioPacketPayload;
        }
        return null;
    }

    public abstract void reset() throws TimeoutException, XBeeException;

    public void setParameter(String parameter, byte[] parameterValue) throws TimeoutException, XBeeException {
        if (parameterValue == null) {
            throw new NullPointerException("Value of the parameter cannot be null.");
        }
        this.sendParameter(parameter, parameterValue);
    }

    public byte[] getParameter(String parameter) throws TimeoutException, XBeeException {
        byte[] parameterValue = this.sendParameter(parameter, null);
        if (parameterValue == null) {
            throw new OperationNotSupportedException("Couldn't get the '" + parameter + "' value.");
        }
        return parameterValue;
    }

    public void executeParameter(String parameter) throws TimeoutException, XBeeException {
        this.sendParameter(parameter, null);
    }

    private byte[] sendParameter(String parameter, byte[] parameterValue) throws TimeoutException, XBeeException {
        if (parameter == null) {
            throw new NullPointerException("Parameter cannot be null.");
        }
        if (parameter.length() != 2) {
            throw new IllegalArgumentException("Parameter must contain exactly 2 characters.");
        }
        ATCommand atCommand = new ATCommand(parameter, parameterValue);
        ATCommandResponse response = null;
        try {
            response = this.sendATCommand(atCommand);
        }
        catch (IOException e) {
            throw new XBeeException("Error writing in the communication interface.", e);
        }
        this.checkATCommandResponseIsValid(response);
        return response.getResponse();
    }

    public String toString() {
        return this.connectionInterface.toString();
    }

    public void enableApplyConfigurationChanges(boolean enabled) {
        this.applyConfigurationChanges = enabled;
    }

    public boolean isApplyConfigurationChangesEnabled() {
        return this.applyConfigurationChanges;
    }

    protected void set16BitAddress(XBee16BitAddress xbee16BitAddress) throws TimeoutException, XBeeException {
        if (xbee16BitAddress == null) {
            throw new NullPointerException("16-bit address canot be null.");
        }
        this.setParameter("MY", xbee16BitAddress.getValue());
        this.xbee16BitAddress = xbee16BitAddress;
    }

    public byte[] getPANID() throws TimeoutException, XBeeException {
        switch (this.getXBeeProtocol()) {
            case ZIGBEE: {
                return this.getParameter("OP");
            }
        }
        return this.getParameter("ID");
    }

    public void setPANID(byte[] panID) throws TimeoutException, XBeeException {
        if (panID == null) {
            throw new NullPointerException("PAN ID cannot be null.");
        }
        if (panID.length == 0) {
            throw new IllegalArgumentException("Length of the PAN ID cannot be 0.");
        }
        if (panID.length > 8) {
            throw new IllegalArgumentException("Length of the PAN ID cannot be longer than 8 bytes.");
        }
        this.setParameter("ID", panID);
    }

    public PowerLevel getPowerLevel() throws TimeoutException, XBeeException {
        byte[] powerLevelValue = this.getParameter("PL");
        return PowerLevel.get(ByteUtils.byteArrayToInt(powerLevelValue));
    }

    public void setPowerLevel(PowerLevel powerLevel) throws TimeoutException, XBeeException {
        if (powerLevel == null) {
            throw new NullPointerException("Power level cannot be null.");
        }
        this.setParameter("PL", ByteUtils.intToByteArray(powerLevel.getValue()));
    }

    protected AssociationIndicationStatus getAssociationIndicationStatus() throws TimeoutException, XBeeException {
        byte[] associationIndicationValue = this.getParameter("AI");
        return AssociationIndicationStatus.get(ByteUtils.byteArrayToInt(associationIndicationValue));
    }

    protected void forceDisassociate() throws TimeoutException, XBeeException {
        this.executeParameter("DA");
    }

    public void writeChanges() throws TimeoutException, XBeeException {
        this.executeParameter("WR");
    }

    static /* synthetic */ byte[] access$102(AbstractXBeeDevice x0, byte[] x1) {
        x0.ioPacketPayload = x1;
        return x1;
    }
}

