/*
 * Decompiled with CFR 0.152.
 */
package jmri.web.servlet.roster;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import javax.imageio.ImageIO;
import javax.servlet.ServletException;
import javax.servlet.annotation.MultipartConfig;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jmri.InstanceManager;
import jmri.jmrit.roster.Roster;
import jmri.jmrit.roster.RosterEntry;
import jmri.server.json.JsonException;
import jmri.server.json.roster.JsonRosterServiceFactory;
import jmri.util.FileUtil;
import jmri.web.servlet.ServletUtil;
import jmri.web.servlet.roster.Bundle;
import jmri.web.servlet.roster.FileMeta;
import jmri.web.servlet.roster.MultipartRequestHandler;
import org.jdom2.JDOMException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@MultipartConfig
@WebServlet(name="RosterServlet", urlPatterns={"/roster", "/prefs/roster.xml"})
public class RosterServlet
extends HttpServlet {
    private transient ObjectMapper mapper;
    private static final Logger log = LoggerFactory.getLogger(RosterServlet.class);

    public void init() throws ServletException {
        if (this.getServletContext().getContextPath().equals("/roster")) {
            this.mapper = new ObjectMapper();
        }
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        block13: {
            block12: {
                if (request.getRequestURI().startsWith("/prefs/roster.xml")) {
                    response.sendRedirect("/roster?format=xml");
                    return;
                }
                if (request.getPathInfo().length() != 1) break block12;
                this.doList(request, response);
                break block13;
            }
            String[] pathInfo = request.getPathInfo().substring(1).split("/");
            switch (pathInfo[0]) {
                case "list": {
                    this.doList(request, response);
                    break;
                }
                case "group": {
                    if (pathInfo.length == 2) {
                        this.doGroup(request, response, pathInfo[1]);
                        break;
                    }
                    this.doList(request, response);
                    break;
                }
                default: {
                    this.doEntry(request, response);
                }
            }
        }
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        FileOutputStream out = null;
        InputStream fileContent = null;
        File rosterFolder = new File(Roster.getDefault().getRosterLocation(), "roster");
        if (!rosterFolder.exists()) {
            if (rosterFolder.mkdir()) {
                log.debug("Roster folder not found, created '{}'", (Object)rosterFolder.getPath());
            } else {
                log.error("Could not create roster directory: '{}'", (Object)rosterFolder.getPath());
            }
        }
        File tempFolder = new File(System.getProperty("java.io.tmpdir"));
        Locale rl = request.getLocale();
        List<FileMeta> files = MultipartRequestHandler.uploadByJavaServletAPI(request);
        ArrayList<String> msgList = new ArrayList<String>();
        for (FileMeta fm : files) {
            String m;
            RosterEntry reTemp;
            log.debug("processing uploaded '{}' file '{}' ({}), group='{}', roster='{}', temp='{}'", new Object[]{fm.getFileType(), fm.getFileName(), fm.getFileSize(), fm.getRosterGroup(), rosterFolder, tempFolder});
            if (!fm.getFileType().equals("text/xml") && !fm.getFileType().startsWith("image")) {
                String m2 = String.format(rl, Bundle.getMessage(rl, "ErrorInvalidFileType"), fm.getFileName(), fm.getFileType());
                log.error(m2);
                msgList.add(m2);
                break;
            }
            File fileTemp = new File(tempFolder, fm.getFileName());
            try {
                try {
                    int read;
                    out = new FileOutputStream(fileTemp);
                    fileContent = fm.getContent();
                    byte[] bytes = new byte[1024];
                    while ((read = fileContent.read(bytes)) != -1) {
                        ((OutputStream)out).write(bytes, 0, read);
                    }
                    log.debug("file '{}' of type '{}' temp saved to {}", new Object[]{fm.getFileType(), fm.getFileName(), tempFolder});
                }
                catch (IOException iOException) {
                    String m3 = String.format(rl, Bundle.getMessage(rl, "ErrorSavingFile"), fm.getFileName());
                    log.error(m3);
                    msgList.add(m3);
                    if (out != null) {
                        ((OutputStream)out).close();
                    }
                    if (fileContent == null) break;
                    fileContent.close();
                    break;
                }
            }
            catch (Throwable throwable) {
                if (out != null) {
                    ((OutputStream)out).close();
                }
                if (fileContent != null) {
                    fileContent.close();
                }
                throw throwable;
            }
            if (out != null) {
                ((OutputStream)out).close();
            }
            if (fileContent != null) {
                fileContent.close();
            }
            File fileNew = new File(rosterFolder, fm.getFileName());
            if (fm.getFileType().startsWith("image")) {
                String m4;
                if (fileNew.exists()) {
                    if (!fm.getFileReplace()) {
                        m4 = String.format(rl, Bundle.getMessage(rl, "ErrorFileExists"), fm.getFileName());
                        log.error(m4);
                        msgList.add(m4);
                        if (fileTemp.delete()) continue;
                        log.error("Unable to delete {}", (Object)fileTemp);
                        continue;
                    }
                    if (!fileNew.delete()) {
                        m4 = String.format(rl, Bundle.getMessage(rl, "ErrorDeletingFile"), fileNew.getName());
                        log.debug(m4);
                        msgList.add(m4);
                    }
                    if (fileTemp.renameTo(fileNew)) {
                        m4 = String.format(rl, Bundle.getMessage(rl, "FileReplaced"), fm.getFileName());
                        log.debug(m4);
                        msgList.add(m4);
                        continue;
                    }
                    m4 = String.format(rl, Bundle.getMessage(rl, "ErrorRenameFailed"), fm.getFileName());
                    log.error(m4);
                    msgList.add(m4);
                    if (fileTemp.delete()) continue;
                    log.error("Unable to delete {}", (Object)fileTemp);
                    continue;
                }
                if (fileTemp.renameTo(fileNew)) {
                    m4 = String.format(rl, Bundle.getMessage(rl, "FileAdded"), fm.getFileName());
                    log.debug(m4);
                    msgList.add(m4);
                    continue;
                }
                m4 = String.format(rl, Bundle.getMessage(rl, "ErrorRenameFailed"), fm.getFileName());
                log.error(m4);
                msgList.add(m4);
                if (fileTemp.delete()) continue;
                log.error("Unable to delete {}", (Object)fileTemp);
                continue;
            }
            try {
                reTemp = RosterEntry.fromFile(new File(tempFolder, fm.getFileName()));
            }
            catch (JDOMException e) {
                m = String.format(rl, Bundle.getMessage(rl, "ErrorInvalidXML"), fm.getFileName(), e.getMessage());
                log.error(m);
                msgList.add(m);
                if (fileTemp.delete()) break;
                log.error("Unable to delete {}", (Object)fileTemp);
                break;
            }
            RosterEntry reOld = Roster.getDefault().getEntryForId(reTemp.getId());
            if (reOld != null) {
                if (!fm.getFileReplace()) {
                    m = String.format(rl, Bundle.getMessage(rl, "ErrorFileExists"), fm.getFileName());
                    log.error(m);
                    msgList.add(m);
                    if (fileTemp.delete()) continue;
                    log.error("Unable to delete {}", (Object)fileTemp);
                    continue;
                }
                Roster.getDefault().removeEntry(reOld);
                reTemp.updateFile();
                Roster.getDefault().addEntry(reTemp);
                Roster.getDefault().writeRoster();
                m = String.format(rl, Bundle.getMessage(rl, "RosterEntryReplaced"), fm.getFileName(), reTemp.getDisplayName());
                log.debug(m);
                msgList.add(m);
                if (fileTemp.delete()) continue;
                log.error("Unable to delete {}", (Object)fileTemp);
                continue;
            }
            if (fileTemp.renameTo(fileNew)) {
                Roster.getDefault().addEntry(reTemp);
                Roster.getDefault().writeRoster();
                m = String.format(rl, Bundle.getMessage(rl, "RosterEntryAdded"), fm.getFileName(), reTemp.getId());
                log.debug(m);
                msgList.add(m);
                continue;
            }
            m = String.format(rl, Bundle.getMessage(rl, "ErrorMoveFailed"), fm.getFileName(), reTemp.getPathName());
            log.error(m);
            msgList.add(m);
        }
        response.setContentType("application/json");
        this.mapper.writeValue((OutputStream)response.getOutputStream(), msgList);
    }

    protected void doGroup(HttpServletRequest request, HttpServletResponse response, String group) throws IOException {
        ObjectNode data;
        log.debug("Getting group {}", (Object)group);
        if (request.getContentType() != null && request.getContentType().contains("application/json; charset=utf-8")) {
            data = (ObjectNode)this.mapper.readTree((Reader)request.getReader());
            if (data.path("data").isObject()) {
                data = (ObjectNode)data.path("data");
            }
        } else {
            data = this.mapper.createObjectNode();
            for (String filter : request.getParameterMap().keySet()) {
                if (filter.equals("id")) {
                    data.put("name", URLDecoder.decode(request.getParameter(filter), ServletUtil.UTF8));
                    continue;
                }
                data.put(filter, URLDecoder.decode(request.getParameter(filter), ServletUtil.UTF8));
            }
        }
        data.put("group", URLDecoder.decode(group, ServletUtil.UTF8));
        log.debug("Getting roster with {}", (Object)data);
        this.doRoster(request, response, (JsonNode)data);
    }

    protected void doList(HttpServletRequest request, HttpServletResponse response) throws IOException {
        ObjectNode data;
        block13: {
            block12: {
                if (request.getContentType() == null || !request.getContentType().contains("application/json; charset=utf-8")) break block12;
                data = (ObjectNode)this.mapper.readTree((Reader)request.getReader());
                if (data.path("data").isObject()) {
                    data = (ObjectNode)data.path("data");
                }
                break block13;
            }
            data = this.mapper.createObjectNode();
            Iterator iterator = request.getParameterMap().keySet().iterator();
            block8: while (iterator.hasNext()) {
                String filter;
                switch (filter = (String)iterator.next()) {
                    case "group": {
                        String group = URLDecoder.decode(request.getParameter(filter), ServletUtil.UTF8);
                        if (group.equals(Roster.allEntries(request.getLocale()))) continue block8;
                        data.put("group", group);
                        break;
                    }
                    case "id": {
                        data.put("name", URLDecoder.decode(request.getParameter(filter), ServletUtil.UTF8));
                        break;
                    }
                    default: {
                        data.put(filter, URLDecoder.decode(request.getParameter(filter), ServletUtil.UTF8));
                    }
                }
            }
        }
        this.doRoster(request, response, (JsonNode)data);
    }

    protected void doEntry(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String[] pathInfo = request.getRequestURI().substring(1).split("/");
        int idOffset = 1;
        String type = null;
        if (pathInfo[1].equals("entry")) {
            if (pathInfo.length == 2) {
                response.sendError(400);
            }
            idOffset = 2;
        }
        String id = URLDecoder.decode(pathInfo[idOffset], ServletUtil.UTF8);
        if (pathInfo.length > 1 + idOffset) {
            type = pathInfo[pathInfo.length - 1];
        }
        RosterEntry re = Roster.getDefault().getEntryForId(id);
        try {
            if (re == null) {
                response.sendError(404, "Could not find roster entry " + id);
            } else if (type == null || type.equals("entry")) {
                this.doRoster(request, response, (JsonNode)this.mapper.createObjectNode().put("id", id));
            } else if (type.equals("image")) {
                if (re.getImagePath() != null) {
                    this.doImage(request, response, FileUtil.getFile(re.getImagePath()));
                } else {
                    response.sendError(404);
                }
            } else if (type.equals("icon")) {
                int function = -1;
                if (pathInfo.length != 2 + idOffset) {
                    function = Integer.parseInt(pathInfo[pathInfo.length - 2].substring(1));
                }
                if (function == -1) {
                    if (re.getIconPath() != null) {
                        this.doImage(request, response, FileUtil.getFile(re.getIconPath()));
                    } else {
                        response.sendError(404);
                    }
                } else if (re.getFunctionImage(function) != null) {
                    this.doImage(request, response, FileUtil.getFile(re.getFunctionImage(function)));
                } else {
                    response.sendError(404);
                }
            } else if (type.equals("selectedIcon")) {
                if (pathInfo.length != 2 + idOffset) {
                    int function = Integer.parseInt(pathInfo[pathInfo.length - 2].substring(1));
                    this.doImage(request, response, FileUtil.getFile(re.getFunctionSelectedImage(function)));
                }
            } else if (type.equals("file")) {
                InstanceManager.getDefault(ServletUtil.class).writeFile(response, new File(Roster.getDefault().getRosterLocation(), "roster" + File.separator + re.getFileName()), "application/xml; charset=utf-8");
            } else if (type.equals("throttle")) {
                InstanceManager.getDefault(ServletUtil.class).writeFile(response, new File(FileUtil.getUserFilesPath(), "throttle" + File.separator + id + ".xml"), "application/xml; charset=utf-8");
            } else {
                response.sendError(400);
            }
        }
        catch (NullPointerException nullPointerException) {
            response.sendError(404);
        }
    }

    protected void doRoster(HttpServletRequest request, HttpServletResponse response, JsonNode filter) throws IOException {
        InstanceManager.getDefault(ServletUtil.class).setNonCachingHeaders(response);
        log.debug("Getting roster with filter {}", (Object)filter);
        String group = !filter.path("group").isMissingNode() ? filter.path("group").asText() : null;
        log.debug("Group {} was in filter", (Object)group);
        String format = request.getParameter("format");
        if (format == null) {
            format = "";
        }
        switch (format) {
            case "json": {
                response.setContentType("application/json; charset=utf-8");
                JsonRosterServiceFactory factory = new JsonRosterServiceFactory();
                try {
                    response.getWriter().print(factory.getHttpService(this.mapper, "v5").getRoster(request.getLocale(), filter, 0));
                }
                catch (JsonException ex) {
                    response.sendError(ex.getCode(), this.mapper.writeValueAsString((Object)ex.getJsonMessage()));
                }
                break;
            }
            case "xml": {
                response.setContentType("application/xml; charset=utf-8");
                File roster = new File(Roster.getDefault().getRosterIndexPath());
                if (!roster.exists()) break;
                response.getWriter().print(FileUtil.readFile(roster));
                break;
            }
            case "html": {
                String row = "simple".equals(request.getParameter("view")) ? FileUtil.readURL(FileUtil.findURL(Bundle.getMessage(request.getLocale(), "SimpleTableRow.html"))) : FileUtil.readURL(FileUtil.findURL(Bundle.getMessage(request.getLocale(), "TableRow.html")));
                StringBuilder builder = new StringBuilder();
                response.setContentType("text/html; charset=utf-8");
                if (Roster.allEntries(request.getLocale()).equals(group)) {
                    group = null;
                }
                List<RosterEntry> entries = Roster.getDefault().getEntriesMatchingCriteria(!filter.path("road").isMissingNode() ? filter.path("road").asText() : null, !filter.path("number").isMissingNode() ? filter.path("number").asText() : null, !filter.path("address").isMissingNode() ? filter.path("address").asText() : null, !filter.path("mfg").isMissingNode() ? filter.path("mfg").asText() : null, !filter.path("decoderModel").isMissingNode() ? filter.path("decoderModel").asText() : null, !filter.path("decoderFamily").isMissingNode() ? filter.path("decoderFamily").asText() : null, !filter.path("name").isMissingNode() ? filter.path("name").asText() : null, group);
                for (RosterEntry entry : entries) {
                    try {
                        builder.append(String.format(request.getLocale(), row, entry.getId(), entry.getRoadName(), entry.getRoadNumber(), entry.getMfg(), entry.getModel(), entry.getOwner(), entry.getDccAddress(), entry.getDecoderModel(), entry.getDecoderFamily(), entry.getDecoderComment(), entry.getComment(), entry.getURL(), entry.getMaxSpeedPCT(), entry.getFileName(), URLEncoder.encode(entry.getId(), ServletUtil.UTF8)));
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        response.sendError(500, "Unable to encode entry Id in UTF-8.");
                    }
                }
                response.getWriter().print(builder.toString());
                break;
            }
            default: {
                if (group == null) {
                    group = Roster.allEntries(request.getLocale());
                }
                response.setContentType("text/html; charset=utf-8");
                response.getWriter().print(String.format(request.getLocale(), FileUtil.readURL(FileUtil.findURL(Bundle.getMessage(request.getLocale(), "Roster.html"))), String.format(request.getLocale(), Bundle.getMessage(request.getLocale(), "HtmlTitle"), InstanceManager.getDefault(ServletUtil.class).getRailroadName(false), Bundle.getMessage(request.getLocale(), "RosterTitle")), InstanceManager.getDefault(ServletUtil.class).getNavBar(request.getLocale(), request.getContextPath()), InstanceManager.getDefault(ServletUtil.class).getRailroadName(false), InstanceManager.getDefault(ServletUtil.class).getFooter(request.getLocale(), request.getContextPath()), group));
            }
        }
    }

    void doImage(HttpServletRequest request, HttpServletResponse response, File file) throws IOException {
        int width;
        BufferedImage image;
        try {
            image = ImageIO.read(file);
        }
        catch (IOException iOException) {
            response.sendError(404);
            return;
        }
        String fname = file.getName();
        int height = image.getHeight();
        int pWidth = width = image.getWidth();
        int pHeight = height;
        if (request.getParameter("maxWidth") != null) {
            pWidth = Integer.parseInt(request.getParameter("maxWidth"));
            if (pWidth < width) {
                width = pWidth;
            }
            log.debug("{} @maxWidth: width: {}, pWidth: {}, height: {}, pHeight: {}", new Object[]{fname, width, pWidth, height, pHeight});
        }
        if (request.getParameter("minWidth") != null) {
            pWidth = Integer.parseInt(request.getParameter("minWidth"));
            if (pWidth > width) {
                width = pWidth;
            }
            log.debug("{} @minWidth: width: {}, pWidth: {}, height: {}, pHeight: {}", new Object[]{fname, width, pWidth, height, pHeight});
        }
        if (request.getParameter("width") != null) {
            width = Integer.parseInt(request.getParameter("width"));
        }
        if (width != image.getWidth()) {
            pHeight = height = (int)((double)height * (1.0 * (double)width / (double)image.getWidth()));
            log.debug("{} @adjusting height: width: {}, pWidth: {}, height: {}, pHeight: {}", new Object[]{fname, width, pWidth, height, pHeight});
        }
        if (request.getParameter("maxHeight") != null) {
            pHeight = Integer.parseInt(request.getParameter("maxHeight"));
            if (pHeight < height) {
                height = pHeight;
            }
            log.debug("{} @maxHeight: width: {}, pWidth: {}, height: {}, pHeight: {}", new Object[]{fname, width, pWidth, height, pHeight});
        }
        if (request.getParameter("minHeight") != null) {
            pHeight = Integer.parseInt(request.getParameter("minHeight"));
            if (pHeight > height) {
                height = pHeight;
            }
            log.debug("{} @minHeight: width: {}, pWidth: {}, height: {}, pHeight: {}", new Object[]{fname, width, pWidth, height, pHeight});
        }
        if (request.getParameter("height") != null) {
            height = Integer.parseInt(request.getParameter("height"));
            log.debug("{} @height: width: {}, pWidth: {}, height: {}, pHeight: {}", new Object[]{fname, width, pWidth, height, pHeight});
        }
        if (height != image.getHeight() && width == image.getWidth()) {
            width = (int)((double)width * (1.0 * (double)height / (double)image.getHeight()));
            log.debug("{} @adjusting width: width: {}, pWidth: {}, height: {}, pHeight: {}", new Object[]{fname, width, pWidth, height, pHeight});
        }
        log.debug("{} @responding: width: {}, pWidth: {}, height: {}, pHeight: {}", new Object[]{fname, width, pWidth, height, pHeight});
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        if (height != image.getHeight() || width != image.getWidth()) {
            BufferedImage resizedImage = new BufferedImage(width, height, image.getType());
            Graphics2D g = resizedImage.createGraphics();
            g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            g.drawImage(image, 0, 0, width, height, 0, 0, image.getWidth(), image.getHeight(), null);
            g.dispose();
            ImageIO.write((RenderedImage)resizedImage, "png", baos);
        } else {
            ImageIO.write((RenderedImage)image, "png", baos);
        }
        baos.close();
        response.setContentType("image/png");
        response.setStatus(200);
        response.setContentLength(baos.size());
        response.getOutputStream().write(baos.toByteArray());
        response.getOutputStream().close();
    }
}

