/*
 * Decompiled with CFR 0.152.
 */
package jmri.web.servlet.roster;

import java.io.IOException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import javax.servlet.MultipartConfigElement;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.Part;
import jmri.web.servlet.roster.FileMeta;

public class MultipartRequestHandler {
    private static final MultipartConfigElement MULTI_PART_CONFIG = new MultipartConfigElement(System.getProperty("java.io.tmpdir"));

    public static List<FileMeta> uploadByJavaServletAPI(HttpServletRequest request) throws IOException, ServletException {
        LinkedList<FileMeta> files = new LinkedList<FileMeta>();
        if (request.getContentType() != null && request.getContentType().startsWith("multipart/form-data")) {
            request.setAttribute("org.eclipse.jetty.multipartConfig", (Object)MULTI_PART_CONFIG);
        }
        Collection parts = request.getParts();
        boolean fileReplace = request.getParameter("fileReplace").equals("true");
        String rosterGroup = request.getParameter("rosterGroup");
        for (Part part : parts) {
            if (part.getContentType() == null) continue;
            FileMeta temp = new FileMeta();
            temp.setFileName(MultipartRequestHandler.getFilename(part));
            temp.setFileSize(String.valueOf(part.getSize() / 1024L) + " Kb");
            temp.setFileType(part.getContentType());
            temp.setContent(part.getInputStream());
            temp.setFileReplace(fileReplace);
            temp.setRosterGroup(rosterGroup);
            files.add(temp);
        }
        return files;
    }

    private static String getFilename(Part part) {
        String[] stringArray = part.getHeader("content-disposition").split(";");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String cd = stringArray[n2];
            if (cd.trim().startsWith("filename")) {
                String filename = cd.substring(cd.indexOf(61) + 1).trim().replace("\"", "");
                return filename.substring(filename.lastIndexOf(47) + 1).substring(filename.lastIndexOf(92) + 1);
            }
            ++n2;
        }
        return null;
    }
}

