/*
 * Decompiled with CFR 0.152.
 */
package jmri.web.servlet.operations;

import java.io.FileInputStream;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import jmri.InstanceManager;
import jmri.jmrit.operations.locations.Track;
import jmri.jmrit.operations.rollingstock.RollingStock;
import jmri.jmrit.operations.rollingstock.cars.Car;
import jmri.jmrit.operations.rollingstock.engines.Engine;
import jmri.jmrit.operations.routes.RouteLocation;
import jmri.jmrit.operations.setup.Setup;
import jmri.jmrit.operations.trains.Train;
import jmri.jmrit.operations.trains.TrainCommon;
import jmri.jmrit.operations.trains.schedules.TrainScheduleManager;
import jmri.web.servlet.operations.Bundle;
import org.apache.commons.text.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HtmlTrainCommon
extends TrainCommon {
    protected final Properties strings = new Properties();
    protected final Locale locale;
    protected final Train train;
    protected String resourcePrefix;
    private static final Logger log = LoggerFactory.getLogger(HtmlTrainCommon.class);

    public HtmlTrainCommon(Locale locale, Train train) throws IOException {
        this.locale = locale;
        this.train = train;
        FileInputStream is = null;
        try {
            is = new FileInputStream(Bundle.getMessage(locale, "ManifestStrings.properties"));
            this.strings.load(is);
            is.close();
        }
        catch (IOException ex) {
            if (is != null) {
                is.close();
            }
            throw ex;
        }
    }

    public String pickupUtilityCars(List<Car> cars, Car car, boolean isManifest) {
        String[] messageFormat = isManifest ? Setup.getPickupUtilityManifestMessageFormat() : Setup.getPickupUtilitySwitchListMessageFormat();
        int count = this.countUtilityCars(messageFormat, cars, car, true);
        if (count == 0) {
            return "";
        }
        return this.pickUpCar(car, count, messageFormat);
    }

    protected String setoutUtilityCars(List<Car> cars, Car car, boolean isManifest) {
        boolean isLocal = car.isLocalMove();
        if (Setup.isSwitchListFormatSameAsManifest()) {
            isManifest = true;
        }
        String[] messageFormat = Setup.getDropUtilityManifestMessageFormat();
        if (isLocal && isManifest) {
            messageFormat = Setup.getLocalUtilityManifestMessageFormat();
        } else if (isLocal && !isManifest) {
            messageFormat = Setup.getLocalUtilitySwitchListMessageFormat();
        } else if (!isLocal && !isManifest) {
            messageFormat = Setup.getDropUtilitySwitchListMessageFormat();
        }
        int count = this.countUtilityCars(messageFormat, cars, car, false);
        if (count == 0) {
            return "";
        }
        return this.dropCar(car, count, messageFormat, isLocal);
    }

    protected String pickUpCar(Car car, String[] format) {
        return this.pickUpCar(car, 0, format);
    }

    protected String pickUpCar(Car car, int count, String[] format) {
        if (car.isLocalMove()) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        if (count != 0) {
            builder.append(count);
        }
        String[] stringArray = format;
        int n = format.length;
        int n2 = 0;
        while (n2 < n) {
            String attribute = stringArray[n2];
            builder.append(String.format(this.locale, this.strings.getProperty("Attribute"), this.getCarAttribute(car, attribute, true, false), attribute.toLowerCase())).append(" ");
            ++n2;
        }
        log.debug("Picking up car {}", (Object)builder);
        return String.format(this.locale, this.strings.getProperty(String.valueOf(this.resourcePrefix) + "PickUpCar"), builder.toString());
    }

    protected String dropCar(Car car, String[] format, boolean isLocal) {
        return this.dropCar(car, 0, format, isLocal);
    }

    protected String dropCar(Car car, int count, String[] format, boolean isLocal) {
        StringBuilder builder = new StringBuilder();
        if (count != 0) {
            builder.append(count);
        }
        String[] stringArray = format;
        int n = format.length;
        int n2 = 0;
        while (n2 < n) {
            String attribute = stringArray[n2];
            builder.append(String.format(this.locale, this.strings.getProperty("Attribute"), this.getCarAttribute(car, attribute, false, isLocal), attribute.toLowerCase())).append(" ");
            ++n2;
        }
        log.debug("Dropping {}car {}", (Object)(isLocal ? "local " : ""), (Object)builder);
        if (!isLocal) {
            return String.format(this.locale, this.strings.getProperty(String.valueOf(this.resourcePrefix) + "DropCar"), builder.toString());
        }
        return String.format(this.locale, this.strings.getProperty(String.valueOf(this.resourcePrefix) + "LocalCar"), builder.toString());
    }

    protected String engineChange(RouteLocation location, int legOptions) {
        if ((legOptions & 2) == 2) {
            return String.format(this.strings.getProperty("AddHelpersAt"), HtmlTrainCommon.splitString(location.getName()));
        }
        if ((legOptions & 1) == 1 && ((legOptions & 8) == 8 || (legOptions & 4) == 4)) {
            return String.format(this.strings.getProperty("LocoAndCabooseChangeAt"), HtmlTrainCommon.splitString(location.getName()));
        }
        if ((legOptions & 1) == 1) {
            return String.format(this.strings.getProperty("LocoChangeAt"), HtmlTrainCommon.splitString(location.getName()));
        }
        if ((legOptions & 8) == 8 || (legOptions & 4) == 4) {
            return String.format(this.strings.getProperty("CabooseChangeAt"), HtmlTrainCommon.splitString(location.getName()));
        }
        return "";
    }

    protected String dropEngines(List<Engine> engines, RouteLocation location) {
        StringBuilder builder = new StringBuilder();
        for (Engine engine : engines) {
            if (!engine.getRouteDestination().equals(location)) continue;
            builder.append(this.dropEngine(engine));
        }
        return String.format(this.strings.getProperty("EnginesList"), builder.toString());
    }

    @Override
    public String dropEngine(Engine engine) {
        StringBuilder builder = new StringBuilder();
        String[] stringArray = Setup.getDropEngineMessageFormat();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String attribute = stringArray[n2];
            builder.append(String.format(this.locale, this.strings.getProperty("Attribute"), this.getEngineAttribute(engine, attribute, false), attribute.toLowerCase())).append(" ");
            ++n2;
        }
        log.debug("Drop engine: {}", (Object)builder);
        return String.format(this.locale, this.strings.getProperty(String.valueOf(this.resourcePrefix) + "DropEngine"), builder.toString());
    }

    protected String pickupEngines(List<Engine> engines, RouteLocation location) {
        StringBuilder builder = new StringBuilder();
        for (Engine engine : engines) {
            if (!engine.getRouteLocation().equals(location) || engine.getTrackName().isEmpty()) continue;
            builder.append(this.pickupEngine(engine));
        }
        return String.format(this.locale, this.strings.getProperty("EnginesList"), builder.toString());
    }

    @Override
    public String pickupEngine(Engine engine) {
        StringBuilder builder = new StringBuilder();
        String[] stringArray = Setup.getPickupEngineMessageFormat();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String attribute = stringArray[n2];
            builder.append(String.format(this.locale, this.strings.getProperty("Attribute"), this.getEngineAttribute(engine, attribute, true), attribute.toLowerCase())).append(" ");
            ++n2;
        }
        log.debug("Picking up engine: {}", (Object)builder);
        return String.format(this.locale, this.strings.getProperty(String.valueOf(this.resourcePrefix) + "PickUpEngine"), builder.toString());
    }

    protected String getCarAttribute(Car car, String attribute, boolean isPickup, boolean isLocal) {
        if (attribute.equals(Setup.LOAD)) {
            return car.isCaboose() || car.isPassenger() ? "" : StringEscapeUtils.escapeHtml4((String)car.getLoadName());
        }
        if (attribute.equals(Setup.HAZARDOUS)) {
            return car.isHazardous() ? Setup.getHazardousMsg() : "";
        }
        if (attribute.equals(Setup.DROP_COMMENT)) {
            return car.getDropComment();
        }
        if (attribute.equals(Setup.PICKUP_COMMENT)) {
            return car.getPickupComment();
        }
        if (attribute.equals(Setup.KERNEL)) {
            return car.getKernelName();
        }
        if (attribute.equals(Setup.RWE)) {
            if (!car.getReturnWhenEmptyDestName().isEmpty()) {
                return String.format(this.locale, this.strings.getProperty("RWELocationAndTrack"), StringEscapeUtils.escapeHtml4((String)HtmlTrainCommon.splitString(car.getReturnWhenEmptyDestinationName())), StringEscapeUtils.escapeHtml4((String)HtmlTrainCommon.splitString(car.getReturnWhenEmptyDestTrackName())));
            }
            return "";
        }
        if (attribute.equals(Setup.FINAL_DEST)) {
            if (!car.getFinalDestinationName().isEmpty()) {
                return String.format(this.locale, this.strings.getProperty("FinalDestinationLocation"), StringEscapeUtils.escapeHtml4((String)HtmlTrainCommon.splitString(car.getFinalDestinationName())));
            }
            return "";
        }
        if (attribute.equals(Setup.FINAL_DEST_TRACK)) {
            if (!car.getFinalDestinationName().isEmpty()) {
                return String.format(this.locale, this.strings.getProperty("FinalDestinationLocationAndTrack"), StringEscapeUtils.escapeHtml4((String)HtmlTrainCommon.splitString(car.getFinalDestinationName())), StringEscapeUtils.escapeHtml4((String)HtmlTrainCommon.splitString(car.getFinalDestinationTrackName())));
            }
            return "";
        }
        return this.getRollingStockAttribute(car, attribute, isPickup, isLocal);
    }

    protected String getEngineAttribute(Engine engine, String attribute, boolean isPickup) {
        if (attribute.equals(Setup.MODEL)) {
            return engine.getModel();
        }
        if (attribute.equals(Setup.CONSIST)) {
            return engine.getConsistName();
        }
        return this.getRollingStockAttribute(engine, attribute, isPickup, false);
    }

    protected String getRollingStockAttribute(RollingStock rs, String attribute, boolean isPickup, boolean isLocal) {
        if (attribute.equals(Setup.NUMBER)) {
            return HtmlTrainCommon.splitString(rs.getNumber());
        }
        if (attribute.equals(Setup.ROAD)) {
            return StringEscapeUtils.escapeHtml4((String)rs.getRoadName().split("-")[0]);
        }
        if (attribute.equals(Setup.TYPE)) {
            return rs.getTypeName().split("-")[0];
        }
        if (attribute.equals(Setup.LENGTH)) {
            return rs.getLength();
        }
        if (attribute.equals(Setup.COLOR)) {
            return rs.getColor();
        }
        if (attribute.equals(Setup.LOCATION) && (isPickup || isLocal) || attribute.equals(Setup.TRACK) && isPickup) {
            if (rs.getTrack() != null) {
                return String.format(this.locale, this.strings.getProperty("FromTrack"), StringEscapeUtils.escapeHtml4((String)HtmlTrainCommon.splitString(rs.getTrackName())));
            }
            return "";
        }
        if (attribute.equals(Setup.LOCATION) && !isPickup && !isLocal) {
            return "";
        }
        if (attribute.equals(Setup.DESTINATION) && isPickup) {
            return String.format(this.locale, this.strings.getProperty("ToLocation"), StringEscapeUtils.escapeHtml4((String)HtmlTrainCommon.splitString(rs.getDestinationName())));
        }
        if ((attribute.equals(Setup.DESTINATION) || attribute.equals(Setup.TRACK)) && !isPickup) {
            return String.format(this.locale, this.strings.getProperty("ToTrack"), StringEscapeUtils.escapeHtml4((String)HtmlTrainCommon.splitString(rs.getDestinationTrackName())));
        }
        if (attribute.equals(Setup.DEST_TRACK)) {
            return String.format(this.locale, this.strings.getProperty("ToLocationAndTrack"), StringEscapeUtils.escapeHtml4((String)HtmlTrainCommon.splitString(rs.getDestinationName())), StringEscapeUtils.escapeHtml4((String)HtmlTrainCommon.splitString(rs.getDestinationTrackName())));
        }
        if (attribute.equals(Setup.OWNER)) {
            return StringEscapeUtils.escapeHtml4((String)rs.getOwner());
        }
        if (attribute.equals(Setup.COMMENT)) {
            return StringEscapeUtils.escapeHtml4((String)rs.getComment());
        }
        if (attribute.equals(" ") || attribute.equals("NO_NUMBER") || attribute.equals("NO_ROAD") || attribute.equals("NO_COLOR") || attribute.equals("NO_DESTINATION") || attribute.equals("NO_DEST_TRACK") || attribute.equals("NO_LOCATION") || attribute.equals("NO_TRACK") || attribute.equals(Setup.TAB) || attribute.equals(Setup.TAB2) || attribute.equals(Setup.TAB3)) {
            return "";
        }
        return String.format(Bundle.getMessage(this.locale, "ErrorPrintOptions"), attribute);
    }

    protected String getTrackComments(RouteLocation location, List<Car> cars) {
        StringBuilder builder = new StringBuilder();
        if (location.getLocation() != null) {
            List<Track> tracks = location.getLocation().getTracksByNameList(null);
            for (Track track : tracks) {
                boolean pickup = false;
                boolean setout = false;
                for (Car car : cars) {
                    if (car.getRouteLocation() == location && car.getTrack() != null && car.getTrack() == track) {
                        pickup = true;
                    }
                    if (car.getRouteDestination() != location || car.getDestinationTrack() == null || car.getDestinationTrack() != track) continue;
                    setout = true;
                }
                if (pickup && setout && !track.getCommentBoth().isEmpty()) {
                    builder.append(String.format(this.locale, this.strings.getProperty("TrackComments"), StringEscapeUtils.escapeHtml4((String)track.getCommentBoth())));
                    continue;
                }
                if (pickup && !setout && !track.getCommentPickup().isEmpty()) {
                    builder.append(String.format(this.locale, this.strings.getProperty("TrackComments"), StringEscapeUtils.escapeHtml4((String)track.getCommentPickup())));
                    continue;
                }
                if (pickup || !setout || track.getCommentSetout().isEmpty()) continue;
                builder.append(String.format(this.locale, this.strings.getProperty("TrackComments"), StringEscapeUtils.escapeHtml4((String)track.getCommentSetout())));
            }
        }
        return builder.toString();
    }

    public String getValidity() {
        if (Setup.isPrintTrainScheduleNameEnabled()) {
            return String.format(this.locale, this.strings.getProperty("ManifestValidityWithSchedule"), HtmlTrainCommon.getDate(true), InstanceManager.getDefault(TrainScheduleManager.class).getScheduleById(this.train.getId()));
        }
        return String.format(this.locale, this.strings.getProperty("ManifestValidity"), HtmlTrainCommon.getDate(true));
    }

    protected static enum ShowLocation {
        location,
        track,
        both;

    }
}

