/*
 * Decompiled with CFR 0.152.
 */
package jmri.web.servlet.operations;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.util.StdDateFormat;
import java.io.IOException;
import java.text.ParseException;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import jmri.InstanceManager;
import jmri.jmrit.operations.routes.RouteLocation;
import jmri.jmrit.operations.setup.Setup;
import jmri.jmrit.operations.trains.JsonManifest;
import jmri.jmrit.operations.trains.Train;
import jmri.jmrit.operations.trains.schedules.TrainScheduleManager;
import jmri.web.servlet.operations.HtmlTrainCommon;
import org.apache.commons.text.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HtmlManifest
extends HtmlTrainCommon {
    protected ObjectMapper mapper = new ObjectMapper();
    private JsonNode jsonManifest = null;
    private static final Logger log = LoggerFactory.getLogger(HtmlManifest.class);

    public HtmlManifest(Locale locale, Train train) throws IOException {
        super(locale, train);
        this.resourcePrefix = "Manifest";
    }

    public String getLocations() throws IOException {
        if (this.getJsonManifest() == null) {
            return "Error manifest file not found for this train";
        }
        StringBuilder builder = new StringBuilder();
        JsonNode locations = this.getJsonManifest().path("locations");
        String previousLocationName = null;
        for (JsonNode location : locations) {
            boolean hasWork;
            String routeLocationName;
            RouteLocation routeLocation;
            block57: {
                routeLocation = this.train.getRoute().getLocationById(location.path("name").textValue());
                log.debug("Processing {} ({})", (Object)routeLocation.getName(), (Object)location.path("name").textValue());
                routeLocationName = location.path("userName").textValue();
                builder.append(String.format(this.locale, this.strings.getProperty("LocationStart"), routeLocation.getId()));
                boolean bl = hasWork = location.path("cars").path("add").size() > 0 || location.path("cars").path("remove").size() > 0 || location.path("engines").path("add").size() > 0 || location.path("engines").path("remove").size() > 0;
                if (hasWork && !routeLocationName.equals(previousLocationName)) {
                    if (!this.train.isShowArrivalAndDepartureTimesEnabled()) {
                        builder.append(String.format(this.locale, this.strings.getProperty("ScheduledWorkAt"), routeLocationName));
                    } else if (routeLocation == this.train.getTrainDepartsRouteLocation()) {
                        builder.append(String.format(this.locale, this.strings.getProperty("WorkDepartureTime"), routeLocationName, this.train.getFormatedDepartureTime()));
                    } else if (!routeLocation.getDepartureTime().equals("")) {
                        builder.append(String.format(this.locale, this.strings.getProperty("WorkDepartureTime"), routeLocationName, routeLocation.getFormatedDepartureTime()));
                    } else if (Setup.isUseDepartureTimeEnabled() && routeLocation != this.train.getTrainTerminatesRouteLocation()) {
                        builder.append(String.format(this.locale, this.strings.getProperty("WorkDepartureTime"), routeLocationName, this.train.getExpectedDepartureTime(routeLocation)));
                    } else if (!this.train.getExpectedArrivalTime(routeLocation).equals("-1")) {
                        builder.append(String.format(this.locale, this.strings.getProperty("WorkArrivalTime"), routeLocationName, this.train.getExpectedArrivalTime(routeLocation)));
                    } else {
                        builder.append(String.format(this.locale, this.strings.getProperty("ScheduledWorkAt"), routeLocationName));
                    }
                    if (!location.path("comment").textValue().trim().isEmpty()) {
                        builder.append(String.format(this.locale, this.strings.getProperty("RouteLocationComment"), location.path("comment").textValue()));
                    }
                    builder.append(this.getTrackComments(location.path("track"), location.path("cars")));
                    if (Setup.isPrintLocationCommentsEnabled() && !location.path("location").path("comment").textValue().trim().isEmpty()) {
                        builder.append(String.format(this.locale, this.strings.getProperty("LocationComment"), location.path("location").path("comment").textValue()));
                    }
                }
                previousLocationName = routeLocationName;
                if (location.path("options").size() <= 0) break block57;
                boolean changeEngines = false;
                boolean changeCaboose = false;
                for (JsonNode option : location.path("options")) {
                    switch (option.asText()) {
                        case "changeEngines": {
                            changeEngines = true;
                            break;
                        }
                        case "changeCaboose": {
                            changeCaboose = true;
                            break;
                        }
                        case "addHelpers": {
                            builder.append(String.format(this.strings.getProperty("AddHelpersAt"), routeLocationName));
                            break;
                        }
                        case "removeHelpers": {
                            builder.append(String.format(this.strings.getProperty("RemoveHelpersAt"), routeLocationName));
                            break;
                        }
                    }
                }
                if (changeEngines && changeCaboose) {
                    builder.append(String.format(this.strings.getProperty("LocoAndCabooseChangeAt"), routeLocationName));
                } else if (changeEngines) {
                    builder.append(String.format(this.strings.getProperty("LocoChangeAt"), routeLocationName));
                } else if (changeCaboose) {
                    builder.append(String.format(this.strings.getProperty("CabooseChangeAt"), routeLocationName));
                }
            }
            builder.append(this.pickupEngines(location.path("engines").path("add")));
            builder.append(this.blockCars(location.path("cars"), routeLocation, true));
            builder.append(this.dropEngines(location.path("engines").path("remove")));
            if (routeLocation != this.train.getTrainTerminatesRouteLocation()) {
                RouteLocation rlNext = this.train.getRoute().getNextRouteLocation(routeLocation);
                if (routeLocationName.equals(HtmlManifest.splitString(rlNext.getName()))) continue;
                if (hasWork) {
                    if (!Setup.isPrintLoadsAndEmptiesEnabled()) {
                        builder.append(String.format(this.strings.getProperty("TrainDepartsCars"), routeLocationName, this.strings.getProperty("Heading" + Setup.getDirectionString(location.path("trainDirection").intValue())), location.path("length").path("length").intValue(), location.path("length").path("unit").asText().toLowerCase(), location.path("weight").intValue(), location.path("cars").path("total").intValue()));
                        continue;
                    }
                    builder.append(String.format(this.strings.getProperty("TrainDepartsLoads"), routeLocationName, this.strings.getProperty("Heading" + Setup.getDirectionString(location.path("trainDirection").intValue())), location.path("length").path("length").intValue(), location.path("length").path("unit").asText().toLowerCase(), location.path("weight").intValue(), location.path("cars").path("loads").intValue(), location.path("cars").path("empties").intValue()));
                    continue;
                }
                log.debug("No work ({})", (Object)routeLocation.getComment());
                if (routeLocation.getComment().trim().isEmpty()) {
                    if (this.train.isShowArrivalAndDepartureTimesEnabled()) {
                        if (routeLocation == this.train.getTrainDepartsRouteLocation()) {
                            builder.append(String.format(this.locale, this.strings.getProperty("NoScheduledWorkAtWithDepartureTime"), routeLocationName, this.train.getFormatedDepartureTime()));
                        } else if (!routeLocation.getDepartureTime().isEmpty()) {
                            builder.append(String.format(this.locale, this.strings.getProperty("NoScheduledWorkAtWithDepartureTime"), routeLocationName, routeLocation.getFormatedDepartureTime()));
                        } else if (Setup.isUseDepartureTimeEnabled()) {
                            builder.append(String.format(this.locale, this.strings.getProperty("NoScheduledWorkAtWithDepartureTime"), routeLocationName, location.path("expectedDepartureTime")));
                        } else {
                            builder.append(String.format(this.locale, this.strings.getProperty("NoScheduledWorkAt"), routeLocationName));
                        }
                    } else {
                        builder.append(String.format(this.locale, this.strings.getProperty("NoScheduledWorkAt"), routeLocationName));
                    }
                } else {
                    if (!routeLocation.getComment().equals("") && routeLocation.getComment().trim().length() > 0) {
                        builder.append(String.format(this.locale, this.strings.getProperty("CommentAt"), routeLocationName, StringEscapeUtils.escapeHtml4((String)routeLocation.getComment())));
                    }
                    if (this.train.isShowArrivalAndDepartureTimesEnabled()) {
                        if (routeLocation == this.train.getTrainDepartsRouteLocation()) {
                            builder.append(String.format(this.locale, this.strings.getProperty("CommentAtWithDepartureTime"), routeLocationName, this.train.getFormatedDepartureTime(), StringEscapeUtils.escapeHtml4((String)routeLocation.getComment())));
                        } else if (!routeLocation.getDepartureTime().equals("")) {
                            builder.append(String.format(this.locale, this.strings.getProperty("CommentAtWithDepartureTime"), routeLocationName, routeLocation.getFormatedDepartureTime(), StringEscapeUtils.escapeHtml4((String)routeLocation.getComment())));
                        } else if (Setup.isUseDepartureTimeEnabled() && !routeLocation.getComment().equals("")) {
                            builder.append(String.format(this.locale, this.strings.getProperty("NoScheduledWorkAtWithDepartureTime"), routeLocationName, this.train.getExpectedDepartureTime(routeLocation)));
                        }
                    }
                }
                if (!Setup.isPrintLocationCommentsEnabled() || routeLocation.getLocation().getComment().isEmpty()) continue;
                builder.append(String.format(this.locale, this.strings.getProperty("LocationComment"), StringEscapeUtils.escapeHtml4((String)routeLocation.getLocation().getComment())));
                continue;
            }
            builder.append(String.format(this.strings.getProperty("TrainTerminatesIn"), routeLocationName));
        }
        return builder.toString();
    }

    protected String blockCars(JsonNode cars, RouteLocation location, boolean isManifest) {
        StringBuilder builder = new StringBuilder();
        log.debug("Cars is {}", (Object)cars);
        for (JsonNode car : cars.path("add")) {
            if (this.isLocalMove(car)) continue;
            if (isManifest && Setup.isPrintTruncateManifestEnabled() && location.getLocation().isSwitchListEnabled()) {
                builder.append(this.pickUpCar(car, Setup.getPickupTruncatedManifestMessageFormat()));
                continue;
            }
            builder.append(this.pickUpCar(car, Setup.getPickupManifestMessageFormat()));
        }
        for (JsonNode car : cars.path("remove")) {
            boolean local = this.isLocalMove(car);
            if (isManifest && Setup.isPrintTruncateManifestEnabled() && location.getLocation().isSwitchListEnabled() && !this.train.isLocalSwitcher()) {
                builder.append(this.dropCar(car, Setup.getDropTruncatedManifestMessageFormat(), local));
                continue;
            }
            String[] format = isManifest ? (!local ? Setup.getDropManifestMessageFormat() : Setup.getLocalManifestMessageFormat()) : (!local ? Setup.getDropSwitchListMessageFormat() : Setup.getLocalSwitchListMessageFormat());
            builder.append(this.dropCar(car, format, local));
        }
        return String.format(this.locale, this.strings.getProperty("CarsList"), builder.toString());
    }

    protected String pickupUtilityCars(JsonNode cars, JsonNode car, RouteLocation location, boolean isManifest) {
        String[] messageFormat = isManifest ? Setup.getPickupUtilityManifestMessageFormat() : Setup.getPickupUtilitySwitchListMessageFormat();
        return this.pickUpCar(car, messageFormat);
    }

    protected String setoutUtilityCars(JsonNode cars, JsonNode car, RouteLocation location, boolean isManifest) {
        boolean isLocal = this.isLocalMove(car);
        String[] messageFormat = isLocal && isManifest ? Setup.getLocalUtilityManifestMessageFormat() : (isLocal && !isManifest ? Setup.getLocalUtilitySwitchListMessageFormat() : (!isLocal && !isManifest ? Setup.getDropUtilitySwitchListMessageFormat() : Setup.getDropUtilityManifestMessageFormat()));
        return this.dropCar(car, messageFormat, isLocal);
    }

    protected String pickUpCar(JsonNode car, String[] format) {
        if (this.isLocalMove(car)) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        String[] stringArray = format;
        int n = format.length;
        int n2 = 0;
        while (n2 < n) {
            String attribute = stringArray[n2];
            if (!attribute.trim().isEmpty()) {
                attribute = attribute.toLowerCase();
                log.debug("Adding car with attribute {}", (Object)attribute);
                if (attribute.equals("location") || attribute.equals("track")) {
                    attribute = "location";
                    builder.append(this.getFormattedAttribute(attribute, this.getPickupLocation(car.path(attribute), HtmlTrainCommon.ShowLocation.track))).append(" ");
                } else if (attribute.equals("destination")) {
                    builder.append(this.getFormattedAttribute(attribute, this.getDropLocation(car.path(attribute), HtmlTrainCommon.ShowLocation.location))).append(" ");
                } else if (attribute.equals("dest&track")) {
                    builder.append(this.getFormattedAttribute(attribute, this.getDropLocation(car.path("destination"), HtmlTrainCommon.ShowLocation.both))).append(" ");
                } else if (attribute.equals("type")) {
                    builder.append(this.getTextAttribute("carType", car)).append(" ");
                } else {
                    builder.append(this.getTextAttribute(attribute, car)).append(" ");
                }
            }
            ++n2;
        }
        log.debug("Picking up car {}", (Object)builder);
        return String.format(this.locale, this.strings.getProperty(String.valueOf(this.resourcePrefix) + "PickUpCar"), builder.toString());
    }

    protected String dropCar(JsonNode car, String[] format, boolean isLocal) {
        StringBuilder builder = new StringBuilder();
        log.debug("dropCar {}", (Object)car);
        String[] stringArray = format;
        int n = format.length;
        int n2 = 0;
        while (n2 < n) {
            String attribute = stringArray[n2];
            if (!attribute.trim().isEmpty()) {
                attribute = attribute.toLowerCase();
                log.debug("Removing car with attribute {}", (Object)attribute);
                if (attribute.equals("destination") || attribute.equals("track")) {
                    attribute = "destination";
                    builder.append(this.getFormattedAttribute(attribute, this.getDropLocation(car.path(attribute), HtmlTrainCommon.ShowLocation.track))).append(" ");
                } else if (attribute.equals("location") && isLocal) {
                    builder.append(this.getFormattedAttribute(attribute, this.getPickupLocation(car.path(attribute), HtmlTrainCommon.ShowLocation.track))).append(" ");
                } else if (attribute.equals("location")) {
                    builder.append(this.getFormattedAttribute(attribute, this.getPickupLocation(car.path(attribute), HtmlTrainCommon.ShowLocation.location))).append(" ");
                } else if (attribute.equals("type")) {
                    builder.append(this.getTextAttribute("carType", car)).append(" ");
                } else {
                    builder.append(this.getTextAttribute(attribute, car)).append(" ");
                }
            }
            ++n2;
        }
        log.debug("Dropping {}car {}", (Object)(isLocal ? "local " : ""), (Object)builder);
        if (!isLocal) {
            return String.format(this.locale, this.strings.getProperty(String.valueOf(this.resourcePrefix) + "DropCar"), builder.toString());
        }
        return String.format(this.locale, this.strings.getProperty(String.valueOf(this.resourcePrefix) + "LocalCar"), builder.toString());
    }

    protected String dropEngines(JsonNode engines) {
        StringBuilder builder = new StringBuilder();
        engines.forEach(engine -> builder.append(this.dropEngine((JsonNode)engine)));
        return String.format(this.locale, this.strings.getProperty("EnginesList"), builder.toString());
    }

    protected String dropEngine(JsonNode engine) {
        StringBuilder builder = new StringBuilder();
        String[] stringArray = Setup.getDropEngineMessageFormat();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String attribute = stringArray[n2];
            if (!attribute.trim().isEmpty()) {
                if ((attribute = attribute.toLowerCase()).equals("destination") || attribute.equals("track")) {
                    attribute = "destination";
                    builder.append(this.getFormattedAttribute(attribute, this.getDropLocation(engine.path(attribute), HtmlTrainCommon.ShowLocation.track))).append(" ");
                } else {
                    builder.append(this.getTextAttribute(attribute, engine)).append(" ");
                }
            }
            ++n2;
        }
        log.debug("Drop engine: {}", (Object)builder);
        return String.format(this.locale, this.strings.getProperty(String.valueOf(this.resourcePrefix) + "DropEngine"), builder.toString());
    }

    protected String pickupEngines(JsonNode engines) {
        StringBuilder builder = new StringBuilder();
        if (engines.size() > 0) {
            for (JsonNode engine : engines) {
                builder.append(this.pickupEngine(engine));
            }
        }
        return String.format(this.locale, this.strings.getProperty("EnginesList"), builder.toString());
    }

    protected String pickupEngine(JsonNode engine) {
        StringBuilder builder = new StringBuilder();
        log.debug("PickupEngineMessageFormat: {}", (Object)Setup.getPickupEngineMessageFormat());
        String[] stringArray = Setup.getPickupEngineMessageFormat();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String attribute = stringArray[n2];
            if (!attribute.trim().isEmpty()) {
                if ((attribute = attribute.toLowerCase()).equals("location") || attribute.equals("track")) {
                    attribute = "location";
                    builder.append(this.getFormattedAttribute(attribute, this.getPickupLocation(engine.path(attribute), HtmlTrainCommon.ShowLocation.track))).append(" ");
                } else {
                    builder.append(this.getTextAttribute(attribute, engine)).append(" ");
                }
            }
            ++n2;
        }
        log.debug("Picking up engine: {}", (Object)builder);
        return String.format(this.locale, this.strings.getProperty(String.valueOf(this.resourcePrefix) + "PickUpEngine"), builder.toString());
    }

    protected String getDropLocation(JsonNode location, HtmlTrainCommon.ShowLocation show) {
        return this.getFormattedLocation(location, show, "To");
    }

    protected String getPickupLocation(JsonNode location, HtmlTrainCommon.ShowLocation show) {
        return this.getFormattedLocation(location, show, "From");
    }

    protected String getTextAttribute(String attribute, JsonNode rollingStock) {
        if (attribute.equals("hazardous")) {
            return this.getFormattedAttribute(attribute, rollingStock.path(attribute).asBoolean() ? Setup.getHazardousMsg() : "");
        }
        if (attribute.equals(Setup.PICKUP_COMMENT.toLowerCase())) {
            return this.getFormattedAttribute("addComment", rollingStock.path("addComment").textValue());
        }
        if (attribute.equals(Setup.DROP_COMMENT.toLowerCase())) {
            return this.getFormattedAttribute("removeComment", rollingStock.path("removeComment").textValue());
        }
        if (attribute.equals(Setup.RWE.toLowerCase())) {
            return this.getFormattedLocation(rollingStock.path("returnWhenEmpty"), HtmlTrainCommon.ShowLocation.both, "RWE");
        }
        if (attribute.equals(Setup.FINAL_DEST.toLowerCase())) {
            return this.getFormattedLocation(rollingStock.path("finalDestination"), HtmlTrainCommon.ShowLocation.location, "FinalDestination");
        }
        if (attribute.equals(Setup.FINAL_DEST_TRACK.toLowerCase())) {
            return this.getFormattedLocation(rollingStock.path("finalDestination"), HtmlTrainCommon.ShowLocation.track, "FinalDestination");
        }
        return this.getFormattedAttribute(attribute, rollingStock.path(attribute).asText());
    }

    protected String getFormattedAttribute(String attribute, String value) {
        return String.format(this.locale, this.strings.getProperty("Attribute"), StringEscapeUtils.escapeHtml4((String)value), attribute);
    }

    protected String getFormattedLocation(JsonNode location, HtmlTrainCommon.ShowLocation show, String prefix) {
        if (location.isNull() || location.isEmpty()) {
            return "";
        }
        switch (show) {
            case location: {
                return String.format(this.locale, this.strings.getProperty(String.valueOf(prefix) + "Location"), HtmlManifest.splitString(location.path("userName").asText()));
            }
            case track: {
                return String.format(this.locale, this.strings.getProperty(String.valueOf(prefix) + "Track"), HtmlManifest.splitString(location.path("track").path("userName").asText()));
            }
        }
        return String.format(this.locale, this.strings.getProperty(String.valueOf(prefix) + "LocationAndTrack"), HtmlManifest.splitString(location.path("userName").asText()), HtmlManifest.splitString(location.path("track").path("userName").asText()));
    }

    private String getTrackComments(JsonNode tracks, JsonNode cars) {
        StringBuilder builder = new StringBuilder();
        if (tracks.size() > 0) {
            Iterator iterator = tracks.fields();
            while (iterator.hasNext()) {
                Map.Entry track = (Map.Entry)iterator.next();
                boolean pickup = false;
                boolean setout = false;
                if (cars.path("add").size() > 0) {
                    for (JsonNode car : cars.path("add")) {
                        if (!((String)track.getKey()).equals(car.path("track").path("name").textValue())) continue;
                        pickup = true;
                        break;
                    }
                }
                if (cars.path("remove").size() > 0) {
                    for (JsonNode car : cars.path("remove")) {
                        if (!((String)track.getKey()).equals(car.path("track").path("name").textValue())) continue;
                        setout = true;
                        break;
                    }
                }
                if (pickup && setout) {
                    builder.append(String.format(this.locale, this.strings.getProperty("TrackComments"), ((JsonNode)track.getValue()).path("addAndRemove").textValue()));
                    continue;
                }
                if (pickup) {
                    builder.append(String.format(this.locale, this.strings.getProperty("TrackComments"), ((JsonNode)track.getValue()).path("add").textValue()));
                    continue;
                }
                if (!setout) continue;
                builder.append(String.format(this.locale, this.strings.getProperty("TrackComments"), ((JsonNode)track.getValue()).path("remove").textValue()));
            }
        }
        return builder.toString();
    }

    protected boolean isLocalMove(JsonNode car) {
        if (car.path("location").path("route").isMissingNode() || car.path("destination").path("route").isMissingNode()) {
            return false;
        }
        return car.path("location").path("route").equals((Object)car.path("destination").path("route"));
    }

    protected boolean isUtilityCar(JsonNode car) {
        return car.path("utility").booleanValue();
    }

    protected JsonNode getJsonManifest() throws IOException {
        if (this.jsonManifest == null) {
            try {
                this.jsonManifest = this.mapper.readTree(new JsonManifest(this.train).getFile());
            }
            catch (IOException iOException) {
                log.error("Json manifest file not found for train ({})", (Object)this.train.getName());
            }
        }
        return this.jsonManifest;
    }

    @Override
    public String getValidity() {
        try {
            if (Setup.isPrintTrainScheduleNameEnabled()) {
                return String.format(this.locale, this.strings.getProperty(String.valueOf(this.resourcePrefix) + "ValidityWithSchedule"), HtmlManifest.getDate(new StdDateFormat().parse(this.getJsonManifest().path("date").textValue())), InstanceManager.getDefault(TrainScheduleManager.class).getScheduleById(this.train.getId()));
            }
            return String.format(this.locale, this.strings.getProperty(String.valueOf(this.resourcePrefix) + "Validity"), HtmlManifest.getDate(new StdDateFormat().parse(this.getJsonManifest().path("date").textValue())));
        }
        catch (NullPointerException nullPointerException) {
            log.warn("Manifest for train {} (id {}) does not have any validity.", (Object)this.train.getIconName(), (Object)this.train.getId());
        }
        catch (ParseException parseException) {
            log.error("Date of JSON manifest could not be parsed as a Date.");
        }
        catch (IOException iOException) {
            log.error("JSON manifest could not be read.");
        }
        return "";
    }
}

