/*
 * Decompiled with CFR 0.152.
 */
package jmri.web.servlet.operations;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import jmri.InstanceManager;
import jmri.jmrit.operations.locations.Track;
import jmri.jmrit.operations.rollingstock.cars.Car;
import jmri.jmrit.operations.rollingstock.cars.CarManager;
import jmri.jmrit.operations.rollingstock.engines.Engine;
import jmri.jmrit.operations.rollingstock.engines.EngineManager;
import jmri.jmrit.operations.routes.RouteLocation;
import jmri.jmrit.operations.setup.Setup;
import jmri.jmrit.operations.trains.Train;
import jmri.util.FileUtil;
import jmri.web.servlet.operations.Bundle;
import jmri.web.servlet.operations.HtmlTrainCommon;
import org.apache.commons.text.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HtmlConductor
extends HtmlTrainCommon {
    private static final Logger log = LoggerFactory.getLogger(HtmlConductor.class);

    public HtmlConductor(Locale locale, Train train) throws IOException {
        super(locale, train);
        this.resourcePrefix = "Conductor";
    }

    public String getLocation() throws IOException {
        RouteLocation location = this.train.getCurrentRouteLocation();
        if (location == null) {
            return String.format(this.locale, FileUtil.readURL(FileUtil.findURL(Bundle.getMessage(this.locale, "ConductorSnippet.html"))), this.train.getIconName(), StringEscapeUtils.escapeHtml4((String)this.train.getDescription()), StringEscapeUtils.escapeHtml4((String)this.train.getComment()), Setup.isPrintRouteCommentsEnabled() ? this.train.getRoute().getComment() : "", this.strings.getProperty("Terminated"), "", "", "", "", "", "", "", this.strings.getProperty("Terminated"), this.train.getStatusCode());
        }
        List<Engine> engineList = InstanceManager.getDefault(EngineManager.class).getByTrainBlockingList(this.train);
        List<Car> carList = InstanceManager.getDefault(CarManager.class).getByTrainDestinationList(this.train);
        log.debug("Train has {} cars assigned to it", (Object)carList.size());
        String pickups = this.performWork(true, false);
        String setouts = this.performWork(false, false);
        String localMoves = this.performWork(false, true);
        return String.format(this.locale, FileUtil.readURL(FileUtil.findURL(Bundle.getMessage(this.locale, "ConductorSnippet.html"))), this.train.getIconName(), StringEscapeUtils.escapeHtml4((String)this.train.getDescription()), StringEscapeUtils.escapeHtml4((String)this.train.getComment()), Setup.isPrintRouteCommentsEnabled() ? this.train.getRoute().getComment() : "", this.getCurrentAndNextLocation(), this.getLocationComments(), this.pickupEngines(engineList, location), pickups, setouts, localMoves, this.dropEngines(engineList, location), this.train.getNextRouteLocation(this.train.getCurrentRouteLocation()) != null ? this.train.getNextLocationName() : null, this.getMoveButton(), this.train.getStatusCode());
    }

    private String getCurrentAndNextLocation() {
        if (this.train.getCurrentRouteLocation() != null && this.train.getNextRouteLocation(this.train.getCurrentRouteLocation()) != null) {
            return String.format(this.locale, this.strings.getProperty("CurrentAndNextLocation"), StringEscapeUtils.escapeHtml4((String)HtmlConductor.splitString(this.train.getCurrentLocationName())), StringEscapeUtils.escapeHtml4((String)HtmlConductor.splitString(this.train.getNextLocationName())));
        }
        if (this.train.getCurrentRouteLocation() != null) {
            return StringEscapeUtils.escapeHtml4((String)HtmlConductor.splitString(this.train.getCurrentLocationName()));
        }
        return this.strings.getProperty("Terminated");
    }

    private String getMoveButton() {
        if (this.train.getNextRouteLocation(this.train.getCurrentRouteLocation()) != null) {
            return String.format(this.locale, this.strings.getProperty("MoveTo"), StringEscapeUtils.escapeHtml4((String)HtmlConductor.splitString(this.train.getNextLocationName())));
        }
        if (this.train.getCurrentRouteLocation() != null) {
            return this.strings.getProperty("Terminate");
        }
        return this.strings.getProperty("Terminated");
    }

    private String getEngineChanges(RouteLocation location) {
        if (this.train.getSecondLegOptions() != 0) {
            if (location == this.train.getSecondLegStartRouteLocation()) {
                return this.engineChange(location, this.train.getSecondLegOptions());
            }
            if (location == this.train.getSecondLegEndRouteLocation() && this.train.getSecondLegOptions() == 2) {
                return String.format(this.strings.getProperty("RemoveHelpersAt"), HtmlConductor.splitString(location.getName()));
            }
        }
        if (this.train.getThirdLegOptions() != 0) {
            if (location == this.train.getThirdLegStartRouteLocation()) {
                return this.engineChange(location, this.train.getSecondLegOptions());
            }
            if (location == this.train.getThirdLegEndRouteLocation() && this.train.getThirdLegOptions() == 2) {
                return String.format(this.strings.getProperty("RemoveHelpersAt"), HtmlConductor.splitString(location.getName()));
            }
        }
        return "";
    }

    private String getLocationComments() {
        List<Car> carList = InstanceManager.getDefault(CarManager.class).getByTrainDestinationList(this.train);
        StringBuilder builder = new StringBuilder();
        RouteLocation routeLocation = this.train.getCurrentRouteLocation();
        boolean work = HtmlConductor.isThereWorkAtLocation(this.train, routeLocation.getLocation());
        String routeLocationName = StringEscapeUtils.escapeHtml4((String)HtmlConductor.splitString(routeLocation.getName()));
        if (work) {
            if (!this.train.isShowArrivalAndDepartureTimesEnabled()) {
                builder.append(String.format(this.locale, this.strings.getProperty("ScheduledWorkAt"), routeLocationName));
            } else if (routeLocation == this.train.getTrainDepartsRouteLocation()) {
                builder.append(String.format(this.locale, this.strings.getProperty("WorkDepartureTime"), routeLocationName, this.train.getFormatedDepartureTime()));
            } else if (!routeLocation.getDepartureTime().equals("")) {
                builder.append(String.format(this.locale, this.strings.getProperty("WorkDepartureTime"), routeLocationName, routeLocation.getFormatedDepartureTime()));
            } else if (Setup.isUseDepartureTimeEnabled() && routeLocation != this.train.getTrainTerminatesRouteLocation() && !this.train.getExpectedDepartureTime(routeLocation).equals("-1")) {
                builder.append(String.format(this.locale, this.strings.getProperty("WorkDepartureTime"), routeLocationName, this.train.getExpectedDepartureTime(routeLocation)));
            } else if (!this.train.getExpectedArrivalTime(routeLocation).equals("-1")) {
                builder.append(String.format(this.locale, this.strings.getProperty("WorkArrivalTime"), routeLocationName, this.train.getExpectedArrivalTime(routeLocation)));
            } else {
                builder.append(String.format(this.locale, this.strings.getProperty("ScheduledWorkAt"), routeLocationName));
            }
            if (!routeLocation.getComment().trim().equals("")) {
                builder.append(String.format(this.locale, this.strings.getProperty("RouteLocationComment"), StringEscapeUtils.escapeHtml4((String)routeLocation.getComment())));
            }
            builder.append(this.getTrackComments(routeLocation, carList));
            if (Setup.isPrintLocationCommentsEnabled() && !routeLocation.getLocation().getComment().isEmpty()) {
                builder.append(String.format(this.locale, this.strings.getProperty("LocationComment"), StringEscapeUtils.escapeHtml4((String)routeLocation.getLocation().getComment())));
            }
        }
        builder.append(this.getEngineChanges(routeLocation));
        if (routeLocation != this.train.getTrainTerminatesRouteLocation()) {
            if (work) {
                if (!Setup.isPrintLoadsAndEmptiesEnabled()) {
                    builder.append(String.format(this.strings.getProperty("TrainDepartsCars"), routeLocationName, routeLocation.getTrainDirectionString(), this.train.getTrainLength(routeLocation), Setup.getLengthUnit().toLowerCase(), this.train.getTrainWeight(routeLocation), this.train.getNumberCarsInTrain(routeLocation)));
                } else {
                    int emptyCars = this.train.getNumberEmptyCarsInTrain(routeLocation);
                    builder.append(String.format(this.strings.getProperty("TrainDepartsLoads"), routeLocationName, routeLocation.getTrainDirectionString(), this.train.getTrainLength(routeLocation), Setup.getLengthUnit().toLowerCase(), this.train.getTrainWeight(routeLocation), this.train.getNumberCarsInTrain(routeLocation) - emptyCars, emptyCars));
                }
            } else {
                log.debug("No work ({})", (Object)routeLocation.getComment());
                if (routeLocation.getComment().trim().isEmpty()) {
                    if (this.train.isShowArrivalAndDepartureTimesEnabled()) {
                        if (routeLocation == this.train.getTrainDepartsRouteLocation()) {
                            builder.append(String.format(this.locale, this.strings.getProperty("NoScheduledWorkAtWithDepartureTime"), routeLocationName, this.train.getFormatedDepartureTime()));
                        } else if (!routeLocation.getDepartureTime().isEmpty()) {
                            builder.append(String.format(this.locale, this.strings.getProperty("NoScheduledWorkAtWithDepartureTime"), routeLocationName, routeLocation.getFormatedDepartureTime()));
                        } else {
                            builder.append(String.format(this.locale, this.strings.getProperty("NoScheduledWorkAt"), routeLocationName));
                        }
                    } else {
                        builder.append(String.format(this.locale, this.strings.getProperty("NoScheduledWorkAt"), routeLocationName));
                    }
                } else {
                    if (!routeLocation.getComment().equals("") && routeLocation.getComment().trim().length() > 0) {
                        builder.append(String.format(this.locale, this.strings.getProperty("CommentAt"), routeLocationName, StringEscapeUtils.escapeHtml4((String)routeLocation.getComment())));
                    }
                    if (this.train.isShowArrivalAndDepartureTimesEnabled()) {
                        if (routeLocation == this.train.getTrainDepartsRouteLocation()) {
                            builder.append(String.format(this.locale, this.strings.getProperty("CommentAtWithDepartureTime"), routeLocationName, this.train.getFormatedDepartureTime(), StringEscapeUtils.escapeHtml4((String)routeLocation.getComment())));
                        } else if (!routeLocation.getDepartureTime().equals("")) {
                            builder.append(String.format(this.locale, this.strings.getProperty("CommentAtWithDepartureTime"), routeLocationName, routeLocation.getFormatedDepartureTime(), StringEscapeUtils.escapeHtml4((String)routeLocation.getComment())));
                        } else if (Setup.isUseDepartureTimeEnabled() && !routeLocation.getComment().equals("")) {
                            builder.append(String.format(this.locale, this.strings.getProperty("NoScheduledWorkAtWithDepartureTime"), routeLocationName, this.train.getExpectedDepartureTime(routeLocation)));
                        }
                    }
                }
                if (Setup.isPrintLocationCommentsEnabled() && !routeLocation.getLocation().getComment().isEmpty()) {
                    builder.append(String.format(this.locale, this.strings.getProperty("LocationComment"), StringEscapeUtils.escapeHtml4((String)routeLocation.getLocation().getComment())));
                }
            }
        } else {
            builder.append(String.format(this.strings.getProperty("TrainTerminatesIn"), routeLocationName));
        }
        return builder.toString();
    }

    private String performWork(boolean pickup, boolean local) {
        if (pickup) {
            return this.pickupCars();
        }
        return this.dropCars(local);
    }

    private String pickupCars() {
        StringBuilder builder = new StringBuilder();
        RouteLocation location = this.train.getCurrentRouteLocation();
        List<Car> carList = InstanceManager.getDefault(CarManager.class).getByTrainDestinationList(this.train);
        List<Track> tracks = location.getLocation().getTracksByNameList(null);
        ArrayList<String> trackNames = new ArrayList<String>();
        ArrayList<String> pickedUp = new ArrayList<String>();
        this.clearUtilityCarTypes();
        for (Track track : tracks) {
            if (trackNames.contains(HtmlConductor.splitString(track.getName()))) continue;
            trackNames.add(HtmlConductor.splitString(track.getName()));
            for (RouteLocation rld : this.train.getRoute().getLocationsBySequenceList()) {
                for (Car car : carList) {
                    if (pickedUp.contains(car.getId()) || Setup.isSortByTrackNameEnabled() && !HtmlConductor.splitString(track.getName()).equals(HtmlConductor.splitString(car.getTrackName())) || car.getRouteLocation() != location || car.getTrack() == null || car.getRouteDestination() != rld) continue;
                    pickedUp.add(car.getId());
                    if (car.isUtility()) {
                        builder.append(this.pickupUtilityCars(carList, car, true));
                        continue;
                    }
                    if (Setup.isPrintTruncateManifestEnabled() && location.getLocation().isSwitchListEnabled()) {
                        builder.append(this.pickUpCar(car, Setup.getPickupTruncatedManifestMessageFormat()));
                        continue;
                    }
                    builder.append(this.pickUpCar(car, Setup.getPickupManifestMessageFormat()));
                }
            }
        }
        return builder.toString();
    }

    private String dropCars(boolean local) {
        StringBuilder builder = new StringBuilder();
        RouteLocation location = this.train.getCurrentRouteLocation();
        List<Car> carList = InstanceManager.getDefault(CarManager.class).getByTrainDestinationList(this.train);
        List<Track> tracks = location.getLocation().getTracksByNameList(null);
        ArrayList<String> trackNames = new ArrayList<String>();
        ArrayList<String> dropped = new ArrayList<String>();
        for (Track track : tracks) {
            if (trackNames.contains(HtmlConductor.splitString(track.getName()))) continue;
            trackNames.add(HtmlConductor.splitString(track.getName()));
            for (Car car : carList) {
                if (dropped.contains(car.getId()) || Setup.isSortByTrackNameEnabled() && !HtmlConductor.splitString(track.getName()).equals(HtmlConductor.splitString(car.getDestinationTrackName())) || car.isLocalMove() != local || car.getRouteDestination() != location || car.getDestinationTrack() == null) continue;
                dropped.add(car.getId());
                if (car.isUtility()) {
                    builder.append(this.setoutUtilityCars(carList, car, local));
                    continue;
                }
                String[] format = !local ? Setup.getDropManifestMessageFormat() : Setup.getLocalManifestMessageFormat();
                builder.append(this.dropCar(car, format, local));
            }
        }
        return builder.toString();
    }
}

