/*
 * Decompiled with CFR 0.152.
 */
package jmri.web.servlet.about;

import java.io.IOException;
import java.util.Locale;
import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jmri.Application;
import jmri.InstanceManager;
import jmri.Version;
import jmri.jmrix.ConnectionConfig;
import jmri.jmrix.ConnectionConfigManager;
import jmri.profile.Profile;
import jmri.profile.ProfileManager;
import jmri.util.FileUtil;
import jmri.web.servlet.ServletUtil;
import jmri.web.servlet.about.Bundle;

@WebServlet(name="AboutServlet", urlPatterns={"/about"})
public class AboutServlet
extends HttpServlet {
    protected void processRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        StringBuilder connList = new StringBuilder("");
        String comma = "";
        for (ConnectionConfig conn : InstanceManager.getDefault(ConnectionConfigManager.class)) {
            if (conn.getDisabled()) continue;
            connList.append(comma).append(Bundle.getMessage(request.getLocale(), "ConnectionSucceeded", conn.getConnectionName(), conn.name(), conn.getInfo()));
            comma = ", ";
        }
        response.setHeader("Connection", "Keep-Alive");
        response.setContentType("text/html; charset=utf-8");
        Profile profile = ProfileManager.getDefault().getActiveProfile();
        String profileName = profile != null ? profile.getName() : "";
        response.getWriter().print(String.format(request.getLocale(), FileUtil.readURL(FileUtil.findURL(Bundle.getMessage(request.getLocale(), "About.html"))), Bundle.getMessage(request.getLocale(), "AboutTitle"), InstanceManager.getDefault(ServletUtil.class).getNavBar(request.getLocale(), "/about"), InstanceManager.getDefault(ServletUtil.class).getRailroadName(false), InstanceManager.getDefault(ServletUtil.class).getFooter(request.getLocale(), "/about"), connList, String.valueOf(Application.getApplicationName()) + " " + Version.name(), Version.getCopyright(), System.getProperty("java.version", "<unknown>"), Locale.getDefault().toString(), profileName));
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    public String getServletInfo() {
        return "About Servlet";
    }
}

