/*
 * Decompiled with CFR 0.152.
 */
package jmri.web.servlet;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.Locale;
import javax.servlet.http.HttpServletResponse;
import jmri.InstanceManager;
import jmri.InstanceManagerAutoDefault;
import jmri.util.FileUtil;
import jmri.web.server.WebServerPreferences;
import jmri.web.servlet.Bundle;

public class ServletUtil
implements InstanceManagerAutoDefault {
    public static final String UTF8 = StandardCharsets.UTF_8.toString();
    public static final String APPLICATION_JAVASCRIPT = "application/javascript";
    public static final String APPLICATION_JSON = "application/json";
    public static final String APPLICATION_XML = "application/xml";
    public static final String IMAGE_PNG = "image/png";
    public static final String TEXT_HTML = "text/html";
    public static final String UTF8_CHARSET = "; charset=utf-8";
    public static final String UTF8_APPLICATION_JAVASCRIPT = "application/javascript; charset=utf-8";
    public static final String UTF8_APPLICATION_JSON = "application/json; charset=utf-8";
    public static final String UTF8_APPLICATION_XML = "application/xml; charset=utf-8";
    public static final String UTF8_TEXT_HTML = "text/html; charset=utf-8";
    public static final String HIDDEN = "hidden";

    public String getRailroadName(boolean inComments) {
        if (inComments) {
            return "-->" + InstanceManager.getDefault(WebServerPreferences.class).getRailroadName() + "<!--";
        }
        return InstanceManager.getDefault(WebServerPreferences.class).getRailroadName();
    }

    public String getFooter(Locale locale, String context) throws IOException {
        String footer = String.format(locale, String.format(locale, "-->%s<!--", FileUtil.readURL(FileUtil.findURL(Bundle.getMessage(locale, "Footer.html")))), this.getRailroadName(true));
        String clazz = "context" + context.replace("/", "-");
        footer = footer.replace(String.valueOf(clazz) + "-only", "show");
        footer = footer.replaceAll("context-[\\w-]*-only", HIDDEN);
        footer = footer.replace(clazz, "active");
        return footer;
    }

    public String getNavBar(Locale locale, String context) throws IOException {
        String navBar = String.format(locale, String.format(locale, "-->%s<!--", FileUtil.readURL(FileUtil.findURL(Bundle.getMessage(locale, "NavBar.html")))), this.getRailroadName(true));
        String clazz = "context" + context.replace("/", "-");
        navBar = navBar.replace(String.valueOf(clazz) + "-only", "show");
        navBar = navBar.replaceAll("context-[\\w-]*-only", HIDDEN);
        navBar = navBar.replace(clazz, "active");
        if (InstanceManager.getDefault(WebServerPreferences.class).allowRemoteConfig()) {
            navBar = navBar.replace("config-enabled-only", "show");
            navBar = navBar.replace("config-disabled-only", HIDDEN);
        } else {
            navBar = navBar.replace("config-enabled-only", HIDDEN);
            navBar = navBar.replace("config-disabled-only", "show");
        }
        if (!InstanceManager.getDefault(WebServerPreferences.class).isReadonlyPower()) {
            navBar = navBar.replace("data-power=\"readonly\"", "data-power=\"readwrite\"");
        }
        return navBar;
    }

    public Date setNonCachingHeaders(HttpServletResponse response) {
        Date now = new Date();
        response.setDateHeader("Date", now.getTime());
        response.setDateHeader("Last-Modified", now.getTime());
        response.setDateHeader("Expires", now.getTime());
        response.setHeader("Cache-control", "no-cache, no-store");
        response.setHeader("Pragma", "no-cache");
        return now;
    }

    public void writeFile(HttpServletResponse response, File file, String contentType) throws IOException {
        block13: {
            if (file.exists()) {
                if (file.canRead()) {
                    response.setContentType(contentType);
                    response.setStatus(200);
                    response.setContentLength((int)file.length());
                    Throwable throwable = null;
                    Object var5_6 = null;
                    try (FileInputStream fileInputStream = new FileInputStream(file);){
                        int bytes = fileInputStream.read();
                        while (bytes != -1) {
                            response.getOutputStream().write(bytes);
                            bytes = fileInputStream.read();
                        }
                        break block13;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                response.sendError(403);
            } else {
                response.sendError(404);
            }
        }
    }

    public String getTitle(Locale locale, String title) {
        return String.format(Bundle.getMessage(locale, "HtmlTitle"), this.getRailroadName(false), title);
    }
}

