/*
 * Decompiled with CFR 0.152.
 */
package jmri.web.server;

import java.awt.event.ItemListener;
import java.util.Arrays;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import jmri.InstanceManager;
import jmri.swing.PreferencesPanel;
import jmri.util.startup.PerformActionModel;
import jmri.util.startup.StartupActionsManager;
import jmri.util.startup.StartupModel;
import jmri.web.server.Bundle;
import jmri.web.server.WebServerAction;
import jmri.web.server.WebServerPreferences;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Binding;
import org.jdesktop.beansbinding.BindingGroup;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.ELProperty;
import org.jdesktop.beansbinding.Property;

public class WebServerPreferencesPanel
extends JPanel
implements PreferencesPanel {
    private JSpinner port;
    private JCheckBox readonlyPower;
    private JLabel portLabel;
    private final WebServerPreferences preferences = InstanceManager.getDefault(WebServerPreferences.class);
    private JCheckBox startup;
    private ItemListener startupItemListener;
    private int startupActionPosition = -1;
    private BindingGroup bindingGroup;

    public WebServerPreferencesPanel() {
        this.initComponents();
    }

    private void initComponents() {
        this.bindingGroup = new BindingGroup();
        this.port = new JSpinner();
        this.portLabel = new JLabel();
        this.readonlyPower = new JCheckBox();
        this.startup = new JCheckBox();
        this.port.setModel(new SpinnerNumberModel(12080, 1, 65535, 1));
        this.port.setEditor(new JSpinner.NumberEditor(this.port, "#"));
        this.port.setToolTipText(Bundle.getMessage("ToolTipPort"));
        this.bindingGroup.addBinding((Binding)Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.preferences, (Property)ELProperty.create((String)"${port}"), (Object)this.port, (Property)BeanProperty.create((String)"value")));
        this.portLabel.setText(Bundle.getMessage("LabelPort"));
        this.portLabel.setToolTipText(Bundle.getMessage("ToolTipPort"));
        this.readonlyPower.setText(Bundle.getMessage("LabelReadonlyPower"));
        this.readonlyPower.addActionListener(e -> this.readonlyPower.setToolTipText(Bundle.getMessage(this.readonlyPower.isSelected() ? "ToolTipReadonlyPowerTrue" : "ToolTipReadonlyPowerFalse")));
        this.bindingGroup.addBinding((Binding)Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.preferences, (Property)ELProperty.create((String)"${readonlyPower}"), (Object)this.readonlyPower, (Property)BeanProperty.create((String)"selected")));
        this.startup.setSelected(this.isStartupAction());
        this.startup.setText(Bundle.getMessage("LabelStartup"));
        this.startupItemListener = e -> {
            this.startup.removeItemListener(this.startupItemListener);
            StartupActionsManager manager = InstanceManager.getDefault(StartupActionsManager.class);
            if (this.startup.isSelected()) {
                PerformActionModel model2 = new PerformActionModel();
                model2.setClassName(WebServerAction.class.getName());
                if (this.startupActionPosition == -1 || this.startupActionPosition >= manager.getActions().length) {
                    manager.addAction(model2);
                } else {
                    manager.setActions(this.startupActionPosition, model2);
                }
            } else {
                manager.getActions(PerformActionModel.class).stream().filter(model -> WebServerAction.class.getName().equals(model.getClassName())).forEach(model -> {
                    this.startupActionPosition = Arrays.asList(manager.getActions()).indexOf(model);
                    manager.removeAction((StartupModel)model);
                });
            }
            this.startup.addItemListener(this.startupItemListener);
        };
        this.startup.addItemListener(this.startupItemListener);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.port, -2, 75, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.portLabel, -1, -1, Short.MAX_VALUE)).addComponent(this.startup, -1, 388, Short.MAX_VALUE).addComponent(this.readonlyPower, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.port, -2, -1, -2).addComponent(this.portLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.readonlyPower).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.startup).addContainerGap(198, Short.MAX_VALUE)));
        this.bindingGroup.bind();
    }

    @Override
    public String getPreferencesItem() {
        return Bundle.getMessage("PreferencesItem");
    }

    @Override
    public String getPreferencesItemText() {
        return Bundle.getMessage("PreferencesItemTitle");
    }

    @Override
    public String getTabbedPreferencesTitle() {
        return Bundle.getMessage("PreferencesItemTitle");
    }

    @Override
    public String getLabelKey() {
        return null;
    }

    @Override
    public JComponent getPreferencesComponent() {
        return this;
    }

    @Override
    public boolean isPersistant() {
        return false;
    }

    @Override
    public String getPreferencesTooltip() {
        return null;
    }

    @Override
    public void savePreferences() {
        this.preferences.save();
    }

    @Override
    public boolean isDirty() {
        return this.preferences.isDirty();
    }

    @Override
    public boolean isRestartRequired() {
        return this.preferences.isRestartRequired();
    }

    @Override
    public boolean isPreferencesValid() {
        return true;
    }

    @Override
    public int getSortOrder() {
        return 1100;
    }

    private boolean isStartupAction() {
        return InstanceManager.getDefault(StartupActionsManager.class).getActions(PerformActionModel.class).stream().anyMatch(model -> WebServerAction.class.getName().equals(model.getClassName()));
    }
}

