/*
 * Decompiled with CFR 0.152.
 */
package jmri.web.server;

import java.io.File;
import java.io.IOException;
import java.util.Set;
import jmri.implementation.AbstractInstanceInitializer;
import jmri.jmrit.XmlFile;
import jmri.util.FileUtil;
import jmri.web.server.WebServerPreferences;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class WebServerPreferencesInstanceInitializer
extends AbstractInstanceInitializer {
    private static final Logger log = LoggerFactory.getLogger(WebServerPreferencesInstanceInitializer.class);

    @Override
    public <T> Object getDefault(Class<T> type) {
        if (type == WebServerPreferences.class) {
            File webServerPrefsFile = new File(String.valueOf(FileUtil.getUserFilesPath()) + "networkServices" + File.separator + "WebServerPreferences.xml");
            File miniServerPrefsFile = new File(String.valueOf(FileUtil.getUserFilesPath()) + "miniserver" + File.separator + "MiniServerPreferences.xml");
            if (!webServerPrefsFile.exists() && miniServerPrefsFile.exists()) {
                this.preferencesFromMiniServerPreferences(miniServerPrefsFile, webServerPrefsFile);
            }
            if (!webServerPrefsFile.exists()) {
                return new WebServerPreferences();
            }
            return new WebServerPreferences(webServerPrefsFile.getAbsolutePath());
        }
        return super.getDefault(type);
    }

    @Override
    public Set<Class<?>> getInitalizes() {
        Set<Class<?>> set = super.getInitalizes();
        set.add(WebServerPreferences.class);
        return set;
    }

    private void preferencesFromMiniServerPreferences(File msFile, File wsFile) {
        XmlFile xmlFile = new XmlFile(){};
        try {
            boolean created;
            Element msRoot = xmlFile.rootFromFile(msFile);
            Element wsRoot = new Element("WebServerPreferences");
            Element msPrefs = msRoot.getChild("MiniServerPreferences");
            msPrefs.getChildren().forEach(arg_0 -> ((Element)wsRoot).addContent(arg_0));
            for (Attribute attr : msPrefs.getAttributes()) {
                switch (attr.getName()) {
                    case "getDisallowedFrames": {
                        String[] frames;
                        Element df = new Element("disallowedFrames");
                        String[] stringArray = frames = attr.getValue().split("\\n");
                        int n = frames.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String frame = stringArray[n2];
                            df.addContent((Content)new Element("frame").addContent(frame));
                            ++n2;
                        }
                        wsRoot.addContent((Content)df);
                        break;
                    }
                    case "getPort": {
                        wsRoot.setAttribute("port", attr.getValue());
                        break;
                    }
                    case "getClickDelay": {
                        wsRoot.setAttribute("clickDelay", attr.getValue());
                        break;
                    }
                    case "getRefreshDelay": {
                        wsRoot.setAttribute("refreshDelay", attr.getValue());
                        break;
                    }
                    default: {
                        wsRoot.setAttribute(attr.clone());
                    }
                }
            }
            Document wsDoc = XmlFile.newDocument(wsRoot);
            File parent = new File(wsFile.getParent());
            if (!parent.exists() && !(created = parent.mkdir())) {
                log.error("Failed to create directory {}", (Object)parent);
                throw new IOException("Failed to create directory " + parent.toString());
            }
            created = wsFile.createNewFile();
            if (!created) {
                log.error("Failed to new create file {}", (Object)wsFile);
                throw new IOException("Failed to create new file " + wsFile.toString());
            }
            xmlFile.writeXML(wsFile, wsDoc);
        }
        catch (IOException | JDOMException ex) {
            log.error("Error converting miniServer preferences to Web Server preferences.", ex);
        }
    }
}

