/*
 * Decompiled with CFR 0.152.
 */
package jmri.web.server;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ServiceLoader;
import javax.annotation.Nonnull;
import javax.servlet.Servlet;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import jmri.InstanceManager;
import jmri.ShutDownManager;
import jmri.server.web.spi.WebServerConfiguration;
import jmri.util.FileUtil;
import jmri.util.zeroconf.ZeroConfService;
import jmri.web.server.WebServerPreferences;
import jmri.web.servlet.DenialServlet;
import jmri.web.servlet.RedirectionServlet;
import jmri.web.servlet.directory.DirectoryHandler;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.server.handler.DefaultHandler;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.server.handler.HandlerList;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.component.LifeCycle;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class WebServer
implements LifeCycle,
LifeCycle.Listener {
    private final Server server;
    private ZeroConfService zeroConfService = null;
    private WebServerPreferences preferences = null;
    private Runnable shutDownTask = null;
    private final HashMap<String, Registration> registeredUrls = new HashMap();
    private static final Logger log = LoggerFactory.getLogger(WebServer.class);

    public WebServer() {
        this(InstanceManager.getDefault(WebServerPreferences.class));
    }

    public WebServer(WebServerPreferences preferences) {
        QueuedThreadPool threadPool = new QueuedThreadPool();
        threadPool.setName("WebServer");
        threadPool.setMaxThreads(1000);
        this.server = new Server((ThreadPool)threadPool);
        this.preferences = preferences;
    }

    @Nonnull
    public static WebServer getDefault() {
        return InstanceManager.getOptionalDefault(WebServer.class).orElseGet(() -> InstanceManager.setDefault(WebServer.class, new WebServer()));
    }

    public void start() {
        if (!this.server.isRunning()) {
            Throwable throwable = null;
            Object var2_3 = null;
            try (ServerConnector connector = new ServerConnector(this.server);){
                connector.setIdleTimeout(30000L);
                connector.setPort(this.preferences.getPort());
                this.server.setConnectors(new Connector[]{connector});
                this.server.setHandler((Handler)new ContextHandlerCollection());
                ServiceLoader.load(WebServerConfiguration.class).forEach(configuration -> {
                    configuration.getFilePaths().entrySet().forEach(resource -> this.registerResource((String)resource.getKey(), (String)resource.getValue()));
                    configuration.getRedirectedPaths().entrySet().forEach(redirection -> this.registerRedirection((String)redirection.getKey(), (String)redirection.getValue()));
                    configuration.getForbiddenPaths().forEach(this::registerDenial);
                });
                ServiceLoader.load(HttpServlet.class).forEach(servlet -> this.registerServlet((Class<? extends HttpServlet>)servlet.getClass(), (HttpServlet)servlet));
                this.server.addLifeCycleListener((LifeCycle.Listener)this);
                ServerThread serverThread = new ServerThread(this.server);
                serverThread.setName("WebServer");
                serverThread.start();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
    }

    public void stop() throws Exception {
        this.server.stop();
    }

    @Deprecated
    public static String URIforPortablePath(String path) {
        return WebServer.portablePathToURI(path);
    }

    public static String portablePathToURI(String path) {
        if (path.startsWith("preference:")) {
            return path.replaceFirst("preference:", "/prefs/");
        }
        if (path.startsWith("profile:")) {
            return path.replaceFirst("profile:", "/project/");
        }
        if (path.startsWith("settings:")) {
            return path.replaceFirst("settings:", "/settings/");
        }
        if (path.startsWith("program:")) {
            return path.replaceFirst("program:", "/dist/");
        }
        return null;
    }

    public int getPort() {
        return this.preferences.getPort();
    }

    public WebServerPreferences getPreferences() {
        return this.preferences;
    }

    public void registerDenial(String urlPattern) {
        this.registeredUrls.put(urlPattern, Registration.DENIAL);
        ServletContextHandler servletContext = new ServletContextHandler(0);
        servletContext.setContextPath(urlPattern);
        DenialServlet servlet = new DenialServlet();
        servletContext.addServlet(new ServletHolder((Servlet)servlet), "/*");
        ((HandlerCollection)this.server.getHandler()).addHandler((Handler)servletContext);
    }

    public void registerResource(String urlPattern, String filePath) {
        DirectoryHandler preferenceHandler;
        String debugMsg = "Setting up handler chain for {}";
        if (this.registeredUrls.get(urlPattern) != null) {
            throw new IllegalArgumentException("urlPattern \"" + urlPattern + "\" is already registered.");
        }
        this.registeredUrls.put(urlPattern, Registration.RESOURCE);
        ServletContextHandler servletContext = new ServletContextHandler(0);
        servletContext.setContextPath(urlPattern);
        HandlerList handlers = new HandlerList();
        if (filePath.startsWith("program:") && !filePath.equals("program:")) {
            log.debug(debugMsg, (Object)urlPattern);
            preferenceHandler = new DirectoryHandler(FileUtil.getAbsoluteFilename(filePath.replace("program:", "preference:")));
            DirectoryHandler projectHandler = new DirectoryHandler(FileUtil.getAbsoluteFilename(filePath.replace("program:", "profile:")));
            DirectoryHandler settingsHandler = new DirectoryHandler(FileUtil.getAbsoluteFilename(filePath.replace("program:", "settings:")));
            DirectoryHandler programHandler = new DirectoryHandler(FileUtil.getAbsoluteFilename(filePath));
            handlers.setHandlers(new Handler[]{preferenceHandler, projectHandler, settingsHandler, programHandler, new DefaultHandler()});
        } else if (filePath.startsWith("settings:") && !filePath.equals("settings:")) {
            log.debug(debugMsg, (Object)urlPattern);
            preferenceHandler = new DirectoryHandler(FileUtil.getAbsoluteFilename(filePath.replace("settings:", "preference:")));
            DirectoryHandler projectHandler = new DirectoryHandler(FileUtil.getAbsoluteFilename(filePath.replace("program:", "profile:")));
            DirectoryHandler settingsHandler = new DirectoryHandler(FileUtil.getAbsoluteFilename(filePath));
            handlers.setHandlers(new Handler[]{preferenceHandler, projectHandler, settingsHandler, new DefaultHandler()});
        } else if (filePath.startsWith("profile:") && !filePath.equals("profile:")) {
            log.debug(debugMsg, (Object)urlPattern);
            preferenceHandler = new DirectoryHandler(FileUtil.getAbsoluteFilename(filePath.replace("settings:", "preference:")));
            DirectoryHandler projectHandler = new DirectoryHandler(FileUtil.getAbsoluteFilename(filePath.replace("program:", "profile:")));
            handlers.setHandlers(new Handler[]{preferenceHandler, projectHandler, new DefaultHandler()});
        } else if (FileUtil.isPortableFilename(filePath)) {
            log.debug(debugMsg, (Object)urlPattern);
            DirectoryHandler handler = new DirectoryHandler(FileUtil.getAbsoluteFilename(filePath));
            handlers.setHandlers(new Handler[]{handler, new DefaultHandler()});
        } else if (WebServer.portablePathToURI(filePath) == null) {
            throw new IllegalArgumentException("\"" + filePath + "\" is not allowed.");
        }
        ContextHandler handlerContext = new ContextHandler();
        handlerContext.setContextPath(urlPattern);
        handlerContext.setHandler((Handler)handlers);
        ((HandlerCollection)this.server.getHandler()).addHandler((Handler)handlerContext);
    }

    public void registerRedirection(String urlPattern, String redirection) {
        Registration registered = this.registeredUrls.get(urlPattern);
        if (registered != null && registered != Registration.REDIRECTION) {
            throw new IllegalArgumentException("\"" + urlPattern + "\" registered to " + (Object)((Object)registered));
        }
        this.registeredUrls.put(urlPattern, Registration.REDIRECTION);
        ServletContextHandler servletContext = new ServletContextHandler(0);
        servletContext.setContextPath(urlPattern);
        RedirectionServlet servlet = new RedirectionServlet(urlPattern, redirection);
        servletContext.addServlet(new ServletHolder((Servlet)servlet), "");
        ((HandlerCollection)this.server.getHandler()).addHandler((Handler)servletContext);
    }

    public void registerServlet(Class<? extends HttpServlet> type) {
        this.registerServlet(type, null);
    }

    public void registerServlet(Class<? extends HttpServlet> type, HttpServlet instance) {
        this.registerServlet(0, type, instance).forEach(arg_0 -> ((HandlerCollection)((HandlerCollection)this.server.getHandler())).addHandler(arg_0));
    }

    private List<ServletContextHandler> registerServlet(int options, Class<? extends HttpServlet> type, HttpServlet instance) {
        WebServlet info = type.getAnnotation(WebServlet.class);
        ArrayList<ServletContextHandler> handlers = new ArrayList<ServletContextHandler>(info.urlPatterns().length);
        String[] stringArray = info.urlPatterns();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String pattern = stringArray[n2];
            if (this.registeredUrls.get(pattern) != Registration.DENIAL) {
                if (info.name().equals("DenialServlet")) {
                    this.registeredUrls.put(pattern, Registration.DENIAL);
                } else {
                    this.registeredUrls.put(pattern, Registration.SERVLET);
                }
                ServletContextHandler context = new ServletContextHandler(options);
                context.setContextPath(pattern);
                log.debug("Creating new {} for URL pattern {}", (Object)type.getName(), (Object)pattern);
                context.addServlet(type, "/*");
                handlers.add(context);
            } else {
                log.error("Unable to register servlet \"{}\" to provide denied URL {}", (Object)info.name(), (Object)pattern);
            }
            ++n2;
        }
        return handlers;
    }

    public void lifeCycleStarting(LifeCycle lc) {
        this.shutDownTask = () -> {
            try {
                this.server.stop();
            }
            catch (Exception ex) {
                log.warn("Error shutting down WebServer: {}", (Throwable)ex);
                log.debug("Details follow: ", (Throwable)ex);
            }
        };
        InstanceManager.getDefault(ShutDownManager.class).register(this.shutDownTask);
        log.info("Starting Web Server on port {}", (Object)this.preferences.getPort());
    }

    public void lifeCycleStarted(LifeCycle lc) {
        if (this.preferences.isUseZeroConf()) {
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.put("path", "/");
            properties.put("json", "5.4.0");
            log.info("Starting ZeroConfService _http._tcp.local for Web Server with properties {}", properties);
            this.zeroConfService = ZeroConfService.create("_http._tcp.local.", this.preferences.getPort(), properties);
            this.zeroConfService.publish();
        }
        log.debug("Web Server finished starting");
    }

    public void lifeCycleFailure(LifeCycle lc, Throwable thrwbl) {
        if (this.zeroConfService != null) {
            this.zeroConfService.stop();
        }
        log.error("Web Server failed", thrwbl);
    }

    public void lifeCycleStopping(LifeCycle lc) {
        if (this.zeroConfService != null) {
            this.zeroConfService.stop();
        }
        log.info("Stopping Web Server");
    }

    public void lifeCycleStopped(LifeCycle lc) {
        if (this.zeroConfService != null) {
            this.zeroConfService.stop();
        }
        InstanceManager.getDefault(ShutDownManager.class).deregister(this.shutDownTask);
        log.debug("Web Server stopped");
    }

    public boolean isRunning() {
        return this.server.isRunning();
    }

    public boolean isStarted() {
        return this.server.isStarted();
    }

    public boolean isStarting() {
        return this.server.isStarting();
    }

    public boolean isStopping() {
        return this.server.isStopping();
    }

    public boolean isStopped() {
        return this.server.isStopped();
    }

    public boolean isFailed() {
        return this.server.isFailed();
    }

    public void addLifeCycleListener(LifeCycle.Listener ll) {
        this.server.addLifeCycleListener(ll);
    }

    public void removeLifeCycleListener(LifeCycle.Listener ll) {
        this.server.removeLifeCycleListener(ll);
    }

    private static enum Registration {
        DENIAL,
        REDIRECTION,
        RESOURCE,
        SERVLET;

    }

    private static class ServerThread
    extends Thread {
        private final Server server;

        public ServerThread(Server server) {
            this.server = server;
        }

        @Override
        public void run() {
            try {
                this.server.start();
                this.server.join();
            }
            catch (Exception ex) {
                log.error("Exception starting Web Server", (Throwable)ex);
            }
        }
    }
}

