/*
 * Decompiled with CFR 0.152.
 */
package jmri.util.zeroconf;

import java.io.IOException;
import java.net.IDN;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import javax.annotation.Nonnull;
import javax.jmdns.JmDNS;
import javax.jmdns.JmmDNS;
import javax.jmdns.NetworkTopologyEvent;
import javax.jmdns.NetworkTopologyListener;
import javax.jmdns.ServiceInfo;
import jmri.Disposable;
import jmri.InstanceManager;
import jmri.InstanceManagerAutoDefault;
import jmri.ShutDownManager;
import jmri.Version;
import jmri.profile.ProfileManager;
import jmri.util.SystemType;
import jmri.util.node.NodeIdentity;
import jmri.util.zeroconf.ZeroConfPreferences;
import jmri.util.zeroconf.ZeroConfService;
import jmri.util.zeroconf.ZeroConfServiceEvent;
import jmri.web.server.WebServerPreferences;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZeroConfServiceManager
implements InstanceManagerAutoDefault,
Disposable {
    protected static final HashMap<InetAddress, JmDNS> JMDNS_SERVICES = new HashMap();
    private static final Logger log = LoggerFactory.getLogger(ZeroConfServiceManager.class);
    protected final HashMap<String, ZeroConfService> services = new HashMap();
    protected final NetworkListener networkListener = new NetworkListener(this);
    protected final Runnable shutDownTask = () -> ZeroConfServiceManager.dispose(this);
    protected final ZeroConfPreferences preferences = new ZeroConfPreferences(ProfileManager.getDefault().getActiveProfile());

    public ZeroConfService create(String type, int port) {
        return this.create(type, port, new HashMap<String, String>());
    }

    public ZeroConfService create(String type, int port, HashMap<String, String> properties) {
        return this.create(type, InstanceManager.getDefault(WebServerPreferences.class).getRailroadName(), port, 0, 0, properties);
    }

    public ZeroConfService create(String type, String name, int port, int weight, int priority, HashMap<String, String> properties) {
        ZeroConfService s;
        String key = this.key(type, name);
        if (this.services.containsKey(key)) {
            s = this.services.get(key);
            log.debug("Using existing ZeroConfService {}", (Object)s.getKey());
        } else {
            properties.put("version", Version.name());
            properties.put("jmri", Version.getCanonicalVersion());
            properties.put("node", NodeIdentity.networkIdentity());
            s = new ZeroConfService(ServiceInfo.create((String)type, (String)name, (int)port, (int)weight, (int)priority, properties));
            log.debug("Creating new ZeroConfService {} with properties {}", (Object)s.getKey(), properties);
        }
        return s;
    }

    protected String key(String type, String name) {
        return (String.valueOf(name) + "." + type).toLowerCase();
    }

    public void publish(ZeroConfService service) {
        if (!this.isPublished(service)) {
            this.services.put(service.getKey(), service);
            service.getListeners().stream().forEach(listener -> listener.serviceQueued(new ZeroConfServiceEvent(service, null)));
            for (JmDNS dns : this.getDNSes().values()) {
                ZeroConfServiceEvent event;
                try {
                    block13: {
                        InetAddress address = dns.getInetAddress();
                        if (address instanceof Inet6Address && !this.preferences.isUseIPv6()) {
                            log.debug("Ignoring IPv6 address {}", (Object)address.getHostAddress());
                            continue;
                        }
                        if (address instanceof Inet4Address && !this.preferences.isUseIPv4()) {
                            log.debug("Ignoring IPv4 address {}", (Object)address.getHostAddress());
                            continue;
                        }
                        if (address.isLinkLocalAddress() && !this.preferences.isUseLinkLocal()) {
                            log.debug("Ignoring link-local address {}", (Object)address.getHostAddress());
                            continue;
                        }
                        if (address.isLoopbackAddress() && !this.preferences.isUseLoopback()) {
                            log.debug("Ignoring loopback address {}", (Object)address.getHostAddress());
                            continue;
                        }
                        log.debug("Publishing ZeroConfService for '{}' on {}", (Object)service.getKey(), (Object)address.getHostAddress());
                        if (!service.containsServiceInfo(address)) {
                            ServiceInfo info;
                            try {
                                info = service.addServiceInfo(address);
                                dns.registerService(info);
                                log.debug("Register service '{}' on {} successful.", (Object)service.getKey(), (Object)address.getHostAddress());
                                break block13;
                            }
                            catch (IllegalStateException illegalStateException) {
                                try {
                                    log.debug("Initial attempt to register '{}' on {} failed.", (Object)service.getKey(), (Object)address.getHostAddress());
                                    info = service.addServiceInfo(address);
                                    log.debug("Retrying register '{}' on {}.", (Object)service.getKey(), (Object)address.getHostAddress());
                                    dns.registerService(info);
                                    break block13;
                                }
                                catch (IllegalStateException illegalStateException2) {
                                    log.debug("'{}' is already registered on {}.", (Object)service.getKey(), (Object)address.getHostAddress());
                                    continue;
                                }
                            }
                        }
                        log.debug("skipping '{}' on {}, already in serviceInfos.", (Object)service.getKey(), (Object)address.getHostAddress());
                    }
                    event = new ZeroConfServiceEvent(service, dns);
                }
                catch (IOException ex) {
                    log.error("Unable to publish service for '{}': {}", (Object)service.getKey(), (Object)ex.getMessage());
                    continue;
                }
                service.getListeners().stream().forEach(listener -> listener.servicePublished(event));
            }
        }
    }

    public void stop(ZeroConfService service) {
        log.debug("Stopping ZeroConfService {}", (Object)service.getKey());
        if (this.services.containsKey(service.getKey())) {
            this.getDNSes().values().parallelStream().forEach(dns -> {
                try {
                    InetAddress address = dns.getInetAddress();
                    try {
                        log.debug("Unregistering {} from {}", (Object)service.getKey(), (Object)address);
                        dns.unregisterService(service.getServiceInfo(address));
                        service.removeServiceInfo(address);
                        service.getListeners().stream().forEach(listener -> listener.serviceUnpublished(new ZeroConfServiceEvent(service, (JmDNS)dns)));
                    }
                    catch (NullPointerException nullPointerException) {
                        log.debug("{} already unregistered from {}", (Object)service.getKey(), (Object)address);
                    }
                }
                catch (IOException ex) {
                    log.error("Unable to stop ZeroConfService {}. {}", (Object)service.getKey(), (Object)ex.getLocalizedMessage());
                }
            });
            this.services.remove(service.getKey());
        }
    }

    public void stopAll() {
        this.stopAll(false);
    }

    private void stopAll(boolean close) {
        log.debug("Stopping all ZeroConfServices");
        CountDownLatch zcLatch = new CountDownLatch(this.services.size());
        new HashMap<String, ZeroConfService>(this.services).values().parallelStream().forEach(service -> {
            this.stop((ZeroConfService)service);
            zcLatch.countDown();
        });
        try {
            zcLatch.await();
        }
        catch (InterruptedException ex) {
            log.warn("ZeroConfService stop threads interrupted.", (Throwable)ex);
        }
        CountDownLatch nsLatch = new CountDownLatch(this.getDNSes().size());
        new HashMap<InetAddress, JmDNS>(this.getDNSes()).values().parallelStream().forEach(dns -> {
            Thread t = new Thread(() -> {
                dns.unregisterAllServices();
                if (close) {
                    try {
                        dns.close();
                    }
                    catch (IOException ex) {
                        log.debug("jmdns.close() returned IOException: {}", (Object)ex.getMessage());
                    }
                }
                nsLatch.countDown();
            });
            t.setName("dns.close in ZerConfServiceManager#stopAll");
            t.start();
        });
        try {
            zcLatch.await();
        }
        catch (InterruptedException ex) {
            log.warn("JmDNS unregister threads interrupted.", (Throwable)ex);
        }
        this.services.clear();
    }

    public Collection<ZeroConfService> allServices() {
        return this.services.values();
    }

    synchronized HashMap<InetAddress, JmDNS> getDNSes() {
        if (JMDNS_SERVICES.isEmpty()) {
            log.debug("JmDNS version: {}", (Object)JmDNS.VERSION);
            String name = ZeroConfServiceManager.hostName(NodeIdentity.networkIdentity());
            try {
                Enumeration<NetworkInterface> nis = NetworkInterface.getNetworkInterfaces();
                while (nis.hasMoreElements()) {
                    NetworkInterface ni = nis.nextElement();
                    try {
                        if (!ni.isUp()) continue;
                        Enumeration<InetAddress> niAddresses = ni.getInetAddresses();
                        while (niAddresses.hasMoreElements()) {
                            InetAddress address = niAddresses.nextElement();
                            log.debug("Calling JmDNS.create({}, '{}')", (Object)address.getHostAddress(), (Object)name);
                            try {
                                JMDNS_SERVICES.put(address, JmDNS.create((InetAddress)address, (String)name));
                            }
                            catch (IOException ex) {
                                log.warn("Unable to create JmDNS with error", (Throwable)ex);
                            }
                        }
                    }
                    catch (SocketException ex) {
                        log.error("Unable to read network interface {}.", (Object)ni, (Object)ex);
                    }
                }
            }
            catch (SocketException ex) {
                log.error("Unable to get network interfaces.", (Throwable)ex);
            }
            if (!SystemType.isMacOSX()) {
                JmmDNS.Factory.getInstance().addNetworkTopologyListener((NetworkTopologyListener)this.networkListener);
            }
            InstanceManager.getDefault(ShutDownManager.class).register(this.shutDownTask);
        }
        return new HashMap<InetAddress, JmDNS>(JMDNS_SERVICES);
    }

    @Nonnull
    public Set<InetAddress> getAddresses() {
        return this.getAddresses(Protocol.All);
    }

    @Nonnull
    public Set<InetAddress> getAddresses(Protocol protocol) {
        return this.getAddresses(protocol, true, false);
    }

    @Nonnull
    public Set<InetAddress> getAddresses(Protocol protocol, boolean useLinkLocal, boolean useLoopback) {
        HashSet<InetAddress> set = new HashSet<InetAddress>();
        if (protocol == Protocol.All) {
            set.addAll(this.getDNSes().keySet());
        } else {
            this.getDNSes().keySet().forEach(address -> {
                if (address instanceof Inet4Address && protocol == Protocol.IPv4) {
                    set.add((InetAddress)address);
                }
                if (address instanceof Inet6Address && protocol == Protocol.IPv6) {
                    set.add((InetAddress)address);
                }
            });
        }
        if (!useLinkLocal || !useLoopback) {
            new HashSet<InetAddress>(set).forEach(address -> {
                if (address.isLinkLocalAddress() && !useLinkLocal || address.isLoopbackAddress() && !useLoopback) {
                    set.remove(address);
                }
            });
        }
        return set;
    }

    @Nonnull
    public static String hostName(@Nonnull String string) {
        String puny = null;
        String name = string.toLowerCase(Locale.ROOT);
        name = name.replaceFirst("^[_\\.\\s]+", "");
        if (string.isEmpty()) {
            name = NodeIdentity.networkIdentity();
        }
        if (name.length() > 63) {
            name = name.substring(0, 63);
        }
        name = name.replaceAll("[_\\.\\s]", "-");
        while (puny == null || puny.length() > 63) {
            log.debug("name is \"{}\" prior to conversion", (Object)name);
            try {
                puny = IDN.toASCII(name, 1);
                if (puny.isEmpty()) {
                    name = NodeIdentity.networkIdentity();
                    puny = null;
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                puny = null;
            }
            name = name.length() > 1 ? name.substring(0, name.length() - 2) : NodeIdentity.networkIdentity();
        }
        return puny;
    }

    public String hostName(InetAddress address) {
        String hostName = String.valueOf(this.FQDN(address)) + ".";
        return hostName.substring(0, hostName.indexOf(46));
    }

    public String FQDN(InetAddress address) {
        return this.getDNSes().get(address).getHostName();
    }

    public ZeroConfPreferences getPreferences() {
        return this.preferences;
    }

    public boolean isPublished(ZeroConfService service) {
        return this.services.containsKey(service.getKey());
    }

    @Override
    public void dispose() {
        ZeroConfServiceManager.dispose(this);
        InstanceManager.getDefault(ShutDownManager.class).deregister(this.shutDownTask);
    }

    private static void dispose(ZeroConfServiceManager manager) {
        Date start = new Date();
        if (!SystemType.isMacOSX()) {
            JmmDNS.Factory.getInstance().removeNetworkTopologyListener((NetworkTopologyListener)manager.networkListener);
            log.debug("Removed network topology listener in {} milliseconds", (Object)(new Date().getTime() - start.getTime()));
        }
        start = new Date();
        log.debug("Starting to stop services...");
        manager.stopAll(true);
        log.debug("Stopped all services in {} milliseconds", (Object)(new Date().getTime() - start.getTime()));
    }

    protected static class NetworkListener
    implements NetworkTopologyListener {
        private final ZeroConfServiceManager manager;

        public NetworkListener(ZeroConfServiceManager manager) {
            this.manager = manager;
        }

        public void inetAddressAdded(NetworkTopologyEvent nte) {
            InetAddress address = nte.getInetAddress();
            if (address instanceof Inet6Address && !this.manager.preferences.isUseIPv6()) {
                log.debug("Ignoring IPv6 address {}", (Object)address.getHostAddress());
            } else if (address instanceof Inet4Address && !this.manager.preferences.isUseIPv4()) {
                log.debug("Ignoring IPv4 address {}", (Object)address.getHostAddress());
            } else if (address.isLinkLocalAddress() && !this.manager.preferences.isUseLinkLocal()) {
                log.debug("Ignoring link-local address {}", (Object)address.getHostAddress());
            } else if (address.isLoopbackAddress() && !this.manager.preferences.isUseLoopback()) {
                log.debug("Ignoring loopback address {}", (Object)address.getHostAddress());
            } else if (!JMDNS_SERVICES.containsKey(address)) {
                log.debug("Adding address {}", (Object)address.getHostAddress());
                JmDNS dns = nte.getDNS();
                JMDNS_SERVICES.put(address, dns);
                this.manager.allServices().stream().forEach(service -> {
                    try {
                        if (!service.containsServiceInfo(address)) {
                            log.debug("Publishing zeroConf service for '{}' on {}", (Object)service.getKey(), (Object)address.getHostAddress());
                            dns.registerService(service.addServiceInfo(address));
                            service.getListeners().stream().forEach(listener -> listener.servicePublished(new ZeroConfServiceEvent((ZeroConfService)service, dns)));
                        }
                    }
                    catch (IOException ex) {
                        log.error(ex.getLocalizedMessage(), (Throwable)ex);
                    }
                });
            } else {
                log.debug("Address {} already known.", (Object)address.getHostAddress());
            }
        }

        public void inetAddressRemoved(NetworkTopologyEvent nte) {
            InetAddress address = nte.getInetAddress();
            JmDNS dns = nte.getDNS();
            log.debug("Removing address {}", (Object)address);
            JMDNS_SERVICES.remove(address);
            dns.unregisterAllServices();
            this.manager.allServices().stream().forEach(service -> {
                service.removeServiceInfo(address);
                service.getListeners().stream().forEach(listener -> listener.servicePublished(new ZeroConfServiceEvent((ZeroConfService)service, dns)));
            });
        }
    }

    public static enum Protocol {
        IPv4,
        IPv6,
        All;

    }
}

