/*
 * Decompiled with CFR 0.152.
 */
package jmri.util.zeroconf;

import java.io.IOException;
import java.net.InetAddress;
import java.util.EventObject;
import javax.jmdns.JmDNS;
import jmri.util.zeroconf.ZeroConfService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZeroConfServiceEvent
extends EventObject {
    private final ZeroConfService service;
    private final JmDNS dns;
    private static final Logger log = LoggerFactory.getLogger(ZeroConfServiceEvent.class);

    protected ZeroConfServiceEvent(ZeroConfService service, JmDNS dns) {
        super(service);
        this.dns = dns;
        this.service = service;
    }

    public ZeroConfService getService() {
        return this.service;
    }

    public InetAddress getAddress() {
        try {
            return this.dns.getInetAddress();
        }
        catch (IOException ex) {
            log.error("Unable to get interface address.", (Throwable)ex);
            return null;
        }
    }
}

