/*
 * Decompiled with CFR 0.152.
 */
package jmri.util.zeroconf;

import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import jmri.beans.PreferencesBean;
import jmri.profile.Profile;
import jmri.profile.ProfileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZeroConfPreferences
extends PreferencesBean {
    private boolean useIPv4 = true;
    private boolean useIPv6 = true;
    private boolean useLoopback = false;
    private boolean useLinkLocal = true;
    @Deprecated
    private static final String IPv4 = "IPv4";
    @Deprecated
    private static final String IPv6 = "IPv6";
    public static final String USE_IP_V4 = "useIPv4";
    public static final String USE_IP_V6 = "useIPv6";
    public static final String USE_LOOPBACK = "useLoopback";
    public static final String USE_LINK_LOCAL = "useLinkLocal";
    private static final Logger log = LoggerFactory.getLogger(ZeroConfPreferences.class);

    public ZeroConfPreferences(Profile profile) {
        super(profile);
        Preferences localPreferences = ProfileUtils.getPreferences(null, this.getClass(), false);
        Preferences privatePreferences = ProfileUtils.getPreferences(profile, this.getClass(), false);
        Preferences sharedPreferences = ProfileUtils.getPreferences(profile, this.getClass(), true);
        this.useIPv4 = localPreferences.getBoolean(USE_IP_V4, privatePreferences.getBoolean(IPv4, sharedPreferences.getBoolean(IPv4, this.useIPv4)));
        this.useIPv6 = localPreferences.getBoolean(USE_IP_V6, privatePreferences.getBoolean(IPv6, sharedPreferences.getBoolean(IPv6, this.useIPv6)));
        this.useLinkLocal = localPreferences.getBoolean(USE_LINK_LOCAL, this.useLinkLocal);
        this.useLoopback = localPreferences.getBoolean(USE_LOOPBACK, this.useLoopback);
    }

    public boolean isUseIPv4() {
        return this.useIPv4;
    }

    public void setUseIPv4(boolean useIPv4) {
        boolean old = this.useIPv4;
        this.useIPv4 = useIPv4;
        this.savePreferences(this.getProfile());
        this.firePropertyChange(USE_IP_V4, old, useIPv4);
    }

    public boolean isUseIPv6() {
        return this.useIPv6;
    }

    public void setUseIPv6(boolean useIPv6) {
        boolean old = this.useIPv6;
        this.useIPv6 = useIPv6;
        this.savePreferences(this.getProfile());
        this.firePropertyChange(USE_IP_V6, old, useIPv6);
    }

    public boolean isUseLoopback() {
        return this.useLoopback;
    }

    public void setUseLoopback(boolean useLoopback) {
        boolean old = this.useLoopback;
        this.useLoopback = useLoopback;
        this.savePreferences(this.getProfile());
        this.firePropertyChange(USE_LOOPBACK, old, this.useIPv6);
    }

    public boolean isUseLinkLocal() {
        return this.useLinkLocal;
    }

    public void setUseLinkLocal(boolean useLinkLocal) {
        boolean old = this.useLinkLocal;
        this.useLinkLocal = useLinkLocal;
        this.savePreferences(this.getProfile());
        this.firePropertyChange(USE_LINK_LOCAL, old, useLinkLocal);
    }

    public void savePreferences(Profile profile) {
        Preferences localPreferences = ProfileUtils.getPreferences(null, this.getClass(), false);
        localPreferences.putBoolean(USE_IP_V4, this.useIPv4);
        localPreferences.putBoolean(USE_IP_V6, this.useIPv6);
        localPreferences.putBoolean(USE_LINK_LOCAL, this.useLinkLocal);
        localPreferences.putBoolean(USE_LOOPBACK, this.useLoopback);
        try {
            localPreferences.sync();
        }
        catch (BackingStoreException ex) {
            log.error("Unable to save preferences", (Throwable)ex);
        }
        try {
            localPreferences.remove(IPv4);
            localPreferences.remove(IPv6);
            Preferences sharedPreferences = ProfileUtils.getPreferences(profile, this.getClass(), true);
            sharedPreferences.remove(IPv4);
            sharedPreferences.remove(IPv6);
            Preferences privatePreferences = ProfileUtils.getPreferences(profile, this.getClass(), false);
            privatePreferences.remove(IPv4);
            privatePreferences.remove(IPv6);
        }
        catch (IllegalStateException ex) {
            log.error("Unable to remove no-longer-use preferences", (Throwable)ex);
        }
    }
}

