/*
 * Decompiled with CFR 0.152.
 */
package jmri.util.zeroconf;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import javax.jmdns.JmDNS;
import javax.jmdns.NetworkTopologyEvent;
import javax.jmdns.NetworkTopologyListener;
import javax.jmdns.ServiceEvent;
import javax.jmdns.ServiceInfo;
import javax.jmdns.ServiceListener;
import jmri.InstanceManager;
import jmri.util.zeroconf.ZeroConfServiceManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZeroConfClient {
    private ServiceListener mdnsServiceListener = null;
    private static final Logger log = LoggerFactory.getLogger(ZeroConfClient.class);

    public void startServiceListener(@Nonnull String service) {
        log.debug("StartServiceListener called for service: {}", (Object)service);
        if (this.mdnsServiceListener == null) {
            this.mdnsServiceListener = new NetworkServiceListener(service, this);
        }
        for (JmDNS server : InstanceManager.getDefault(ZeroConfServiceManager.class).getDNSes().values()) {
            server.addServiceListener(service, this.mdnsServiceListener);
        }
    }

    public void stopServiceListener(@Nonnull String service) {
        for (JmDNS server : InstanceManager.getDefault(ZeroConfServiceManager.class).getDNSes().values()) {
            server.removeServiceListener(service, this.mdnsServiceListener);
        }
    }

    public ServiceInfo getService(@Nonnull String service) {
        for (JmDNS server : InstanceManager.getDefault(ZeroConfServiceManager.class).getDNSes().values()) {
            ServiceInfo[] infos = server.list(service);
            if (infos == null) continue;
            return infos[0];
        }
        return null;
    }

    @Nonnull
    public List<ServiceInfo> getServices(@Nonnull String service) {
        ArrayList<ServiceInfo> services = new ArrayList<ServiceInfo>();
        for (JmDNS server : InstanceManager.getDefault(ZeroConfServiceManager.class).getDNSes().values()) {
            if (server.list(service) == null) continue;
            services.addAll(Arrays.asList(server.list(service)));
        }
        return services;
    }

    public ServiceInfo getServiceOnHost(@Nonnull String service, @Nonnull String hostname) {
        for (JmDNS server : InstanceManager.getDefault(ZeroConfServiceManager.class).getDNSes().values()) {
            ServiceInfo[] infos;
            ServiceInfo[] serviceInfoArray = infos = server.list(service);
            int n = infos.length;
            int n2 = 0;
            while (n2 < n) {
                ServiceInfo info = serviceInfoArray[n2];
                if (info.getServer().equals(hostname)) {
                    return info;
                }
                ++n2;
            }
        }
        return null;
    }

    public ServiceInfo getServicebyAdName(@Nonnull String service, @Nonnull String adName) {
        for (JmDNS server : InstanceManager.getDefault(ZeroConfServiceManager.class).getDNSes().values()) {
            ServiceInfo[] infos;
            ServiceInfo[] serviceInfoArray = infos = server.list(service);
            int n = infos.length;
            int n2 = 0;
            while (n2 < n) {
                ServiceInfo info = serviceInfoArray[n2];
                log.debug("Found Name: {}", (Object)info.getQualifiedName());
                if (info.getQualifiedName().equals(adName)) {
                    return info;
                }
                ++n2;
            }
        }
        return null;
    }

    @Nonnull
    public String[] getHostList(@Nonnull String service) {
        ArrayList<String> hostlist = new ArrayList<String>();
        for (JmDNS server : InstanceManager.getDefault(ZeroConfServiceManager.class).getDNSes().values()) {
            ServiceInfo[] infos;
            ServiceInfo[] serviceInfoArray = infos = server.list(service);
            int n = infos.length;
            int n2 = 0;
            while (n2 < n) {
                ServiceInfo info = serviceInfoArray[n2];
                hostlist.add(info.getServer());
                ++n2;
            }
        }
        return hostlist.toArray(new String[hostlist.size()]);
    }

    public static class NetworkServiceListener
    implements ServiceListener,
    NetworkTopologyListener {
        private final String service;
        private final ZeroConfClient client;

        protected NetworkServiceListener(String service, ZeroConfClient client) {
            this.service = service;
            this.client = client;
        }

        public void inetAddressAdded(NetworkTopologyEvent nte) {
            nte.getDNS().addServiceListener(this.service, (ServiceListener)this);
        }

        public void inetAddressRemoved(NetworkTopologyEvent nte) {
            nte.getDNS().removeServiceListener(this.service, (ServiceListener)this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void serviceAdded(ServiceEvent se) {
            log.debug("Service added: {}", (Object)se.getInfo().toString());
            ZeroConfClient zeroConfClient = this.client;
            synchronized (zeroConfClient) {
                this.client.notifyAll();
            }
        }

        public void serviceRemoved(ServiceEvent se) {
            log.debug("Service removed: {}", (Object)se.getInfo().toString());
        }

        public void serviceResolved(ServiceEvent se) {
            log.debug("Service resolved: {}", (Object)se.getInfo().toString());
        }
    }
}

