/*
 * Decompiled with CFR 0.152.
 */
package jmri.util.xml;

import java.io.CharConversionException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.Validator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;

public final class XMLUtil {
    private static final Logger log = LoggerFactory.getLogger(XMLUtil.class);
    private static final char[] DEC2HEX = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static SAXParserFactory[][] saxes = new SAXParserFactory[2][2];
    private static DocumentBuilderFactory[][] doms = new DocumentBuilderFactory[2][2];
    private static final String IDENTITY_XSLT_WITH_INDENT = "<xsl:stylesheet version='1.0' xmlns:xsl='http://www.w3.org/1999/XSL/Transform' xmlns:xalan='http://xml.apache.org/xslt' exclude-result-prefixes='xalan'><xsl:output method='xml' indent='yes' xalan:indent-amount='4'/><xsl:template match='@*|node()'><xsl:copy><xsl:apply-templates select='@*|node()'/></xsl:copy></xsl:template></xsl:stylesheet>";
    private static final String ORACLE_IS_STANDALONE = "http://www.oracle.com/xml/is-standalone";

    private XMLUtil() {
    }

    public static XMLReader createXMLReader() throws SAXException {
        return XMLUtil.createXMLReader(false, false);
    }

    public static XMLReader createXMLReader(boolean validate) throws SAXException {
        return XMLUtil.createXMLReader(validate, false);
    }

    public static synchronized XMLReader createXMLReader(boolean validate, boolean namespaceAware) throws SAXException {
        SAXParserFactory factory = saxes[validate ? 0 : 1][namespaceAware ? 0 : 1];
        if (factory == null) {
            factory = SAXParserFactory.newInstance();
            factory.setValidating(validate);
            factory.setNamespaceAware(namespaceAware);
            XMLUtil.saxes[validate ? 0 : 1][namespaceAware ? 0 : 1] = factory;
        }
        try {
            return factory.newSAXParser().getXMLReader();
        }
        catch (ParserConfigurationException ex) {
            throw new SAXException("Cannot create parser satisfying configuration parameters", ex);
        }
    }

    public static Document createDocument(String rootQName, String namespaceURI, String doctypePublicID, String doctypeSystemID) throws DOMException {
        DOMImplementation impl = XMLUtil.getDOMImplementation();
        if (doctypePublicID != null && doctypeSystemID == null) {
            throw new IllegalArgumentException("System ID cannot be null if public ID specified. ");
        }
        DocumentType dtd = null;
        if (doctypeSystemID != null) {
            dtd = impl.createDocumentType(rootQName, doctypePublicID, doctypeSystemID);
        }
        return impl.createDocument(namespaceURI, rootQName, dtd);
    }

    private static DOMImplementation getDOMImplementation() throws DOMException {
        DocumentBuilderFactory factory = XMLUtil.getFactory(false, false);
        try {
            return factory.newDocumentBuilder().getDOMImplementation();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new DOMException(9, "Cannot create parser satisfying configuration parameters");
        }
        catch (RuntimeException e) {
            throw (DOMException)new DOMException(9, e.toString()).initCause(e);
        }
    }

    private static synchronized DocumentBuilderFactory getFactory(boolean validate, boolean namespaceAware) {
        DocumentBuilderFactory factory = doms[validate ? 0 : 1][namespaceAware ? 0 : 1];
        if (factory == null) {
            factory = DocumentBuilderFactory.newInstance();
            factory.setValidating(validate);
            factory.setNamespaceAware(namespaceAware);
            XMLUtil.doms[validate ? 0 : 1][namespaceAware ? 0 : 1] = factory;
        }
        return factory;
    }

    public static Document parse(InputSource input, boolean validate, boolean namespaceAware, ErrorHandler errorHandler, EntityResolver entityResolver) throws IOException, SAXException {
        DocumentBuilder builder = null;
        DocumentBuilderFactory factory = XMLUtil.getFactory(validate, namespaceAware);
        try {
            builder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException ex) {
            throw new SAXException("Cannot create parser satisfying configuration parameters", ex);
        }
        if (errorHandler != null) {
            builder.setErrorHandler(errorHandler);
        }
        if (entityResolver != null) {
            builder.setEntityResolver(entityResolver);
        }
        return builder.parse(input);
    }

    public static void write(Document doc, OutputStream out, String enc) throws IOException {
        if (enc == null) {
            throw new NullPointerException("You must set an encoding; use \"UTF-8\" unless you have a good reason not to!");
        }
        Document doc2 = XMLUtil.normalize(doc);
        try {
            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer t = tf.newTransformer(new StreamSource(new StringReader(IDENTITY_XSLT_WITH_INDENT)));
            DocumentType dt = doc2.getDoctype();
            if (dt != null) {
                String sys;
                String pub = dt.getPublicId();
                if (pub != null) {
                    t.setOutputProperty("doctype-public", pub);
                }
                if ((sys = dt.getSystemId()) != null) {
                    t.setOutputProperty("doctype-system", sys);
                }
            }
            t.setOutputProperty("encoding", enc);
            try {
                t.setOutputProperty(ORACLE_IS_STANDALONE, "yes");
            }
            catch (IllegalArgumentException illegalArgumentException) {}
            HashSet<String> cdataQNames = new HashSet<String>();
            XMLUtil.collectCDATASections(doc2, cdataQNames);
            if (cdataQNames.size() > 0) {
                StringBuilder cdataSections = new StringBuilder();
                for (String s : cdataQNames) {
                    cdataSections.append(s).append(' ');
                }
                t.setOutputProperty("cdata-section-elements", cdataSections.toString());
            }
            DOMSource source = new DOMSource(doc2);
            StreamResult result = new StreamResult(out);
            t.transform(source, result);
        }
        catch (RuntimeException | TransformerException e) {
            throw new IOException(e);
        }
    }

    private static void collectCDATASections(Node node, Set<String> cdataQNames) {
        Node parent;
        if (node instanceof CDATASection && (parent = node.getParentNode()) != null) {
            String uri = parent.getNamespaceURI();
            if (uri != null) {
                cdataQNames.add("{" + uri + "}" + parent.getNodeName());
            } else {
                cdataQNames.add(parent.getNodeName());
            }
        }
        NodeList children = node.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            XMLUtil.collectCDATASections(children.item(i), cdataQNames);
            ++i;
        }
    }

    public static void validate(Element data, Schema schema) throws SAXException {
        SAXException[] error;
        block3: {
            Validator v = schema.newValidator();
            error = new SAXException[1];
            v.setErrorHandler(new ErrorHandler(){

                @Override
                public void warning(SAXParseException x) throws SAXException {
                }

                @Override
                public void error(SAXParseException x) throws SAXException {
                    error[0] = x;
                }

                @Override
                public void fatalError(SAXParseException x) throws SAXException {
                    error[0] = x;
                }
            });
            try {
                v.validate(new DOMSource(XMLUtil.fixupAttrs(data)));
            }
            catch (IOException x) {
                if ($assertionsDisabled) break block3;
                throw new AssertionError((Object)x);
            }
        }
        if (error[0] != null) {
            throw error[0];
        }
    }

    private static Element fixupAttrs(Element root) {
        Element copy = (Element)root.cloneNode(true);
        XMLUtil.fixupAttrsSingle(copy);
        NodeList nl = copy.getElementsByTagName("*");
        int i = 0;
        while (i < nl.getLength()) {
            XMLUtil.fixupAttrsSingle((Element)nl.item(i));
            ++i;
        }
        return copy;
    }

    private static void fixupAttrsSingle(Element e) throws DOMException {
        XMLUtil.removeXmlBase(e);
        HashMap<String, String> replace = new HashMap<String, String>();
        NamedNodeMap attrs = e.getAttributes();
        int j = 0;
        while (j < attrs.getLength()) {
            Attr attr = (Attr)attrs.item(j);
            if (attr.getNamespaceURI() == null && !attr.getName().equals("xmlns")) {
                replace.put(attr.getName(), attr.getValue());
            }
            ++j;
        }
        for (Map.Entry entry : replace.entrySet()) {
            e.removeAttribute((String)entry.getKey());
            e.setAttributeNS(null, (String)entry.getKey(), (String)entry.getValue());
        }
    }

    private static void removeXmlBase(Element e) {
        e.removeAttributeNS("http://www.w3.org/XML/1998/namespace", "base");
        e.removeAttribute("xml:base");
    }

    public static String toAttributeValue(String val) throws CharConversionException {
        if (val == null) {
            throw new CharConversionException("null");
        }
        if (XMLUtil.checkAttributeCharacters(val)) {
            return val;
        }
        StringBuilder buf = new StringBuilder();
        int i = 0;
        while (i < val.length()) {
            char ch = val.charAt(i);
            if ('<' == ch) {
                buf.append("&lt;");
            } else if ('&' == ch) {
                buf.append("&amp;");
            } else if ('\'' == ch) {
                buf.append("&apos;");
            } else if ('\"' == ch) {
                buf.append("&quot;");
            } else {
                buf.append(ch);
            }
            ++i;
        }
        return buf.toString();
    }

    public static String toElementContent(String val) throws CharConversionException {
        if (val == null) {
            throw new CharConversionException("null");
        }
        if (XMLUtil.checkContentCharacters(val)) {
            return val;
        }
        StringBuilder buf = new StringBuilder();
        int i = 0;
        while (i < val.length()) {
            char ch = val.charAt(i);
            if ('<' == ch) {
                buf.append("&lt;");
            } else if ('&' == ch) {
                buf.append("&amp;");
            } else if ('>' == ch && i > 1 && val.charAt(i - 2) == ']' && val.charAt(i - 1) == ']') {
                buf.append("&gt;");
            } else {
                buf.append(ch);
            }
            ++i;
        }
        return buf.toString();
    }

    public static String toHex(byte[] val, int start, int len) {
        StringBuilder buf = new StringBuilder();
        int i = 0;
        while (i < len) {
            byte b = val[start + i];
            buf.append(DEC2HEX[(b & 0xF0) >> 4]);
            buf.append(DEC2HEX[b & 0xF]);
            ++i;
        }
        return buf.toString();
    }

    public static byte[] fromHex(char[] hex, int start, int len) throws IOException {
        if (hex == null) {
            throw new IOException("null");
        }
        int i = hex.length;
        if (i % 2 != 0) {
            throw new IOException("odd length");
        }
        byte[] magic = new byte[i / 2];
        while (i > 0) {
            String g = new String(hex, i - 2, 2);
            try {
                magic[i / 2 - 1] = (byte)Integer.parseInt(g, 16);
            }
            catch (NumberFormatException ex) {
                throw new IOException(ex.getLocalizedMessage());
            }
            i -= 2;
        }
        return magic;
    }

    private static boolean checkAttributeCharacters(String chars) throws CharConversionException {
        boolean escape = false;
        int i = 0;
        while (i < chars.length()) {
            char ch = chars.charAt(i);
            if (ch <= ']') {
                switch (ch) {
                    case '\t': 
                    case '\n': 
                    case '\r': {
                        break;
                    }
                    case '\"': 
                    case '&': 
                    case '\'': 
                    case '<': {
                        escape = true;
                        break;
                    }
                    default: {
                        if (ch >= ' ') break;
                        throw new CharConversionException("Invalid XML character &#" + ch + ";.");
                    }
                }
            }
            ++i;
        }
        return !escape;
    }

    private static boolean checkContentCharacters(String chars) throws CharConversionException {
        boolean escape = false;
        int i = 0;
        while (i < chars.length()) {
            char ch = chars.charAt(i);
            if (ch <= ']') {
                switch (ch) {
                    case '\t': 
                    case '\n': 
                    case '\r': {
                        break;
                    }
                    case '>': {
                        if (escape) break;
                        escape = i > 0 && chars.charAt(i - 1) == ']';
                        break;
                    }
                    case '&': 
                    case '<': {
                        escape = true;
                        break;
                    }
                    default: {
                        if (ch >= ' ') break;
                        throw new CharConversionException("Invalid XML character &#" + ch + ";.");
                    }
                }
            }
            ++i;
        }
        return !escape;
    }

    private static Document normalize(Document orig) throws IOException {
        Document doc;
        DocumentBuilder builder = null;
        DocumentBuilderFactory factory = XMLUtil.getFactory(false, false);
        try {
            builder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new IOException("Cannot create parser satisfying configuration parameters: " + e, e);
        }
        DocumentType doctype = null;
        NodeList nl = orig.getChildNodes();
        int i = 0;
        while (i < nl.getLength()) {
            if (nl.item(i) instanceof DocumentType) {
                doctype = (DocumentType)nl.item(i);
            }
            ++i;
        }
        if (doctype != null) {
            doc = builder.getDOMImplementation().createDocument(orig.getDocumentElement().getNamespaceURI(), orig.getDocumentElement().getTagName(), builder.getDOMImplementation().createDocumentType(orig.getDoctype().getName(), orig.getDoctype().getPublicId(), orig.getDoctype().getSystemId()));
            doc.removeChild(doc.getDocumentElement());
        } else {
            doc = builder.newDocument();
        }
        int i2 = 0;
        while (i2 < nl.getLength()) {
            Node node = nl.item(i2);
            if (!(node instanceof DocumentType)) {
                try {
                    doc.appendChild(doc.importNode(node, true));
                }
                catch (DOMException x) {
                    throw new IOException("Could not import or append " + node + " of " + node.getClass(), x);
                }
            }
            ++i2;
        }
        doc.normalize();
        nl = doc.getElementsByTagName("*");
        i2 = 0;
        while (i2 < nl.getLength()) {
            Element e = (Element)nl.item(i2);
            XMLUtil.removeXmlBase(e);
            NodeList nl2 = e.getChildNodes();
            int j = 0;
            while (j < nl2.getLength()) {
                Node n = nl2.item(j);
                if (n instanceof Text && ((Text)n).getNodeValue().trim().length() == 0) {
                    e.removeChild(n);
                    --j;
                }
                ++j;
            }
            ++i2;
        }
        return doc;
    }

    public static void appendChildElement(Element parent, Element el, String[] order) throws IllegalArgumentException {
        List<String> l = Arrays.asList(order);
        int index = l.indexOf(el.getLocalName());
        if (index == -1) {
            throw new IllegalArgumentException("new child element '" + el.getLocalName() + "' not specified in order " + l);
        }
        List<Element> elements = XMLUtil.findSubElements(parent);
        Element insertBefore = null;
        for (Element e : elements) {
            int index2 = l.indexOf(e.getLocalName());
            if (index2 == -1) {
                throw new IllegalArgumentException("Existing child element '" + e.getLocalName() + "' not specified in order " + l);
            }
            if (index2 <= index) continue;
            insertBefore = e;
            break;
        }
        parent.insertBefore(el, insertBefore);
    }

    public static List<Element> findSubElements(Element parent) throws IllegalArgumentException {
        NodeList l = parent.getChildNodes();
        ArrayList<Element> elements = new ArrayList<Element>(l.getLength());
        int i = 0;
        while (i < l.getLength()) {
            Node n = l.item(i);
            if (n.getNodeType() == 1) {
                elements.add((Element)n);
            } else if (n.getNodeType() == 3) {
                String text = ((Text)n).getNodeValue();
                if (text.trim().length() > 0) {
                    throw new IllegalArgumentException("non-ws text encountered in " + parent + ": " + text);
                }
            } else if (n.getNodeType() != 8) {
                throw new IllegalArgumentException("unexpected non-element child of " + parent + ": " + n);
            }
            ++i;
        }
        return elements;
    }

    public static Element findElement(Element parent, String name, String namespace) throws IllegalArgumentException {
        Element result = null;
        NodeList l = parent.getChildNodes();
        int nodeCount = l.getLength();
        int i = 0;
        while (i < nodeCount) {
            if (l.item(i).getNodeType() == 1) {
                Node node = l.item(i);
                String localName = node.getLocalName();
                String string = localName = localName == null ? node.getNodeName() : localName;
                if (name.equals(localName) && (namespace == null || namespace.equals(node.getNamespaceURI()))) {
                    if (result == null) {
                        result = (Element)node;
                    } else {
                        throw new IllegalArgumentException("more than one element with same name found");
                    }
                }
            }
            ++i;
        }
        return result;
    }

    public static String findText(Node parent) {
        NodeList l = parent.getChildNodes();
        int i = 0;
        while (i < l.getLength()) {
            if (l.item(i).getNodeType() == 3) {
                Text text = (Text)l.item(i);
                return text.getNodeValue();
            }
            ++i;
        }
        return null;
    }

    public static Element translateXML(Element from, String namespace) {
        Element to = from.getOwnerDocument().createElementNS(namespace, from.getLocalName());
        NodeList nl = from.getChildNodes();
        int length = nl.getLength();
        int i = 0;
        while (i < length) {
            Node node = nl.item(i);
            Node newNode = node.getNodeType() == 1 ? XMLUtil.translateXML((Element)node, namespace) : node.cloneNode(true);
            to.appendChild(newNode);
            ++i;
        }
        NamedNodeMap m = from.getAttributes();
        int i2 = 0;
        while (i2 < m.getLength()) {
            Node attr = m.item(i2);
            to.setAttribute(attr.getNodeName(), attr.getNodeValue());
            ++i2;
        }
        return to;
    }

    public static void copyDocument(Element from, Element to, String newNamespace) {
        Document doc = to.getOwnerDocument();
        NodeList nl = from.getChildNodes();
        int length = nl.getLength();
        int i = 0;
        while (i < length) {
            Node node = nl.item(i);
            Node newNode = null;
            if (1 == node.getNodeType()) {
                Element oldElement = (Element)node;
                newNode = doc.createElementNS(newNamespace, oldElement.getTagName());
                NamedNodeMap m = oldElement.getAttributes();
                Element newElement = (Element)newNode;
                int index = 0;
                while (index < m.getLength()) {
                    Node attr = m.item(index);
                    newElement.setAttribute(attr.getNodeName(), attr.getNodeValue());
                    ++index;
                }
                XMLUtil.copyDocument(oldElement, newElement, newNamespace);
            } else {
                newNode = node.cloneNode(true);
                newNode = to.getOwnerDocument().importNode(newNode, true);
            }
            if (newNode != null) {
                to.appendChild(newNode);
            }
            ++i;
        }
    }

    public static ErrorHandler defaultErrorHandler() {
        return new ErrHandler();
    }

    private static final class ErrHandler
    implements ErrorHandler {
        ErrHandler() {
        }

        private void annotate(SAXParseException exception) throws SAXException {
            log.error(null, (Throwable)exception);
        }

        @Override
        public void fatalError(SAXParseException exception) throws SAXException {
            this.annotate(exception);
            throw exception;
        }

        @Override
        public void error(SAXParseException exception) throws SAXException {
            this.annotate(exception);
            throw exception;
        }

        @Override
        public void warning(SAXParseException exception) throws SAXException {
            log.warn(null, (Throwable)exception);
        }
    }
}

