/*
 * Decompiled with CFR 0.152.
 */
package jmri.util.usb;

import java.io.UnsupportedEncodingException;
import java.util.List;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import javax.usb.UsbDevice;
import javax.usb.UsbDisconnectedException;
import javax.usb.UsbException;
import javax.usb.UsbHostManager;
import javax.usb.UsbHub;
import javax.usb.UsbPort;
import javax.usb.event.UsbServicesEvent;
import javax.usb.event.UsbServicesListener;
import jmri.util.usb.Bundle;
import jmri.util.usb.UsbUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UsbBrowserPanel
extends JPanel {
    private UsbTreeNode root;
    private final UsbDeviceTableModel deviceModel = new UsbDeviceTableModel();
    private static final Logger log = LoggerFactory.getLogger(UsbBrowserPanel.class);
    private final transient UsbServicesListener usbServicesListener = new UsbServicesListener(){

        public void usbDeviceAttached(UsbServicesEvent use) {
            UsbDevice usbDevice = use.getUsbDevice();
            UsbPort usbPort = usbDevice.getParentUsbPort();
            if (usbPort != null) {
                UsbHub parentUsbDevice = usbPort.getUsbHub();
                UsbTreeNode parentNode = UsbBrowserPanel.this.findNodeForDevice(UsbBrowserPanel.this.root, (UsbDevice)parentUsbDevice);
                if (parentNode != null) {
                    UsbTreeNode node = new UsbTreeNode(usbDevice);
                    parentNode.add(node);
                    if (UsbBrowserPanel.this.usbTree != null) {
                        TreePath selection = UsbBrowserPanel.this.usbTree.getSelectionPath();
                        ((DefaultTreeModel)UsbBrowserPanel.this.usbTree.getModel()).nodeChanged(parentNode);
                        ((DefaultTreeModel)UsbBrowserPanel.this.usbTree.getModel()).reload(UsbBrowserPanel.this.root);
                        UsbBrowserPanel.this.usbTree.setSelectionPath(selection);
                    }
                    return;
                }
            }
            UsbTreeNode root = UsbBrowserPanel.this.getRootNode();
            root.removeAllChildren();
            UsbBrowserPanel.this.buildTree(root);
        }

        public void usbDeviceDetached(UsbServicesEvent use) {
            UsbDevice usbDevice;
            UsbTreeNode root = UsbBrowserPanel.this.getRootNode();
            UsbTreeNode usbTreeNode = UsbBrowserPanel.this.findNodeForDevice(root, usbDevice = use.getUsbDevice());
            if (usbTreeNode != null) {
                TreeNode parentTreeNode = usbTreeNode.getParent();
                usbTreeNode.removeFromParent();
                if (UsbBrowserPanel.this.usbTree != null) {
                    TreePath selection = UsbBrowserPanel.this.usbTree.getSelectionPath();
                    if (parentTreeNode != null) {
                        ((DefaultTreeModel)UsbBrowserPanel.this.usbTree.getModel()).reload(parentTreeNode);
                    } else {
                        ((DefaultTreeModel)UsbBrowserPanel.this.usbTree.getModel()).reload(root);
                    }
                    UsbBrowserPanel.this.usbTree.setSelectionPath(selection);
                }
            } else {
                root.removeAllChildren();
                UsbBrowserPanel.this.buildTree(root);
            }
        }
    };
    private final TreeSelectionListener treeSelectionListener = e -> {
        UsbTreeNode node = (UsbTreeNode)this.usbTree.getLastSelectedPathComponent();
        if (node != null) {
            this.deviceModel.setNode(node);
        } else {
            this.usbTree.setSelectionPath(e.getNewLeadSelectionPath());
        }
    };
    private JTable detailsTable;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JSplitPane jSplitPane1;
    private JTree usbTree;

    public UsbBrowserPanel() {
        this.root = this.getRootNode();
        this.buildTree(this.root);
        if (this.root.getUserObject() != null) {
            try {
                UsbHostManager.getUsbServices().addUsbServicesListener(this.usbServicesListener);
            }
            catch (SecurityException | UsbException ex) {
                log.error("Unable to get root USB hub.", ex);
            }
        }
        this.initComponents();
        int i = 0;
        while (i < this.usbTree.getRowCount()) {
            this.usbTree.expandRow(i);
            ++i;
        }
    }

    protected UsbTreeNode getRootNode() {
        if (this.root == null) {
            this.root = new UsbTreeNode();
        }
        return this.root;
    }

    private void buildTree(UsbTreeNode root) {
        Object userObject = root.getUserObject();
        if (userObject != null && ((UsbDevice)userObject).isUsbHub()) {
            UsbHub usbHub = (UsbHub)userObject;
            List usbDevices = usbHub.getAttachedUsbDevices();
            usbDevices.forEach(usbDevice -> {
                UsbTreeNode node = new UsbTreeNode((UsbDevice)usbDevice);
                log.debug("Adding {} to {}, depth: {}", new Object[]{node, root, node.getLevel()});
                this.buildTree(node);
                root.add(node);
            });
        }
        if (this.usbTree != null) {
            TreePath selection = this.usbTree.getSelectionPath();
            ((DefaultTreeModel)this.usbTree.getModel()).reload(root);
            this.usbTree.setSelectionPath(selection);
        }
    }

    private UsbTreeNode findNodeForDevice(UsbTreeNode root, UsbDevice usbDevice) {
        if (!root.isLeaf()) {
            int idx = 0;
            while (idx < root.getChildCount()) {
                TreeNode treeNode = root.getChildAt(idx);
                if (treeNode instanceof UsbTreeNode) {
                    UsbTreeNode usbTreeNode = (UsbTreeNode)treeNode;
                    UsbDevice tryUsbDevice = usbTreeNode.getUsbDevice();
                    log.debug("trying device: {}", (Object)tryUsbDevice);
                    if (tryUsbDevice != null && tryUsbDevice == usbDevice) {
                        return usbTreeNode;
                    }
                    UsbTreeNode result = this.findNodeForDevice(usbTreeNode, usbDevice);
                    if (result != null) {
                        return result;
                    }
                }
                ++idx;
            }
        }
        return null;
    }

    public void dispose() {
        try {
            UsbHostManager.getUsbServices().removeUsbServicesListener(this.usbServicesListener);
        }
        catch (SecurityException | UsbException throwable) {}
    }

    private void initComponents() {
        this.jSplitPane1 = new JSplitPane();
        this.jScrollPane1 = new JScrollPane(this.usbTree);
        this.usbTree = new JTree(this.root);
        this.jScrollPane2 = new JScrollPane();
        this.detailsTable = new JTable();
        this.jSplitPane1.setBorder(null);
        this.jSplitPane1.setResizeWeight(0.5);
        this.jScrollPane1.setBorder(null);
        this.usbTree.setCellRenderer(new UsbTreeCellRenderer());
        this.usbTree.setRootVisible(false);
        this.usbTree.setShowsRootHandles(true);
        this.usbTree.getSelectionModel().setSelectionMode(1);
        this.usbTree.addTreeSelectionListener(this.treeSelectionListener);
        this.jScrollPane1.setViewportView(this.usbTree);
        this.jSplitPane1.setLeftComponent(this.jScrollPane1);
        this.detailsTable.setModel(this.deviceModel);
        this.detailsTable.setCellSelectionEnabled(true);
        this.jScrollPane2.setViewportView(this.detailsTable);
        this.jSplitPane1.setRightComponent(this.jScrollPane2);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSplitPane1, -1, 372, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSplitPane1, -1, 260, Short.MAX_VALUE));
    }

    private static class UsbDeviceTableModel
    extends AbstractTableModel {
        private UsbTreeNode node = null;

        private UsbDeviceTableModel() {
        }

        @Override
        public int getRowCount() {
            return this.node != null && this.node.getUsbDevice() != null ? 11 : 1;
        }

        @Override
        public int getColumnCount() {
            return this.node != null && this.node.getUsbDevice() != null ? 2 : 1;
        }

        @Override
        public String getColumnName(int columnIndex) {
            return "";
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            if (this.node == null || this.node.getUsbDevice() == null) {
                return Bundle.getMessage("EmptySelection");
            }
            switch (columnIndex) {
                case 0: {
                    switch (rowIndex) {
                        case 0: {
                            return Bundle.getMessage("UsbDeviceManufacturer");
                        }
                        case 1: {
                            return Bundle.getMessage("UsbDeviceProduct");
                        }
                        case 2: {
                            return Bundle.getMessage("UsbDeviceSerial");
                        }
                        case 3: {
                            return Bundle.getMessage("UsbDeviceVendorId");
                        }
                        case 4: {
                            return Bundle.getMessage("UsbDeviceProductId");
                        }
                        case 5: {
                            return Bundle.getMessage("UsbDeviceClass");
                        }
                        case 6: {
                            return Bundle.getMessage("UsbDeviceSubClass");
                        }
                        case 7: {
                            return Bundle.getMessage("UsbDeviceProtocol");
                        }
                        case 8: {
                            return Bundle.getMessage("UsbDeviceReleaseNumber");
                        }
                        case 9: {
                            return Bundle.getMessage("UsbDeviceNumConfigurations");
                        }
                        case 10: {
                            return Bundle.getMessage("UsbDeviceLocation");
                        }
                    }
                    break;
                }
                case -1: 
                case 1: {
                    try {
                        switch (rowIndex) {
                            case 0: {
                                return this.node.getUsbDevice().getManufacturerString();
                            }
                            case 1: {
                                return this.node.getUsbDevice().getProductString();
                            }
                            case 2: {
                                return this.node.getUsbDevice().getSerialNumberString();
                            }
                            case 3: {
                                return String.format("%04x", this.node.getUsbDevice().getUsbDeviceDescriptor().idVendor());
                            }
                            case 4: {
                                return String.format("%04x", this.node.getUsbDevice().getUsbDeviceDescriptor().idProduct());
                            }
                            case 5: {
                                return String.format("%02X", this.node.getUsbDevice().getUsbDeviceDescriptor().bDeviceClass());
                            }
                            case 6: {
                                return String.format("%02X", this.node.getUsbDevice().getUsbDeviceDescriptor().bDeviceSubClass());
                            }
                            case 7: {
                                return String.format("%02X", this.node.getUsbDevice().getUsbDeviceDescriptor().bDeviceProtocol());
                            }
                            case 8: {
                                return String.format("%04x", this.node.getUsbDevice().getUsbDeviceDescriptor().bcdDevice());
                            }
                            case 9: {
                                return this.node.getUsbDevice().getUsbDeviceDescriptor().bNumConfigurations();
                            }
                            case 10: {
                                return UsbUtil.getLocation(this.node.getUsbDevice());
                            }
                        }
                        return null;
                    }
                    catch (UsbDisconnectedException usbDisconnectedException) {
                        this.node.setUsbDevice(null);
                        break;
                    }
                    catch (UnsupportedEncodingException | UsbException ex) {
                        log.error("Unable to get USB device property.", ex);
                        break;
                    }
                }
                default: {
                    return null;
                }
            }
            return null;
        }

        public void setNode(UsbTreeNode node) {
            UsbTreeNode old = this.node;
            this.node = node;
            if (old == null && node != null || old != null && node == null) {
                this.fireTableStructureChanged();
            }
            this.fireTableDataChanged();
        }
    }

    private static final class UsbTreeCellRenderer
    extends DefaultTreeCellRenderer {
        public UsbTreeCellRenderer() {
            int width = this.getOpenIcon().getIconWidth();
            int height = this.getOpenIcon().getIconHeight();
            try {
                this.setOpenIcon(new ImageIcon(new ImageIcon(this.getClass().getResource("/jmri/util/usb/topology.png")).getImage().getScaledInstance(width, height, 4)));
            }
            catch (NullPointerException nullPointerException) {
                log.error("Unable to get resource /jmri/util/usb/topology.png from JMRI classpath");
            }
            try {
                this.setClosedIcon(new ImageIcon(new ImageIcon(this.getClass().getResource("/jmri/util/usb/topology.png")).getImage().getScaledInstance(width, height, 4)));
            }
            catch (NullPointerException nullPointerException) {
                log.error("Unable to get resource /jmri/util/usb/topology.png from JMRI classpath");
            }
            try {
                this.setLeafIcon(new ImageIcon(new ImageIcon(this.getClass().getResource("/jmri/util/usb/usb.png")).getImage().getScaledInstance(width, height, 4)));
            }
            catch (NullPointerException nullPointerException) {
                log.error("Unable to get resource /jmri/util/usb/usb.png from JMRI classpath");
            }
        }
    }

    protected static class UsbTreeNode
    extends DefaultMutableTreeNode {
        public UsbTreeNode() {
            this(null);
        }

        public UsbTreeNode(UsbDevice usbDevice) {
            if (usbDevice == null) {
                try {
                    this.userObject = UsbHostManager.getUsbServices().getRootUsbHub();
                    log.debug("Using root usbDevice {}", this.userObject);
                }
                catch (SecurityException | UsbException ex) {
                    log.error("Unable to get root USB hub.", ex);
                    this.userObject = null;
                }
            } else {
                log.debug("Description of {} is\n{}", (Object)usbDevice, (Object)usbDevice.getUsbDeviceDescriptor());
                this.userObject = usbDevice;
            }
        }

        public UsbDevice getUsbDevice() {
            return (UsbDevice)this.userObject;
        }

        public void setUsbDevice(UsbDevice usbDevice) {
            this.userObject = usbDevice;
        }

        @Override
        public boolean isLeaf() {
            if (this.userObject instanceof UsbHub) {
                return false;
            }
            return super.isLeaf();
        }

        @Override
        public String toString() {
            String name;
            if (this.userObject == null) {
                return Bundle.getMessage("UnableToGetUsbRootHub");
            }
            if (this.userObject instanceof UsbDevice && (name = UsbUtil.getFullProductName((UsbDevice)this.userObject)) != null) {
                return name;
            }
            return super.toString();
        }
    }
}

