/*
 * Decompiled with CFR 0.152.
 */
package jmri.util.usb;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;
import jmri.DccLocoAddress;
import jmri.DccThrottle;
import jmri.InstanceManager;
import jmri.jmrit.roster.swing.RosterEntryComboBox;
import jmri.jmrit.roster.swing.RosterEntrySelectorPanel;
import jmri.jmrit.throttle.AddressPanel;
import jmri.jmrit.throttle.LoadXmlThrottlesLayoutAction;
import jmri.jmrit.throttle.ThrottleFrame;
import jmri.jmrit.throttle.ThrottleFrameManager;
import jmri.jmrit.throttle.ThrottleWindow;
import jmri.util.MathUtil;
import jmri.util.usb.Bundle;
import org.hid4java.HidDevice;
import org.hid4java.HidException;
import org.hid4java.HidManager;
import org.hid4java.HidServices;
import org.hid4java.HidServicesListener;
import org.hid4java.HidServicesSpecification;
import org.hid4java.ScanMode;
import org.hid4java.event.HidServicesEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RailDriverMenuItem
extends JMenuItem
implements HidServicesListener,
PropertyChangeListener {
    private static final short VENDOR_ID = 1523;
    private static final short PRODUCT_ID = 210;
    public static final String SERIAL_NUMBER = null;
    private HidServices hidServices = null;
    private HidDevice hidDevice = null;
    private Thread thread = null;
    private ThrottleWindow throttleWindow = null;
    private ThrottleFrame activeThrottleFrame = null;
    private final byte LEDCommand = (byte)-122;
    private final byte SpeakerCommand = (byte)-123;
    private final byte[] SevenSegment = new byte[]{63, 6, 91, 79, 102, 109, 125, 7, 127, 111};
    private final byte[] SevenSegmentAlpha = new byte[]{119, 124, 57, 94, 121, 113, 111, 118, 4, 30, 112, 56, 84, 35, 92, 115, 103, 80, 109, 68, 28, 98, 20, 54, 114, 73};
    private final byte BLANKSEGMENT = 0;
    private final byte QUESTIONMARK = (byte)83;
    private final byte DASHSEGMENT = (byte)64;
    private final byte DPSEGMENT = (byte)-128;
    private static final transient Logger log = LoggerFactory.getLogger(RailDriverMenuItem.class);

    public RailDriverMenuItem(String name) {
        this.initGUI(name);
        this.setupListeners();
    }

    public RailDriverMenuItem() {
        this(Bundle.getMessage("RdBuiltIn"));
    }

    private void initGUI(String name) {
        this.setText(name);
    }

    private void setupListeners() {
        this.addPropertyChangeListener(this);
        this.addActionListener(e -> {
            log.info("RailDriverMenuItem Action!");
            this.setupHidServices();
            this.hidDevice = this.hidServices.getHidDevice(1523, 210, SERIAL_NUMBER);
            if (this.hidDevice != null) {
                log.info("Got RailDriver hidDevice: {}", (Object)this.hidDevice);
                this.setupRailDriver();
            }
        });
    }

    protected void setupHidServices() {
        try {
            HidServicesSpecification hidServicesSpecification = new HidServicesSpecification();
            hidServicesSpecification.setAutoShutdown(true);
            hidServicesSpecification.setScanInterval(500);
            hidServicesSpecification.setPauseInterval(5000);
            hidServicesSpecification.setScanMode(ScanMode.SCAN_AT_FIXED_INTERVAL_WITH_PAUSE_AFTER_WRITE);
            this.hidServices = HidManager.getHidServices((HidServicesSpecification)hidServicesSpecification);
            this.hidServices.addHidServicesListener((HidServicesListener)this);
        }
        catch (HidException ex) {
            log.error("HidException: {}", (Throwable)ex);
        }
    }

    private void setupRailDriver() {
        if (this.hidDevice != null) {
            this.setLEDs("Pro");
            this.speakerOn();
            this.testRailDriver(false);
            ThrottleFrameManager tfManager = InstanceManager.getDefault(ThrottleFrameManager.class);
            if (this.activeThrottleFrame == null) {
                try {
                    LoadXmlThrottlesLayoutAction lxta = new LoadXmlThrottlesLayoutAction();
                    if (!lxta.loadThrottlesLayout(new File(ThrottleFrame.getDefaultThrottleFilename()))) {
                        throw new IOException();
                    }
                }
                catch (IOException iOException) {
                    this.throttleWindow = tfManager.createThrottleWindow();
                    this.activeThrottleFrame = this.throttleWindow.addThrottleFrame();
                }
            }
            SwingUtilities.invokeLater(() -> {
                if (this.activeThrottleFrame == null) {
                    this.throttleWindow = tfManager.getCurrentThrottleFrame();
                    if (this.throttleWindow != null) {
                        this.activeThrottleFrame = this.throttleWindow.getCurrentThrottleFrame();
                    }
                }
                if (this.activeThrottleFrame != null) {
                    this.activeThrottleFrame.toFront();
                    this.throttleWindow.addPropertyChangeListener(this);
                    this.activeThrottleFrame.addPropertyChangeListener(this);
                }
            });
            if (this.thread != null) {
                this.thread.interrupt();
                try {
                    this.thread.join(500L);
                }
                catch (InterruptedException ex) {
                    log.debug("InterruptedException : {}", (Throwable)ex);
                }
            }
            this.thread = new Thread(() -> {
                byte[] buff_old = new byte[14];
                Arrays.fill(buff_old, (byte)0);
                while (!this.thread.isInterrupted()) {
                    byte[] buff_new;
                    int ret;
                    if (!this.hidDevice.isOpen()) {
                        this.hidDevice.open();
                    }
                    if ((ret = this.hidDevice.read(buff_new = new byte[14])) >= 0) {
                        int i = 0;
                        while (i < buff_new.length) {
                            if (buff_old[i] != buff_new[i]) {
                                if (i < 7) {
                                    int vInt = 0xFF & buff_new[i];
                                    double vDouble = (double)(256 - vInt) / 256.0;
                                    if (i == 1) {
                                        vDouble = 2.0 * vDouble - 1.0;
                                    }
                                    String name1 = String.format("Axis %d", i);
                                    log.info("firePropertyChange(\"Value\", {}, {})", (Object)name1, (Object)vDouble);
                                    this.firePropertyChange("Value", name1, Double.toString(vDouble));
                                } else {
                                    byte xor = (byte)(buff_old[i] ^ buff_new[i]);
                                    int bit = 0;
                                    while (bit < 8) {
                                        byte mask = (byte)(1 << bit);
                                        if (mask == (mask & xor)) {
                                            int n = 8 * (i - 7) + bit;
                                            String name2 = String.format("%d", n);
                                            boolean down = mask == (buff_new[i] & mask);
                                            log.info("firePropertyChange(\"Value\", {}, {})", (Object)name2, (Object)(down ? "1" : "0"));
                                            this.firePropertyChange("Value", name2, down ? "1" : "0");
                                        }
                                        ++bit;
                                    }
                                }
                                buff_old[i] = buff_new[i];
                            }
                            ++i;
                        }
                        continue;
                    }
                    String error = this.hidDevice.getLastErrorMessage();
                    if (error == null) continue;
                    log.error("hidDevice.read error: {}", (Object)error);
                }
            });
            this.thread.setName("RailDriver");
            this.thread.start();
        }
    }

    private void testRailDriver(boolean testFlag) {
        if (testFlag) {
            new Thread(() -> {
                int pass = 0;
                while (pass < 3) {
                    int c = 65;
                    while (c < 90) {
                        StringBuilder s = new StringBuilder();
                        int i = 0;
                        while (i < 3) {
                            char ci = (char)(c + i);
                            ci = (char)((ci - 65) % 26 + 65);
                            s.append(ci);
                            if (ci % 3 == 0) {
                                s.append('.');
                            }
                            ++i;
                        }
                        this.setLEDs(s.toString());
                        this.sleep(0.25);
                        c = (char)(c + 1);
                    }
                    ++pass;
                }
                this.sendString("The quick brown fox jumps over the lazy dog.", 0.25);
                this.sleep(2.0);
                this.setLEDs("8.8.8.");
                this.sleep(2.0);
                this.setLEDs("???");
                this.sleep(3.0);
                this.setLEDs("Pro");
            }).start();
        }
    }

    public void sendStringAsync(@Nonnull String string, double delay) {
        new Thread(() -> this.sendString(string, delay)).start();
    }

    public void sendString(@Nonnull String string, double delay) {
        int i = 0;
        while (i < string.length()) {
            StringBuilder ledstring = new StringBuilder();
            int maxJ = 3;
            int j = 0;
            while (j < maxJ) {
                if (i + j >= string.length()) break;
                char c = string.charAt(i + j);
                ledstring.append(c);
                if (c == '.') {
                    ++maxJ;
                }
                ++j;
            }
            this.setLEDs(ledstring.toString());
            this.sleep(delay);
            ++i;
        }
    }

    private void sleep(double delay) {
        try {
            TimeUnit.MILLISECONDS.sleep((long)(delay * 1000.0));
        }
        catch (InterruptedException ex) {
            log.debug("TimeUnit.sleep InterruptedException: {}", (Throwable)ex);
        }
    }

    public void setLEDs(@Nonnull String ledstring) {
        byte[] buff = new byte[7];
        Arrays.fill(buff, (byte)0);
        int outIdx = 2;
        int i = 0;
        while (i < ledstring.length()) {
            char c = ledstring.charAt(i);
            if (Character.isDigit(c)) {
                buff[outIdx] = this.SevenSegment[c - 48];
            } else if (Character.isWhitespace(c)) {
                buff[outIdx] = 0;
            } else if (c == '_') {
                buff[outIdx] = 0;
            } else if (c == '?') {
                buff[outIdx] = 83;
            } else if (c >= 'A' && c <= 'Z') {
                buff[outIdx] = this.SevenSegmentAlpha[c - 65];
            } else if (c >= 'a' && c <= 'z') {
                buff[outIdx] = this.SevenSegmentAlpha[c - 97];
            } else if (c == '-') {
                buff[outIdx] = 64;
            } else if (c == '.') {
                int n = outIdx + 1;
                buff[n] = (byte)(buff[n] | 0xFFFFFF80);
                ++outIdx;
            } else {
                ++outIdx;
            }
            if (--outIdx < 0) {
                if (++i >= ledstring.length() || ledstring.charAt(i) != '.') break;
                buff[0] = (byte)(buff[0] | 0xFFFFFF80);
                break;
            }
            ++i;
        }
        this.sendMessage(buff, (byte)-122);
    }

    public void setSpeakerOn(boolean onFlag) {
        byte[] buff = new byte[7];
        Arrays.fill(buff, (byte)0);
        buff[5] = (byte)(onFlag ? 1 : 0);
        this.sendMessage(buff, (byte)-123);
    }

    public void speakerOn() {
        this.setSpeakerOn(true);
    }

    public void speakerOff() {
        this.setSpeakerOn(false);
    }

    private void sendMessage(byte[] message, byte reportID) {
        if (!this.hidDevice.isOpen()) {
            this.hidDevice.open();
        }
        try {
            int ret = this.hidDevice.write(message, message.length, reportID);
            if (ret >= 0) {
                log.debug("hidDevice.write returned: {}", (Object)ret);
            } else {
                log.error("hidDevice.write error: {}", (Object)this.hidDevice.getLastErrorMessage());
            }
        }
        catch (IllegalStateException ex) {
            log.error("hidDevice.write Exception : {}", (Throwable)ex);
        }
    }

    public void hidDeviceAttached(HidServicesEvent event) {
        log.info("hidDeviceAttached({})", (Object)event);
    }

    public void hidDeviceDetached(HidServicesEvent event) {
        log.info("hidDeviceDetached({})", (Object)event);
        if (this.hidDevice == event.getHidDevice()) {
            this.hidDevice = null;
        }
    }

    public void hidFailure(HidServicesEvent event) {
        log.warn("hidFailure({})", (Object)event);
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        block8 : switch (event.getPropertyName()) {
            case "ancestor": {
                if (this.throttleWindow != null) {
                    this.throttleWindow.removePropertyChangeListener(this);
                    this.throttleWindow = null;
                }
                if (this.activeThrottleFrame == null) break;
                this.activeThrottleFrame.removePropertyChangeListener(this);
                this.activeThrottleFrame = null;
                break;
            }
            case "ThrottleFrame": {
                Object object = event.getNewValue();
                if (object == null) {
                    if (this.activeThrottleFrame == null) break;
                    this.activeThrottleFrame.removePropertyChangeListener(this);
                    this.activeThrottleFrame = null;
                    break;
                }
                if (!(object instanceof ThrottleFrame)) break;
                if (this.throttleWindow != null) {
                    this.throttleWindow.removePropertyChangeListener(this);
                    this.throttleWindow = null;
                }
                if (this.activeThrottleFrame != null) {
                    this.activeThrottleFrame.removePropertyChangeListener(this);
                    this.activeThrottleFrame = null;
                }
                this.activeThrottleFrame = (ThrottleFrame)object;
                this.throttleWindow = this.activeThrottleFrame.getThrottleWindow();
                this.throttleWindow.addPropertyChangeListener(this);
                this.activeThrottleFrame.addPropertyChangeListener(this);
                break;
            }
            case "Value": {
                int fNum;
                double value;
                String oldValue = event.getOldValue().toString();
                String newValue = event.getNewValue().toString();
                DccThrottle throttle = this.activeThrottleFrame.getAddressPanel().getThrottle();
                AddressPanel addressPanel = this.activeThrottleFrame.getAddressPanel();
                try {
                    value = Double.parseDouble(newValue);
                }
                catch (NumberFormatException ex) {
                    log.error("RailDriver parse property new value ('{}')", (Object)newValue, (Object)ex);
                    return;
                }
                switch (oldValue) {
                    case "Axis 0": {
                        log.info("REVERSER value: {}", (Object)value);
                        if (throttle == null) break block8;
                        if (value < 0.45) {
                            throttle.setIsForward(false);
                            break block8;
                        }
                        if (!(value > 0.55)) break block8;
                        throttle.setIsForward(true);
                        break block8;
                    }
                    case "Axis 1": {
                        log.info("THROTTLE value: {}", (Object)value);
                        if (throttle == null) break block8;
                        double throttle_min = 0.125;
                        double throttle_max = 0.7;
                        double v = MathUtil.pin(value, throttle_min, throttle_max);
                        double fraction = (v - throttle_min) / (throttle_max - throttle_min);
                        throttle.setSpeedSetting((float)fraction);
                        if (value < 0.0) {
                            this.setLEDs("DBr");
                            break block8;
                        }
                        String speed = String.format("%03d", (int)fraction * 100);
                        this.setLEDs(speed);
                        break block8;
                    }
                    case "Axis 2": {
                        log.info("AUTOBRAKE value: {}", (Object)value);
                        break block8;
                    }
                    case "Axis 3": {
                        log.info("INDEPENDBRK value: {}", (Object)value);
                        break block8;
                    }
                    case "Axis 4": {
                        log.info("BAILOFF value: {}", (Object)value);
                        break block8;
                    }
                    case "Axis 5": {
                        log.info("HEADLIGHT value: {}", (Object)value);
                        break block8;
                    }
                    case "Axis 6": {
                        log.info("WIPER value: {}", (Object)value);
                        break block8;
                    }
                }
                log.info("FUNCTION {} value: {}", (Object)oldValue, (Object)value);
                boolean isDown = value > 0.5;
                try {
                    fNum = Integer.parseInt(oldValue);
                }
                catch (NumberFormatException numberFormatException) {
                    return;
                }
                String ledString = String.format("F%d", fNum + 1);
                switch (fNum) {
                    case 28: {
                        if (addressPanel == null || !isDown) break;
                        addressPanel.selectRosterEntry();
                        DccLocoAddress a = addressPanel.getCurrentAddress();
                        ledString = "sel " + (a != null ? a.toString() : "null");
                        break;
                    }
                    case 29: {
                        if (addressPanel == null || !isDown) break;
                        addressPanel.dispatchAddress();
                        DccLocoAddress a = addressPanel.getCurrentAddress();
                        ledString = "dis " + (a != null ? a.toString() : "null");
                        break;
                    }
                    case 30: {
                        int selectedIndex;
                        if (addressPanel == null || !isDown || (selectedIndex = addressPanel.getRosterSelectedIndex()) <= 1) break;
                        addressPanel.setRosterSelectedIndex(selectedIndex - 1);
                        ledString = String.format("Prev %d", selectedIndex - 1);
                        break;
                    }
                    case 31: {
                        if (!isDown) break;
                        if (this.throttleWindow != null) {
                            this.throttleWindow.nextThrottleFrame();
                        }
                        ledString = "NXT";
                        break;
                    }
                    case 32: {
                        RosterEntryComboBox recb;
                        RosterEntrySelectorPanel resp;
                        if (addressPanel == null || !isDown || (resp = addressPanel.getRosterEntrySelector()) == null || (recb = resp.getRosterEntryComboBox()) == null) break;
                        int cnt = recb.getItemCount();
                        int selectedIndex = addressPanel.getRosterSelectedIndex();
                        if (selectedIndex + 1 >= cnt) break;
                        try {
                            addressPanel.setRosterSelectedIndex(selectedIndex + 1);
                            ledString = String.format("Next %d", selectedIndex + 1);
                        }
                        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
                        break;
                    }
                    case 33: {
                        if (!isDown) break;
                        if (this.throttleWindow != null) {
                            this.throttleWindow.previousThrottleFrame();
                        }
                        ledString = "PRE";
                        break;
                    }
                    case 34: {
                        if (throttle == null || !isDown) break;
                        throttle.setF3(false);
                        break;
                    }
                    case 35: {
                        if (throttle == null || !isDown) break;
                        throttle.setF3(true);
                        break;
                    }
                    case 36: 
                    case 37: {
                        if (throttle == null || !isDown) break;
                        throttle.setSpeedSetting(-1.0f);
                        break;
                    }
                    case 38: {
                        if (!isDown) break;
                        fNum = 6;
                        break;
                    }
                    case 39: {
                        if (!isDown) break;
                        fNum = 7;
                        break;
                    }
                    case 40: {
                        if (!isDown) break;
                        fNum = 8;
                        break;
                    }
                    case 41: {
                        if (!isDown) break;
                        fNum = 1;
                        break;
                    }
                    case 42: 
                    case 43: {
                        fNum = 2;
                        break;
                    }
                }
                if (throttle != null && fNum > 0 && fNum < throttle.getFunctions().length) {
                    if (!throttle.getFunctionMomentary(fNum)) {
                        if (isDown) {
                            throttle.setFunction(fNum, !throttle.getFunction(fNum));
                        }
                    } else {
                        throttle.setFunction(fNum, isDown);
                    }
                }
                if (!isDown) break;
                if (ledString.length() <= 3) {
                    this.setLEDs(ledString);
                    break;
                }
                this.sendStringAsync(ledString, 0.333);
                break;
            }
        }
    }
}

