/*
 * Decompiled with CFR 0.152.
 */
package jmri.util.table;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import javax.swing.JTable;
import javax.swing.JToggleButton;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.table.TableCellRenderer;

public class ToggleButtonRenderer
extends JToggleButton
implements TableCellRenderer {
    protected String onText;
    protected String offText;
    protected Color foreground;
    protected Color background;
    protected Font font;
    protected Border border;

    public ToggleButtonRenderer(String on, String off) {
        this.onText = on;
        this.offText = off;
        this.border = this.getBorder();
        this.setOpaque(true);
        this.putClientProperty("JComponent.sizeVariant", "small");
        this.putClientProperty("JToggleButton.buttonType", "square");
    }

    @Override
    public void setForeground(Color foreground) {
        this.foreground = foreground;
        super.setForeground(foreground);
    }

    @Override
    public void setBackground(Color background) {
        this.background = background;
        super.setBackground(background);
    }

    @Override
    public void setFont(Font font) {
        this.font = font;
        super.setFont(font);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        Color cellBackground;
        Color cellForeground = this.foreground != null ? this.foreground : table.getForeground();
        Color color = cellBackground = this.background != null ? this.background : table.getBackground();
        if (hasFocus) {
            this.setBorder(UIManager.getBorder("Table.focusCellHighlightBorder"));
            if (table.isCellEditable(row, column)) {
                cellForeground = UIManager.getColor("Table.focusCellForeground");
                cellBackground = UIManager.getColor("Table.focusCellBackground");
            }
        } else {
            this.setBorder(this.border);
        }
        super.setForeground(cellForeground);
        super.setBackground(cellBackground);
        this.setValue(value, isSelected);
        return this;
    }

    protected void setValue(Object value, Boolean sel) {
        switch (value.toString()) {
            case "true": {
                this.setText(this.onText);
                this.setSelected(sel);
                this.setEnabled(true);
                break;
            }
            case "false": {
                this.setText(this.offText);
                this.setSelected(sel);
                this.setEnabled(true);
                break;
            }
            default: {
                this.setText("?");
                this.setEnabled(false);
            }
        }
    }
}

