/*
 * Decompiled with CFR 0.152.
 */
package jmri.util.table;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.EventObject;
import javax.swing.JTable;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import javax.swing.table.TableCellEditor;
import jmri.util.table.BasicCellEditor;

public class ToggleButtonEditor
extends BasicCellEditor
implements ActionListener,
TableCellEditor,
MouseListener {
    protected String onText;
    protected String offText;
    protected Object value;
    protected Color foreground;
    protected Color background;
    protected Font font;

    public ToggleButtonEditor(JToggleButton button, String on, String off) {
        super(button);
        this.onText = on;
        this.offText = off;
        button.addActionListener(this);
        button.addMouseListener(this);
        button.putClientProperty("JComponent.sizeVariant", "small");
        button.putClientProperty("JToggleButton.buttonType", "square");
    }

    public void setForeground(Color foreground) {
        this.foreground = foreground;
        this.editor.setForeground(foreground);
    }

    public void setBackground(Color background) {
        this.background = background;
        this.editor.setBackground(background);
    }

    public void setFont(Font font) {
        this.font = font;
        this.editor.setFont(font);
    }

    @Override
    public Object getCellEditorValue() {
        return this.value;
    }

    @Override
    public void editingStarted(EventObject event) {
        if (!(event instanceof MouseEvent)) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ((JToggleButton)ToggleButtonEditor.this.editor).doClick();
                }
            });
        }
    }

    @Override
    public Component getTableCellEditorComponent(JTable tbl, Object value, boolean isSelected, int row, int column) {
        this.editor.setForeground(this.foreground != null ? this.foreground : tbl.getForeground());
        this.editor.setBackground(this.background != null ? this.background : tbl.getBackground());
        this.editor.setFont(this.font != null ? this.font : tbl.getFont());
        this.value = value;
        this.setValue(value, isSelected);
        return this.editor;
    }

    protected void setValue(Object value, Boolean sel) {
        JToggleButton button = (JToggleButton)this.editor;
        switch (value.toString()) {
            case "true": {
                button.setText(this.onText);
                button.setEnabled(true);
                break;
            }
            case "false": {
                button.setText(this.offText);
                button.setEnabled(true);
                break;
            }
            default: {
                button.setText("?");
                button.setEnabled(false);
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        JToggleButton tBtn = (JToggleButton)evt.getSource();
        if (tBtn.isSelected()) {
            tBtn.setText(this.onText);
            this.value = Boolean.TRUE;
        } else {
            tBtn.setText(this.offText);
            this.value = Boolean.FALSE;
        }
        this.stopCellEditing();
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }
}

