/*
 * Decompiled with CFR 0.152.
 */
package jmri.util.table;

import java.awt.Color;
import java.awt.Component;
import javax.annotation.CheckForNull;
import javax.swing.JProgressBar;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;

public class ProgressCellRender
extends JProgressBar
implements TableCellRenderer {
    private final Color _oddRowColor;

    public ProgressCellRender(@CheckForNull Color oddRowColor) {
        this._oddRowColor = oddRowColor;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        int progress = 0;
        int fullValprogress = 0;
        float fp = 0.0f;
        if (value instanceof Float) {
            fp = ((Float)value).floatValue();
            progress = Math.round(fp * 100.0f);
            fullValprogress = Math.round(fp * 1000.0f);
            if (progress == 100 && fullValprogress < 1000) {
                progress = 99;
            }
        }
        this.setForeground(new Color(Math.min(0.8f, 2.0f * (1.0f - fp)), Math.min(0.8f, 2.0f * fp), 0.0f));
        this.setBorderPainted(false);
        this.setStringPainted(true);
        this.setValue(fullValprogress);
        if (progress < 99) {
            this.setMaximum(1000);
        }
        this.setString(String.valueOf(progress) + "%");
        if (this._oddRowColor != null) {
            this.setBackground(isSelected ? table.getSelectionBackground() : (row % 2 == 0 ? table.getBackground() : this._oddRowColor));
        }
        return this;
    }
}

