/*
 * Decompiled with CFR 0.152.
 */
package jmri.util.table;

import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import javax.swing.AbstractAction;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.table.TableModel;
import jmri.util.FileUtil;
import jmri.util.table.Bundle;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JTableToCsvAction
extends AbstractAction {
    private final JFileChooser _fileChooser;
    private File _saveFile;
    private final JTable _table;
    private final TableModel _model;
    private final String _defaultFileName;
    private String _saveFileName;
    private final int[] _excludedCols;
    private List<Integer> modelColList;
    private List<Integer> modelRowList;
    private static final Logger log = LoggerFactory.getLogger(JTableToCsvAction.class);

    public JTableToCsvAction(String actionName, JTable jtable, @Nonnull TableModel model, @Nonnull String defaultFileName, @Nonnull int[] excludedCols) {
        super(actionName);
        this._table = jtable;
        this._model = model;
        this._defaultFileName = defaultFileName;
        this._excludedCols = excludedCols;
        this._fileChooser = new JFileChooser(FileUtil.getUserFilesPath());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this._fileChooser.setFileFilter(new FileNameExtensionFilter(Bundle.getMessage("CSVFileLabel"), "csv"));
        this._fileChooser.setSelectedFile(new File(this._defaultFileName));
        if (this._fileChooser.showSaveDialog(this._table) == 0) {
            this._saveFileName = this._fileChooser.getSelectedFile().getPath();
            if (!this._saveFileName.regionMatches(true, this._saveFileName.length() - 4, ".csv", 0, 4)) {
                this._saveFileName = String.valueOf(this._saveFileName) + ".csv";
            }
            this._saveFile = new File(this._saveFileName);
            if (this.continueIfExisting()) {
                this.saveToCSV();
            }
        }
    }

    private boolean continueIfExisting() {
        return !this._saveFile.isFile() || JOptionPane.showConfirmDialog(this._table, Bundle.getMessage("ConfirmOverwriteFile"), Bundle.getMessage("ConfirmQuestion"), 0, 3) == 0;
    }

    private void saveToCSV() {
        this.createColumnsAndRows();
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (CSVPrinter p = new CSVPrinter((Appendable)new OutputStreamWriter((OutputStream)new FileOutputStream(this._saveFileName), StandardCharsets.UTF_8), CSVFormat.DEFAULT);){
                this.addToFile(p);
                p.flush();
                p.close();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            log.error("Error Saving Table to CSV File {}", (Object)e.toString());
        }
    }

    private void addToFile(CSVPrinter p) throws IOException {
        ArrayList<String> headers = new ArrayList<String>();
        int i = 0;
        while (i < this.modelColList.size()) {
            headers.add(this._model.getColumnName(this.modelColList.get(i)));
            ++i;
        }
        p.printRecord(headers);
        i = 0;
        while (i < this.modelRowList.size()) {
            ArrayList<String> row = new ArrayList<String>();
            int j = 0;
            while (j < this.modelColList.size()) {
                String val = String.valueOf(this._model.getValueAt(this.modelRowList.get(i), this.modelColList.get(j)));
                if (val.equals("null")) {
                    val = "";
                }
                row.add(val);
                ++j;
            }
            p.printRecord(row);
            ++i;
        }
    }

    private void createColumnsAndRows() {
        this.modelColList = new ArrayList<Integer>();
        this.modelRowList = new ArrayList<Integer>();
        if (this._table != null) {
            int i = 0;
            while (i < this._table.getColumnCount()) {
                this.addColtoListIfNotExcluded(this.modelColList, this._table.convertColumnIndexToModel(i), this._excludedCols);
                ++i;
            }
            i = 0;
            while (i < this._table.getRowCount()) {
                this.modelRowList.add(this._table.convertRowIndexToModel(i));
                ++i;
            }
        } else {
            int i = 0;
            while (i < this._model.getColumnCount()) {
                this.addColtoListIfNotExcluded(this.modelColList, i, this._excludedCols);
                ++i;
            }
            i = 0;
            while (i < this._model.getRowCount()) {
                this.modelRowList.add(i);
                ++i;
            }
        }
    }

    private void addColtoListIfNotExcluded(@Nonnull List<Integer> list, int modelCol, @Nonnull int[] colsToNotSave) {
        if (!Arrays.stream(colsToNotSave).anyMatch(j -> j == modelCol)) {
            list.add(modelCol);
        }
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

