/*
 * Decompiled with CFR 0.152.
 */
package jmri.util.swing;

import java.util.Collections;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableColumn;

public class XTableColumnModel
extends DefaultTableColumnModel {
    protected Vector<TableColumn> allTableColumns = new Vector();

    public void setColumnVisible(TableColumn column, boolean visible) {
        if (!visible) {
            super.removeColumn(column);
        } else {
            int noVisibleColumns = this.tableColumns.size();
            int noInvisibleColumns = this.allTableColumns.size();
            int visibleIndex = 0;
            int invisibleIndex = 0;
            while (invisibleIndex < noInvisibleColumns) {
                TableColumn visibleColumn = visibleIndex < noVisibleColumns ? (TableColumn)this.tableColumns.get(visibleIndex) : null;
                TableColumn testColumn = this.allTableColumns.get(invisibleIndex);
                if (testColumn == column) {
                    if (visibleColumn != column) {
                        super.addColumn(column);
                        super.moveColumn(this.tableColumns.size() - 1, visibleIndex);
                    }
                    return;
                }
                if (testColumn == visibleColumn) {
                    ++visibleIndex;
                }
                ++invisibleIndex;
            }
        }
    }

    public void setAllColumnsVisible() {
        int noColumns = this.allTableColumns.size();
        int columnIndex = 0;
        while (columnIndex < noColumns) {
            TableColumn invisibleColumn;
            TableColumn visibleColumn = columnIndex < this.tableColumns.size() ? (TableColumn)this.tableColumns.get(columnIndex) : null;
            if (visibleColumn != (invisibleColumn = this.allTableColumns.get(columnIndex))) {
                super.addColumn(invisibleColumn);
                super.moveColumn(this.tableColumns.size() - 1, columnIndex);
            }
            ++columnIndex;
        }
    }

    public TableColumn getColumnByModelIndex(int modelColumnIndex) {
        int columnIndex = 0;
        while (columnIndex < this.allTableColumns.size()) {
            TableColumn column = this.allTableColumns.get(columnIndex);
            if (column.getModelIndex() == modelColumnIndex) {
                return column;
            }
            ++columnIndex;
        }
        return null;
    }

    public boolean isColumnVisible(TableColumn aColumn) {
        return this.tableColumns.indexOf(aColumn) >= 0;
    }

    @Override
    public void addColumn(TableColumn column) {
        this.allTableColumns.add(column);
        super.addColumn(column);
    }

    @Override
    public void removeColumn(TableColumn column) {
        int allColumnsIndex = this.allTableColumns.indexOf(column);
        if (allColumnsIndex != -1) {
            this.allTableColumns.remove(allColumnsIndex);
        }
        super.removeColumn(column);
    }

    @Override
    public void moveColumn(int columnIndex, int newIndex) {
        this.moveColumn(columnIndex, newIndex, true);
    }

    public void moveColumn(int columnIndex, int newIndex, boolean onlyVisible) {
        if (columnIndex < 0 || columnIndex >= this.getColumnCount(onlyVisible) || newIndex < 0 || newIndex >= this.getColumnCount(onlyVisible)) {
            throw new IllegalArgumentException("moveColumn() - Index out of range");
        }
        if (onlyVisible) {
            if (columnIndex != newIndex) {
                int allColumnsColumnIndex = this.allTableColumns.indexOf(this.tableColumns.get(columnIndex));
                int allColumnsNewIndex = this.allTableColumns.indexOf(this.tableColumns.get(newIndex));
                TableColumn column = this.allTableColumns.remove(allColumnsColumnIndex);
                this.allTableColumns.add(allColumnsNewIndex, column);
            }
            super.moveColumn(columnIndex, newIndex);
        } else if (columnIndex != newIndex) {
            int visibleColumnIndex = this.tableColumns.indexOf(this.allTableColumns.get(columnIndex));
            int visibleNewIndex = this.tableColumns.indexOf(this.allTableColumns.get(newIndex));
            TableColumn column = this.allTableColumns.remove(columnIndex);
            this.allTableColumns.add(newIndex, column);
            if (visibleColumnIndex != -1 && visibleNewIndex != -1) {
                super.moveColumn(visibleColumnIndex, visibleNewIndex);
            }
        }
    }

    public int getColumnCount(boolean onlyVisible) {
        return this.getColumnList(onlyVisible).size();
    }

    public Enumeration<TableColumn> getColumns(boolean onlyVisible) {
        return Collections.enumeration(this.getColumnList(onlyVisible));
    }

    public int getColumnIndex(Object identifier, boolean onlyVisible) {
        if (identifier == null) {
            throw new IllegalArgumentException("Identifier is null");
        }
        Vector<TableColumn> columns = this.getColumnList(onlyVisible);
        int noColumns = columns.size();
        int columnIndex = 0;
        while (columnIndex < noColumns) {
            TableColumn column = columns.get(columnIndex);
            if (identifier.equals(column.getIdentifier())) {
                return columnIndex;
            }
            ++columnIndex;
        }
        throw new IllegalArgumentException("Identifier not found");
    }

    public TableColumn getColumn(int columnIndex, boolean onlyVisible) {
        return this.getColumnList(onlyVisible).get(columnIndex);
    }

    private Vector<TableColumn> getColumnList(boolean onlyVisible) {
        return onlyVisible ? this.tableColumns : this.allTableColumns;
    }
}

