/*
 * Decompiled with CFR 0.152.
 */
package jmri.util.swing;

import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.plaf.basic.BasicLabelUI;

public class VerticalLabelUI
extends BasicLabelUI {
    public static final int CLOCKWISE = 1;
    public static final int ANTICLOCKWISE = 2;
    private int rotation;
    private final Rectangle iconRectangle = new Rectangle();
    private final Rectangle textRectangle = new Rectangle();
    private final Rectangle viewRectangle = new Rectangle();
    private Insets viewInsets = new Insets(0, 0, 0, 0);

    public VerticalLabelUI() {
        this(2);
    }

    public VerticalLabelUI(int rotation) {
        this.rotation = rotation;
    }

    @Override
    public Dimension getPreferredSize(JComponent component) {
        Dimension dimension = super.getPreferredSize(component);
        return new Dimension(dimension.height, dimension.width);
    }

    @Override
    public void paint(Graphics graphics, JComponent component) {
        if (component instanceof JLabel) {
            Icon icon;
            JLabel label = (JLabel)component;
            String text = label.getText();
            Icon icon2 = icon = label.isEnabled() ? label.getIcon() : label.getDisabledIcon();
            if (icon == null && text == null) {
                return;
            }
            FontMetrics fontMetrics = graphics.getFontMetrics();
            this.viewInsets = component.getInsets(this.viewInsets);
            this.viewRectangle.x = this.viewInsets.left;
            this.viewRectangle.y = this.viewInsets.top;
            this.viewRectangle.height = component.getWidth() - (this.viewInsets.left + this.viewInsets.right);
            this.viewRectangle.width = component.getHeight() - (this.viewInsets.top + this.viewInsets.bottom);
            this.iconRectangle.x = 0;
            this.iconRectangle.y = 0;
            this.iconRectangle.width = 0;
            this.iconRectangle.height = 0;
            this.textRectangle.x = 0;
            this.textRectangle.y = 0;
            this.textRectangle.width = 0;
            this.textRectangle.height = 0;
            String clippedText = this.layoutCL(label, fontMetrics, text, icon, this.viewRectangle, this.iconRectangle, this.textRectangle);
            AffineTransform transform = null;
            if (graphics instanceof Graphics2D) {
                transform = ((Graphics2D)graphics).getTransform();
                ((Graphics2D)graphics).rotate((double)(this.rotation == 1 ? 1 : -1) * 1.5707963267948966);
                ((Graphics2D)graphics).translate(this.rotation == 1 ? 0 : -component.getHeight(), this.rotation == 1 ? -component.getWidth() : 0);
            }
            if (icon != null) {
                icon.paintIcon(component, graphics, this.iconRectangle.x, this.iconRectangle.y);
            }
            if (text != null) {
                int textX = this.textRectangle.x;
                int textY = this.textRectangle.y + fontMetrics.getAscent();
                if (label.isEnabled()) {
                    this.paintEnabledText(label, graphics, clippedText, textX, textY);
                } else {
                    this.paintDisabledText(label, graphics, clippedText, textX, textY);
                }
            }
            if (graphics instanceof Graphics2D && transform != null) {
                ((Graphics2D)graphics).setTransform(transform);
            }
        }
    }
}

