/*
 * Decompiled with CFR 0.152.
 */
package jmri.util.swing;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.annotation.Nonnull;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TriStateJCheckBox
extends JPanel {
    private final JPanel contentContainer;
    private final JCheckBox checkBox;
    private final JLabel label;
    private TriStateModel model;
    private String text;
    private static final Logger log = LoggerFactory.getLogger(TriStateJCheckBox.class);

    public TriStateJCheckBox() {
        this((String)null);
    }

    public TriStateJCheckBox(String labelText) {
        this.text = labelText;
        this.contentContainer = new JPanel(new BorderLayout(0, 0));
        this.label = new JLabel();
        this.checkBox = new TriCheckBox();
        this.initProperties();
    }

    private void initProperties() {
        log.debug("started TriStateJCheckBox");
        this.setLayout(new GridBagLayout());
        this.model = new TriStateModel(State.UNCHECKED);
        this.checkBox.setModel(this.model);
        this.checkBox.setOpaque(false);
        this.label.setOpaque(false);
        this.contentContainer.setOpaque(false);
        this.setOpaque(false);
        this.setText(this.text);
        this.label.setLabelFor(this.checkBox);
        this.contentContainer.add((Component)this.checkBox, "West");
        this.contentContainer.add((Component)this.label, "Center");
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        this.add((Component)this.contentContainer, gbc);
        MouseAdapter labelAndPanelListener = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.getButton() == 1) {
                    TriStateJCheckBox.this.model.setPressed(true);
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.getButton() == 1) {
                    TriStateJCheckBox.this.model.setPressed(false);
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                TriStateJCheckBox.this.model.setRollover(true);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                TriStateJCheckBox.this.model.setRollover(false);
            }
        };
        this.label.addMouseListener(labelAndPanelListener);
    }

    public void setState(@Nonnull State state) {
        this.model.setState(state);
        this.checkBox.repaint();
    }

    public void setState(boolean[] booleanArray) {
        if (this.arrayDoesNotContainsTrueOrFalse(booleanArray, true)) {
            this.setState(State.UNCHECKED);
        } else if (this.arrayDoesNotContainsTrueOrFalse(booleanArray, false)) {
            this.setState(State.CHECKED);
        } else {
            this.setState(State.PARTIAL);
        }
    }

    private boolean arrayDoesNotContainsTrueOrFalse(boolean[] booleanArray, boolean condition) {
        boolean[] blArray = booleanArray;
        int n = booleanArray.length;
        int n2 = 0;
        while (n2 < n) {
            boolean value = blArray[n2];
            if (value == condition) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    @Nonnull
    public State getState() {
        return this.model.getState();
    }

    public void setSelected(boolean selected) {
        this.checkBox.setSelected(selected);
    }

    public boolean isSelected() {
        return this.checkBox.isSelected();
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.checkBox.setEnabled(enabled);
    }

    public void setText(String newText) {
        this.text = newText == null || newText.trim().isEmpty() ? null : newText;
        this.label.setText(this.text);
    }

    public void addActionListener(ActionListener al) {
        this.checkBox.addActionListener(al);
    }

    @Override
    public void setToolTipText(String s) {
        this.checkBox.setToolTipText(s);
        this.label.setToolTipText(s);
        this.contentContainer.setToolTipText(s);
        super.setToolTipText(s);
    }

    public static enum State {
        CHECKED,
        UNCHECKED,
        PARTIAL;

    }

    private static class TriCheckBox
    extends JCheckBox {
        private static final int DOT_SIZE = 2;

        protected TriCheckBox() {
        }

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            if (((TriStateModel)this.model).getState() == State.PARTIAL) {
                int w = this.getWidth();
                int h = this.getHeight();
                int wOdd = w % 2;
                int hOdd = h % 2;
                int centerX = w / 2;
                int centerY = h / 2;
                int rw = 4 + wOdd;
                int rh = 4 + hOdd;
                g.setColor(this.isEnabled() ? new Color(51, 51, 51) : new Color(122, 138, 153));
                g.fillRect(centerX - 2, centerY - 2, rw, rh);
            }
        }
    }

    private class TriStateModel
    extends JToggleButton.ToggleButtonModel {
        protected State state;

        public TriStateModel(State state) {
            this.state = state;
        }

        @Override
        public boolean isSelected() {
            return this.state == State.CHECKED;
        }

        public State getState() {
            return this.state;
        }

        public void setState(State state) {
            this.state = state;
            this.fireStateChanged();
        }

        @Override
        public void setPressed(boolean pressed) {
            log.debug("setPressed {}", (Object)pressed);
            if (pressed && this.isEnabled()) {
                this.state = this.state == State.UNCHECKED ? State.CHECKED : State.UNCHECKED;
                this.fireStateChanged();
                this.fireActionPerformed(new ActionEvent(this, 1001, this.getActionCommand()));
            }
        }

        @Override
        public void setSelected(boolean selected) {
            this.state = selected ? State.CHECKED : State.UNCHECKED;
            super.setSelected(selected);
        }
    }
}

