/*
 * Decompiled with CFR 0.152.
 */
package jmri.util.swing;

import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import jmri.util.swing.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SearchBar
extends JPanel {
    Runnable forward;
    Runnable backward;
    Runnable done;
    JTextField textField = new JTextField();
    JButton rightButton = new JButton(">");
    JButton leftButton = new JButton("<");
    JButton doneButton = new JButton(Bundle.getMessage("ButtonDone"));
    private static final Logger log = LoggerFactory.getLogger(SearchBar.class);

    public SearchBar(final Runnable forward, final Runnable backward, final Runnable done) {
        this.forward = forward;
        this.backward = backward;
        this.done = done;
        this.setLayout(new BoxLayout(this, 0));
        this.add(this.textField);
        this.add(Box.createHorizontalGlue());
        this.add(this.leftButton);
        this.add(this.rightButton);
        this.add(this.doneButton);
        this.leftButton.setToolTipText("Search backwards");
        this.rightButton.setToolTipText("Search forwards");
        this.doneButton.setToolTipText("Close search bar");
        this.doneButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (done != null) {
                    log.debug("firing done");
                    done.run();
                } else {
                    log.warn("no search done defined, setting invisible");
                    SearchBar.this.setVisible(false);
                }
            }
        });
        this.leftButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (backward != null) {
                    log.debug("firing backward");
                    backward.run();
                } else {
                    log.warn("no backward search defined");
                }
            }
        });
        this.rightButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (forward != null) {
                    log.debug("firing forward");
                    forward.run();
                } else {
                    log.warn("no forward search defined");
                }
            }
        });
        this.textField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (forward != null) {
                    log.debug("firing forward");
                    forward.run();
                } else {
                    log.warn("no forward search defined");
                }
                SearchBar.this.rightButton.requestFocusInWindow();
            }
        });
    }

    public String getSearchString() {
        return this.textField.getText();
    }

    public void configureKeyModifiers(JFrame frame) {
        JRootPane rootPane = frame.getRootPane();
        rootPane.getInputMap(2).put(KeyStroke.getKeyStroke(70, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()), "openSearch");
        rootPane.getActionMap().put("openSearch", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SearchBar.this.textField.setText("");
                SearchBar.this.setVisible(!SearchBar.this.isVisible());
                if (SearchBar.this.isVisible()) {
                    SearchBar.this.textField.requestFocusInWindow();
                }
            }
        });
        rootPane.getInputMap(2).put(KeyStroke.getKeyStroke(71, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() | 0x40), "forwardSearch");
        rootPane.getActionMap().put("forwardSearch", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SearchBar.this.leftButton.doClick();
            }
        });
        rootPane.getInputMap(2).put(KeyStroke.getKeyStroke(71, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()), "backwardSearch");
        rootPane.getActionMap().put("backwardSearch", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SearchBar.this.rightButton.doClick();
            }
        });
    }
}

