/*
 * Decompiled with CFR 0.152.
 */
package jmri.util.swing;

import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Window;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.coobird.thumbnailator.ThumbnailParameter;
import net.coobird.thumbnailator.builders.ThumbnailParameterBuilder;
import net.coobird.thumbnailator.filters.ImageFilter;
import net.coobird.thumbnailator.tasks.io.FileImageSource;
import org.apache.batik.anim.dom.SAXSVGDocumentFactory;
import org.apache.batik.transcoder.TranscoderException;
import org.apache.batik.transcoder.TranscoderInput;
import org.apache.batik.transcoder.TranscoderOutput;
import org.apache.batik.transcoder.TranscodingHints;
import org.apache.batik.transcoder.image.ImageTranscoder;
import org.apache.batik.util.XMLResourceDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

public class ResizableImagePanel
extends JPanel
implements ComponentListener {
    public static final String IMAGE_PATH = "imagePath";
    private String _imagePath;
    protected JLabel bgImg = null;
    private BufferedImage image = null;
    private Document svgImage = null;
    private BufferedImage scaledImage = null;
    private boolean _resizeContainer = false;
    private boolean _respectAspectRatio = true;
    private static Color backgroundColor = Color.BLACK;
    boolean toResize = false;
    static final Dimension SMALL_DIM = new Dimension(10, 10);
    private static final Logger log = LoggerFactory.getLogger(ResizableImagePanel.class);

    public ResizableImagePanel() {
        super.setBackground(backgroundColor);
        this.setVisible(false);
    }

    public ResizableImagePanel(String imagePath) {
        super.setBackground(backgroundColor);
        this.setImagePath(imagePath);
    }

    public ResizableImagePanel(String imagePath, int w, int h) {
        this.setPreferredSize(new Dimension(w, h));
        this.setSize(w, h);
        super.setBackground(backgroundColor);
        this.setImagePath(imagePath);
    }

    @Override
    public void setBackground(Color bckCol) {
        super.setBackground(bckCol);
        this.setScaledImage();
    }

    public void setResizingContainer(boolean b) {
        this._resizeContainer = b;
    }

    public boolean isResizingContainer() {
        return this._resizeContainer;
    }

    public boolean isRespectingAspectRatio() {
        return this._respectAspectRatio;
    }

    public void setRespectAspectRatio(boolean b) {
        this._respectAspectRatio = b;
    }

    public String getImagePath() {
        return this._imagePath;
    }

    private BufferedImage readImage(File file) throws IOException {
        ThumbnailParameterBuilder builder = new ThumbnailParameterBuilder();
        builder.scale(1.0);
        ThumbnailParameter param = builder.build();
        FileImageSource fileImageSource = new FileImageSource(file);
        fileImageSource.setThumbnailParameter(param);
        BufferedImage img = fileImageSource.read();
        for (ImageFilter filter : param.getImageFilters()) {
            img = filter.apply(img);
        }
        return img;
    }

    private Document createSVGDocument(String uri) throws IOException {
        String parser = XMLResourceDescriptor.getXMLParserClassName();
        SAXSVGDocumentFactory factory = new SAXSVGDocumentFactory(parser);
        return factory.createDocument(uri);
    }

    public void setImagePath(String s) {
        String old = this._imagePath;
        if (s != null && !s.equals("")) {
            this._imagePath = s;
        } else {
            this._imagePath = null;
            this.image = null;
            this.scaledImage = null;
            this.svgImage = null;
        }
        log.debug("Image path is now : {}", (Object)this._imagePath);
        if (this._imagePath != null) {
            try {
                File imf = new File(this._imagePath);
                if (this._imagePath.toUpperCase().endsWith(".SVG")) {
                    this.svgImage = this.createSVGDocument(imf.toURI().toString());
                    this.image = null;
                } else {
                    this.svgImage = null;
                    this.image = this.readImage(imf);
                }
            }
            catch (IOException iOException) {
                log.error("{} is not a valid image file.", (Object)this._imagePath);
                this.image = null;
                this.svgImage = null;
                this.scaledImage = null;
            }
        }
        if (this.isResizingContainer()) {
            this.resizeContainer();
        }
        this.setScaledImage();
        this.setVisible(true);
        this.repaint();
        if (this.getParent() != null) {
            this.getParent().repaint();
        }
        this.firePropertyChange(IMAGE_PATH, old, this._imagePath);
    }

    @Override
    public void componentResized(ComponentEvent e) {
        if (!this.isResizingContainer()) {
            if (e.getComponent().isVisible()) {
                this.setSize(e.getComponent().getSize());
                this.setPreferredSize(e.getComponent().getSize());
                this.setScaledImage();
                this.toResize = false;
            } else {
                this.toResize = true;
            }
        }
        this.repaint();
        if (this.getParent() != null) {
            this.getParent().repaint();
        }
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentShown(ComponentEvent e) {
        if (this.isResizingContainer()) {
            this.resizeContainer();
        } else if (this.toResize || this.scaledImage == null) {
            this.setSize(e.getComponent().getSize());
            this.setPreferredSize(e.getComponent().getSize());
            this.setScaledImage();
            this.toResize = false;
        }
    }

    @Override
    public void componentHidden(ComponentEvent e) {
        log.debug("Component hidden");
        if (this.isResizingContainer()) {
            this.resizeContainer(SMALL_DIM);
        }
    }

    private void resizeContainer(Dimension d) {
        log.debug("Resizing container");
        Container p1 = this.getParent();
        if (p1 != null && this.image != null) {
            this.setPreferredSize(d);
            this.setSize(d);
            p1.setPreferredSize(d);
            p1.setSize(d);
            Container c = this.getTopLevelAncestor();
            if (c != null && c instanceof Window) {
                ((Window)c).pack();
            }
        }
    }

    private void resizeContainer() {
        if (this.scaledImage != null) {
            this.resizeContainer(new Dimension(this.scaledImage.getWidth(null), this.scaledImage.getHeight(null)));
        } else if (this.image != null) {
            this.resizeContainer(new Dimension(this.image.getWidth(null), this.image.getHeight(null)));
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.scaledImage != null) {
            g.drawImage(this.scaledImage, 0, 0, this);
        } else {
            g.clearRect(0, 0, (int)this.getSize().getWidth(), (int)this.getSize().getHeight());
        }
    }

    public BufferedImage getScaledImage() {
        return this.scaledImage;
    }

    private void setScaledImage() {
        if (this.image != null) {
            if (this.getSize().getWidth() != 0.0 && this.getSize().getHeight() != 0.0 && (this.getSize().getWidth() != (double)this.image.getWidth(null) || this.getSize().getHeight() != (double)this.image.getHeight(null))) {
                int newW = (int)this.getSize().getWidth();
                int newH = (int)this.getSize().getHeight();
                int new0x = 0;
                int new0y = 0;
                log.debug("Actually resizing image {} to {}x{}", new Object[]{this.getImagePath(), newW, newH});
                this.scaledImage = new BufferedImage(newW, newH, this.image.getType() == 0 ? 2 : this.image.getType());
                Graphics2D g = this.scaledImage.createGraphics();
                g.setBackground(this.getBackground());
                g.clearRect(0, 0, newW, newH);
                g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
                if (this._respectAspectRatio) {
                    if (this.getSize().getWidth() / this.getSize().getHeight() > (double)this.image.getWidth(null) / (double)this.image.getHeight(null)) {
                        newW = this.image.getWidth(null) * newH / this.image.getHeight(null);
                        new0x = (int)(this.getSize().getWidth() - (double)newW) / 2;
                    } else {
                        newH = this.image.getHeight(null) * newW / this.image.getWidth(null);
                        new0y = (int)(this.getSize().getHeight() - (double)newH) / 2;
                    }
                }
                g.drawImage(this.image, new0x, new0y, new0x + newW, new0y + newH, 0, 0, this.image.getWidth(), this.image.getHeight(), this);
                g.dispose();
            } else {
                this.scaledImage = this.image;
            }
        } else if (this.svgImage != null) {
            MyTranscoder transcoder = new MyTranscoder();
            TranscodingHints hints = new TranscodingHints();
            hints.put((Object)ImageTranscoder.KEY_WIDTH, (Object)Float.valueOf((float)this.getSize().getWidth()));
            hints.put((Object)ImageTranscoder.KEY_HEIGHT, (Object)Float.valueOf((float)this.getSize().getHeight()));
            transcoder.setTranscodingHints(hints);
            try {
                transcoder.transcode(new TranscoderInput(this.svgImage), null);
            }
            catch (TranscoderException ex) {
                log.debug("Exception while transposing sbg : {}", (Object)ex.getMessage());
            }
            this.scaledImage = transcoder.getImage();
        }
    }

    private static class MyTranscoder
    extends ImageTranscoder {
        private BufferedImage image = null;

        private MyTranscoder() {
        }

        public BufferedImage createImage(int w, int h) {
            this.image = new BufferedImage(w, h, 2);
            return this.image;
        }

        public BufferedImage getImage() {
            return this.image;
        }

        public void writeImage(BufferedImage bi, TranscoderOutput to) throws TranscoderException {
        }
    }
}

