/*
 * Decompiled with CFR 0.152.
 */
package jmri.util.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.colorchooser.AbstractColorChooserPanel;
import jmri.util.ColorUtil;
import jmri.util.swing.Bundle;
import jmri.util.swing.JmriColorChooser;

public class JmriColorChooserPanel
extends AbstractColorChooserPanel {
    private Color[] colors = new Color[]{Color.black, Color.darkGray, Color.gray, Color.lightGray, Color.white, Color.red, Color.pink, Color.orange, Color.yellow, Color.green, Color.blue, Color.magenta, Color.cyan, ColorUtil.BROWN};
    private int numColors = 14;
    private JPanel recentPanel = new JPanel(new GridBagLayout());

    @Override
    public void updateChooser() {
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        this.recentPanel.removeAll();
        ArrayList<Color> colors = JmriColorChooser.getRecentColors();
        int cols = Math.max(3, (int)Math.ceil((double)colors.size() / 7.0));
        int idx = 0;
        for (Color recent : colors) {
            c.gridx = idx % cols;
            c.gridy = idx / cols;
            this.recentPanel.add((Component)this.createColorButton(recent, false), c);
            ++idx;
        }
    }

    @Override
    protected void buildChooser() {
        this.setLayout(new BoxLayout(this, 0));
        JPanel stdColors = new JPanel(new GridBagLayout());
        stdColors.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("StandardColorLabel")));
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        int i = 0;
        while (i < this.numColors) {
            c.gridx = i % 2;
            c.gridy = i / 2;
            stdColors.add((Component)this.createColorButton(this.colors[i], true), c);
            ++i;
        }
        this.add(stdColors);
        stdColors.setVisible(true);
        this.recentPanel.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("RecentColorLabel")));
        ArrayList<Color> colors = JmriColorChooser.getRecentColors();
        int cols = Math.max(3, (int)Math.ceil((double)colors.size() / 7.0));
        int idx = 0;
        for (Color recent : colors) {
            c.gridx = idx % cols;
            c.gridy = idx / cols;
            this.recentPanel.add((Component)this.createColorButton(recent, false), c);
            ++idx;
        }
        this.add(this.recentPanel);
        this.recentPanel.setVisible(true);
    }

    JButton createColorButton(Color color, boolean stdcolor) {
        BufferedImage image = new BufferedImage(40, 15, 2);
        Graphics g = image.getGraphics();
        g.setColor(new Color(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()));
        g.fillRect(0, 0, 40, 15);
        g.setColor(Color.black);
        g.drawRect(0, 0, 39, 14);
        ImageIcon icon = new ImageIcon(image);
        String colorName = "";
        if (stdcolor) {
            colorName = ColorUtil.colorToLocalizedName(color);
        }
        String colorTip = String.format("r=%d, g=%d, b=%d, a=%d", color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha());
        JButton colorButton = new JButton(colorName, icon);
        colorButton.setToolTipText(colorTip);
        colorButton.addActionListener(e -> this.getColorSelectionModel().setSelectedColor(color));
        return colorButton;
    }

    @Override
    public String getDisplayName() {
        return "JMRI";
    }

    @Override
    public Icon getSmallDisplayIcon() {
        return null;
    }

    @Override
    public Icon getLargeDisplayIcon() {
        return null;
    }
}

