/*
 * Decompiled with CFR 0.152.
 */
package jmri.util.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import javax.annotation.CheckReturnValue;
import javax.swing.ComboBoxEditor;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.ListSelectionModel;
import javax.swing.UIManager;
import javax.swing.plaf.basic.BasicComboBoxRenderer;
import javax.swing.text.JTextComponent;
import jmri.Manager;
import jmri.NamedBean;
import jmri.util.AlphanumComparator;
import jmri.util.swing.DedupingPropertyChangeListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class JmriBeanComboBox
extends JComboBox<String>
implements PropertyChangeListener {
    private String _lastSelected = "";
    private DisplayOptions _displayOrder;
    private boolean _firstBlank = false;
    private Manager _manager;
    private HashMap<String, NamedBean> displayToBean = new HashMap();
    List<NamedBean> exclude = new ArrayList<NamedBean>();
    private boolean _validateMode = false;
    private EnabledComboBoxRenderer _enableRenderer = null;
    private static final Logger log = LoggerFactory.getLogger(JmriBeanComboBox.class);

    public JmriBeanComboBox(Manager inManager) {
        this(inManager, null, DisplayOptions.DISPLAYNAME);
    }

    public JmriBeanComboBox(Manager inManager, NamedBean inNamedBean, DisplayOptions inDisplayOrder) {
        this._displayOrder = inDisplayOrder;
        this._manager = inManager;
        this.setSelectedBean(inNamedBean);
        this._manager.addPropertyChangeListener(new DedupingPropertyChangeListener(this));
        this.setKeySelectionManager(new BeanSelectionManager());
        this.addItemListener(event -> {
            if (event.getStateChange() == 1) {
                this.validateText();
            }
        });
        this.getEditor().getEditorComponent().addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent event) {
                JmriBeanComboBox.this.validateText();
            }
        });
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if (e.getPropertyName().equals("length")) {
            int newValueInt;
            this._lastSelected = (String)this.getSelectedItem();
            this.updateComboBox(this._lastSelected);
            log.debug("Update triggered in name list");
            Object oldValueObject = e.getOldValue();
            int oldValueInt = oldValueObject == null ? 0 : Integer.parseInt(oldValueObject.toString());
            Object newValueObject = e.getNewValue();
            int n = newValueInt = newValueObject == null ? 0 : Integer.parseInt(newValueObject.toString());
            if (oldValueInt < newValueInt) {
                this.addSelectionInterval(oldValueInt, newValueInt);
            } else if (oldValueInt > newValueInt) {
                this.removeSelectionInterval(newValueInt, oldValueInt);
            }
        } else if (e.getPropertyName().equals("DisplayListName")) {
            this.refreshCombo();
        }
    }

    public Manager getManager() {
        return this._manager;
    }

    public void refreshCombo() {
        this.updateComboBox((String)this.getSelectedItem());
    }

    private void updateComboBox(String inSelect) {
        this.displayToBean = new HashMap();
        this.removeAllItems();
        String[] displayList = this.getDisplayList();
        int i = 0;
        while (i < displayList.length) {
            this.addItem(displayList[i]);
            if (inSelect != null && displayList[i].equals(inSelect)) {
                this.setSelectedIndex(i);
            }
            ++i;
        }
        if (this._firstBlank) {
            super.insertItemAt("", 0);
            if (this._lastSelected == null || this._lastSelected.equals("")) {
                this.setSelectedIndex(0);
            }
        }
    }

    public String[] getDisplayList() {
        ArrayList<String> nameList = new ArrayList<String>();
        for (Object obj : this._manager.getNamedBeanSet()) {
            nameList.add(((NamedBean)obj).getSystemName());
        }
        this.exclude.stream().filter(bean -> bean != null).forEachOrdered(bean -> nameList.remove(bean.getSystemName()));
        String[] displayList = new String[nameList.size()];
        if (this._displayOrder == DisplayOptions.SYSTEMNAME) {
            displayList = nameList.toArray(displayList);
        } else {
            int i = 0;
            while (i < nameList.size()) {
                String name = (String)nameList.get(i);
                Object nBean = this._manager.getBySystemName(name);
                if (nBean != null) {
                    String uname = nBean.getUserName();
                    switch (this._displayOrder) {
                        case USERNAME: {
                            if (uname != null && !uname.equals("")) {
                                displayList[i] = uname;
                                break;
                            }
                            displayList[i] = name;
                            break;
                        }
                        case USERNAMESYSTEMNAME: 
                        case SYSTEMNAMEUSERNAME: {
                            if (uname != null && !uname.equals("")) {
                                displayList[i] = nBean.getDisplayName(NamedBean.DisplayOptions.USERNAME_SYSTEMNAME);
                                break;
                            }
                            displayList[i] = name;
                            break;
                        }
                        default: {
                            displayList[i] = nBean.getDisplayName();
                        }
                    }
                    this.displayToBean.put(displayList[i], (NamedBean)nBean);
                }
                ++i;
            }
        }
        Arrays.sort(displayList, new AlphanumComparator());
        return displayList;
    }

    public NamedBean getSelectedBean() {
        String selectedName = (String)super.getSelectedItem();
        return this.displayToBean.get(selectedName);
    }

    public String getSelectedUserName() {
        String result = null;
        NamedBean nBean = this.getSelectedBean();
        if (nBean != null) {
            result = nBean.getDisplayName();
        }
        return result;
    }

    public String getSelectedSystemName() {
        String result = null;
        NamedBean nBean = this.getSelectedBean();
        if (nBean != null) {
            result = nBean.getSystemName();
        }
        return result;
    }

    public String getSelectedDisplayName() {
        String result = null;
        NamedBean nBean = this.getSelectedBean();
        if (nBean != null) {
            result = nBean.getDisplayName();
        }
        return result;
    }

    public String getUserName() {
        NamedBean b;
        String result = null;
        if (this.isEditable()) {
            result = NamedBean.normalizeUserName(this.getText());
            if (result == null) {
                result = "";
            }
            b = this.getNamedBean();
        } else {
            b = this.getSelectedBean();
        }
        if (b != null) {
            result = b.getUserName();
        }
        return result;
    }

    @CheckReturnValue
    public String getDisplayName() {
        NamedBean b;
        String result = null;
        if (this.isEditable()) {
            result = NamedBean.normalizeUserName(this.getText());
            if (result == null) {
                result = "";
            }
            b = this.getNamedBean();
        } else {
            b = this.getSelectedBean();
        }
        if (b != null) {
            result = b.getDisplayName();
        }
        return result;
    }

    public String getText() {
        return this.getEditor().getItem().toString();
    }

    public void setText(String inText) {
        this.getEditor().setItem(inText);
        if (inText != null && !inText.isEmpty()) {
            this.setSelectedBeanByName(inText);
        } else {
            this.setSelectedIndex(-1);
        }
        this.validateText();
    }

    public DisplayOptions getDisplayOrder() {
        return this._displayOrder;
    }

    public void setDisplayOrder(DisplayOptions inDisplayOrder) {
        if (this._displayOrder != inDisplayOrder) {
            NamedBean selectedBean = this.getSelectedBean();
            this._displayOrder = inDisplayOrder;
            this.setSelectedBean(selectedBean);
        }
    }

    public void setFirstItemBlank(boolean inFirstItemBlank) {
        if (this._firstBlank == inFirstItemBlank) {
            return;
        }
        if (this._firstBlank) {
            super.removeItemAt(0);
        } else {
            super.insertItemAt("", 0);
            if (this._lastSelected == null || this._lastSelected.equals("")) {
                this.setSelectedIndex(0);
            }
        }
        this._firstBlank = inFirstItemBlank;
    }

    public void setSelectedBean(NamedBean inNamedBean) {
        String selectedItem = "";
        if (inNamedBean != null) {
            String uname = inNamedBean.getUserName();
            switch (this._displayOrder) {
                case DISPLAYNAME: {
                    selectedItem = inNamedBean.getDisplayName();
                    break;
                }
                case USERNAME: {
                    selectedItem = inNamedBean.getUserName();
                    break;
                }
                case SYSTEMNAME: {
                    selectedItem = inNamedBean.getSystemName();
                    break;
                }
                case USERNAMESYSTEMNAME: 
                case SYSTEMNAMEUSERNAME: {
                    if (uname != null && !uname.equals("")) {
                        selectedItem = inNamedBean.getDisplayName(NamedBean.DisplayOptions.USERNAME_SYSTEMNAME);
                        break;
                    }
                    selectedItem = inNamedBean.getSystemName();
                    break;
                }
                default: {
                    selectedItem = inNamedBean.getDisplayName();
                    break;
                }
            }
        } else if (this._firstBlank) {
            this._lastSelected = "";
        }
        this._lastSelected = selectedItem;
        this.updateComboBox(this._lastSelected);
    }

    public void setSelectedBeanByName(String inBeanName) {
        if (inBeanName == null) {
            return;
        }
        Object nBean = this._manager.getNamedBean(inBeanName);
        this.setSelectedBean((NamedBean)nBean);
    }

    public void excludeItems(List<NamedBean> inExcludeList) {
        this.exclude = inExcludeList;
        this._lastSelected = this.getSelectedDisplayName();
        this.updateComboBox(this._lastSelected);
    }

    public List<NamedBean> getExcludeItems() {
        return this.exclude;
    }

    public void setValidateMode(boolean inValidateMode) {
        if (this._validateMode != inValidateMode) {
            this._validateMode = inValidateMode;
        }
    }

    public boolean isValidateMode() {
        return this._validateMode;
    }

    private void validateText() {
        ComboBoxEditor cbe = this.getEditor();
        JTextComponent c = (JTextComponent)cbe.getEditorComponent();
        String comboBoxText = cbe.getItem().toString();
        if (this.isEditable() && !comboBoxText.isEmpty()) {
            this.setOpaque(true);
            if (this.getNamedBean() != null) {
                c.setBackground(new Color(12446902));
            } else if (this._validateMode) {
                c.setBackground(new Color(0xFFC0C0));
            } else {
                c.setBackground(new Color(16645526));
            }
        } else {
            this.setOpaque(false);
            c.setBackground(new Color(0xFFFFFF));
        }
    }

    public NamedBean getNamedBean() {
        Manager uDaManager = this.getManager();
        String comboBoxText = NamedBean.normalizeUserName(this.getText());
        if (comboBoxText != null) {
            Object result = uDaManager.getByUserName(comboBoxText);
            if (result == null) {
                result = uDaManager.getNamedBean(comboBoxText);
            }
            if (result == null) {
                String[] displayList = this.getDisplayList();
                boolean found = false;
                String[] stringArray = displayList;
                int n = displayList.length;
                int n2 = 0;
                while (n2 < n) {
                    String item = stringArray[n2];
                    if (item.equals(comboBoxText)) {
                        found = true;
                        break;
                    }
                    ++n2;
                }
                if (found) {
                    SortedSet namedBeanSet = uDaManager.getNamedBeanSet();
                    for (NamedBean namedBean : namedBeanSet) {
                        if (namedBean.getUserName() == null) continue;
                        String usname = namedBean.getDisplayName(NamedBean.DisplayOptions.USERNAME_SYSTEMNAME);
                        String suname = namedBean.getDisplayName(NamedBean.DisplayOptions.USERNAME_SYSTEMNAME);
                        if (!comboBoxText.equals(usname) && !comboBoxText.equals(suname)) continue;
                        result = namedBean;
                        break;
                    }
                }
            }
            return result;
        }
        return null;
    }

    public void dispose() {
        this._manager.removePropertyChangeListener(this);
    }

    public void setEnabledItems(ListSelectionModel inEnabledItems) {
        this.getEnabledComboBoxRenderer().setEnabledItems(inEnabledItems);
    }

    public ListSelectionModel getEnabledItems() {
        return this.getEnabledComboBoxRenderer().getEnabledItems();
    }

    public void addSelectionInterval(int inMinIndex, int inMaxIndex) {
        ListSelectionModel lsm = this.getEnabledItems();
        if (lsm != null) {
            lsm.addSelectionInterval(inMinIndex, inMaxIndex);
        }
    }

    public void removeSelectionInterval(int inMinIndex, int inMaxIndex) {
        ListSelectionModel lsm = this.getEnabledItems();
        if (lsm != null) {
            lsm.removeSelectionInterval(inMinIndex, inMaxIndex);
        }
    }

    public void setItemEnabled(int inIndex, boolean inEnabled) {
        ListSelectionModel lsm = this.getEnabledItems();
        if (lsm != null) {
            if (inEnabled) {
                lsm.addSelectionInterval(inIndex, inIndex);
            } else {
                lsm.removeSelectionInterval(inIndex, inIndex);
            }
        }
    }

    public boolean isItemEnabled(int inIndex) {
        boolean result = false;
        ListSelectionModel lsm = this.getEnabledItems();
        if (lsm != null) {
            result = lsm.isSelectedIndex(inIndex);
        }
        return result;
    }

    public void enableItem(int inIndex) {
        this.setItemEnabled(inIndex, true);
    }

    public void disableItem(int inIndex) {
        this.setItemEnabled(inIndex, false);
    }

    public void setEnabledColor(Color inEnabledColor) {
        this.getEnabledComboBoxRenderer().setEnabledColor(inEnabledColor);
    }

    public Color getEnabledColor() {
        return this.getEnabledComboBoxRenderer().getEnabledColor();
    }

    public void setDisabledColor(Color inDisabledColor) {
        this.getEnabledComboBoxRenderer().setDisabledColor(inDisabledColor);
    }

    public Color getDisabledColor() {
        return this.getEnabledComboBoxRenderer().getDisabledColor();
    }

    public void setEnabledBackgroundColor(Color inEnabledBackgroundColor) {
        this.getEnabledComboBoxRenderer().setEnabledBackgroundColor(inEnabledBackgroundColor);
    }

    public Color getEnabledBackgroundColor() {
        return this.getEnabledComboBoxRenderer().getEnabledBackgroundColor();
    }

    public void setDisabledBackgroundColor(Color inDisabledBackgroundColor) {
        this.getEnabledComboBoxRenderer().setDisabledBackgroundColor(inDisabledBackgroundColor);
    }

    public Color getDisabledBackgroundColor() {
        return this.getEnabledComboBoxRenderer().getDisabledBackgroundColor();
    }

    private EnabledComboBoxRenderer getEnabledComboBoxRenderer() {
        if (this._enableRenderer == null) {
            this._enableRenderer = new EnabledComboBoxRenderer();
            this.setRenderer(this._enableRenderer);
            ListSelectionModel lsm = this._enableRenderer.getEnabledItems();
            lsm.addSelectionInterval(0, this._manager.getNamedBeanSet().size());
        }
        return this._enableRenderer;
    }

    static class BeanSelectionManager
    implements JComboBox.KeySelectionManager {
        long lastKeyTime = 0L;
        String pattern = "";

        BeanSelectionManager() {
        }

        public int selectionForKey(char inKey, ComboBoxModel model) {
            String s;
            long curTime;
            int selIx = 1;
            Object sel = model.getSelectedItem();
            if (sel != null) {
                int i = 0;
                while (i < model.getSize()) {
                    if (sel.equals(model.getElementAt(i))) {
                        selIx = i;
                        break;
                    }
                    ++i;
                }
            }
            this.pattern = (curTime = System.currentTimeMillis()) - this.lastKeyTime < 300L ? String.valueOf(this.pattern) + ("" + inKey).toLowerCase() : ("" + inKey).toLowerCase();
            this.lastKeyTime = curTime;
            int i = selIx + 1;
            while (i < model.getSize()) {
                s = model.getElementAt(i).toString().toLowerCase();
                if (s.startsWith(this.pattern)) {
                    return i;
                }
                ++i;
            }
            i = 0;
            while (i < selIx) {
                if (model.getElementAt(i) != null && (s = model.getElementAt(i).toString().toLowerCase()).startsWith(this.pattern)) {
                    return i;
                }
                ++i;
            }
            return -1;
        }
    }

    public static enum DisplayOptions {
        DISPLAYNAME(1),
        USERNAME(2),
        SYSTEMNAME(3),
        USERNAMESYSTEMNAME(4),
        SYSTEMNAMEUSERNAME(5);

        private int value;
        private static final Map<Integer, DisplayOptions> enumMap;

        static {
            HashMap<Integer, DisplayOptions> map = new HashMap<Integer, DisplayOptions>();
            DisplayOptions[] displayOptionsArray = DisplayOptions.values();
            int n = displayOptionsArray.length;
            int n2 = 0;
            while (n2 < n) {
                DisplayOptions instance = displayOptionsArray[n2];
                map.put(instance.getValue(), instance);
                ++n2;
            }
            enumMap = Collections.unmodifiableMap(map);
        }

        private DisplayOptions(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static DisplayOptions valueOf(String string) {
            return Enum.valueOf(DisplayOptions.class, string);
        }
    }

    static class EnabledComboBoxRenderer
    extends BasicComboBoxRenderer {
        private ListSelectionModel _enabledItems;
        private Color _enabledColor = super.getForeground();
        private Color _disabledColor = Color.lightGray;
        private Color _enabledBackgroundColor = super.getBackground();
        private Color _disabledBackgroundColor = super.getBackground();

        public EnabledComboBoxRenderer() {
            this._enabledItems = new DefaultListSelectionModel();
        }

        public EnabledComboBoxRenderer(ListSelectionModel inEnabledItems) {
            this._enabledItems = inEnabledItems;
        }

        public void setEnabledItems(ListSelectionModel inEnabledItems) {
            this._enabledItems = inEnabledItems;
        }

        public ListSelectionModel getEnabledItems() {
            return this._enabledItems;
        }

        public void setItemEnabled(int inIndex, boolean inEnabled) {
            if (this._enabledItems != null) {
                if (inEnabled) {
                    this._enabledItems.addSelectionInterval(inIndex, inIndex);
                } else {
                    this._enabledItems.removeSelectionInterval(inIndex, inIndex);
                }
            }
        }

        public boolean isItemEnabled(int inIndex) {
            boolean result = false;
            if (this._enabledItems != null) {
                result = this._enabledItems.isSelectedIndex(inIndex);
            }
            return result;
        }

        public void setEnabledColor(Color inEnabledColor) {
            this._enabledColor = inEnabledColor;
        }

        public Color getEnabledColor() {
            return this._enabledColor;
        }

        public void setDisabledColor(Color inDisabledColor) {
            this._disabledColor = inDisabledColor;
        }

        public Color getDisabledColor() {
            return this._disabledColor;
        }

        public void setEnabledBackgroundColor(Color inEnabledBackgroundColor) {
            this._enabledBackgroundColor = inEnabledBackgroundColor;
        }

        public Color getEnabledBackgroundColor() {
            return this._enabledBackgroundColor;
        }

        public void setDisabledBackgroundColor(Color inDisabledBackgroundColor) {
            this._disabledBackgroundColor = inDisabledBackgroundColor;
        }

        public Color getDisabledBackgroundColor() {
            return this._disabledBackgroundColor;
        }

        @Override
        public Component getListCellRendererComponent(JList inList, Object inValue, int inIndex, boolean isSelected, boolean inCellHasFocus) {
            Component c = super.getListCellRendererComponent((JList<?>)inList, inValue, inIndex, isSelected, inCellHasFocus);
            if (this._enabledItems.isSelectedIndex(inIndex)) {
                c.setBackground(this._enabledBackgroundColor);
                c.setForeground(this._enabledColor);
            } else {
                if (isSelected) {
                    c.setBackground(UIManager.getColor("ComboBox.background"));
                } else {
                    c.setBackground(this._disabledBackgroundColor);
                }
                c.setForeground(this._disabledColor);
            }
            return c;
        }
    }
}

