/*
 * Decompiled with CFR 0.152.
 */
package jmri.util.swing;

import java.awt.Component;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JList;
import jmri.InstanceManager;
import jmri.util.SystemType;
import jmri.util.gui.GuiLafPreferencesManager;

public class JComboBoxUtil {
    public static <E, T extends JComboBox<E>> void setupComboBoxMaxRows(T inComboBox) {
        int maxItemHeight = 12;
        if (inComboBox.getItemCount() == 0 || inComboBox.getItemCount() == 1 && "".equals(inComboBox.getItemAt(0))) {
            maxItemHeight = JComboBoxUtil.getDefaultRowHeight(maxItemHeight);
        }
        ComboBoxModel<E> lm = inComboBox.getModel();
        JList<E> list = new JList<E>(lm);
        int i = 0;
        while (i < lm.getSize()) {
            Object value = lm.getElementAt(i);
            Component c = list.getCellRenderer().getListCellRendererComponent(list, value, i, false, false);
            maxItemHeight = Math.max(maxItemHeight, c.getPreferredSize().height);
            ++i;
        }
        if (SystemType.isMacOSX()) {
            ++maxItemHeight;
        }
        int itemsPerScreen = inComboBox.getItemCount();
        if (!GraphicsEnvironment.isHeadless()) {
            Rectangle maxWindowBounds = GraphicsEnvironment.getLocalGraphicsEnvironment().getMaximumWindowBounds();
            itemsPerScreen = (int)maxWindowBounds.getHeight() / maxItemHeight;
        }
        int c = Math.max(itemsPerScreen - 1, 8);
        int maxRows = InstanceManager.getDefault(GuiLafPreferencesManager.class).getMaxComboRows();
        if (maxRows > 0) {
            c = Math.min(c, maxRows);
        }
        inComboBox.setMaximumRowCount(c);
    }

    private static int getDefaultRowHeight(int minimumHeight) {
        String[] data = new String[]{"XYZxyz"};
        JList<String> list = new JList<String>(data);
        String value = list.getModel().getElementAt(0);
        Component c = list.getCellRenderer().getListCellRendererComponent(list, value, 0, false, false);
        return Math.max(minimumHeight, c.getPreferredSize().height);
    }
}

