/*
 * Decompiled with CFR 0.152.
 */
package jmri.util.swing;

import java.awt.event.ActionEvent;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.HashMap;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import jmri.jmrit.XmlFile;
import jmri.util.FileUtil;
import jmri.util.HelpUtil;
import jmri.util.jdom.LocaleSelector;
import jmri.util.swing.JmriAbstractAction;
import jmri.util.swing.JmriNamedPaneAction;
import jmri.util.swing.WindowInterface;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GuiUtilBase {
    private static final Logger log = LoggerFactory.getLogger(GuiUtilBase.class);

    static Action actionFromNode(Element child, WindowInterface wi, Object context) {
        Element childUrl;
        ImageIcon icon = null;
        HashMap<String, String> parameters = new HashMap<String, String>();
        if (child == null) {
            log.warn("Action from node called without child");
            return GuiUtilBase.createEmptyMenuItem(null, "<none>");
        }
        String name = LocaleSelector.getAttribute(child, "name");
        if ((name == null || name.isEmpty()) && child.getChild("name") != null) {
            name = child.getChild("name").getText();
        }
        if ((childUrl = child.getChild("icon")) != null) {
            URL iconUrl = FileUtil.findURL(childUrl.getText());
            if (iconUrl != null) {
                icon = new ImageIcon(iconUrl);
            } else {
                log.warn("Unable to locate icon :{}:", (Object)childUrl.getText());
            }
        }
        if (child.getChild("option") != null) {
            child.getChildren("option").stream().forEach(item -> {
                String setting = item.getAttribute("setting").getValue();
                String setMethod = item.getText();
                parameters.put(setMethod, setting);
            });
        }
        if (child.getChild("adapter") != null) {
            String classname = child.getChild("adapter").getText();
            try {
                Class<?> c = Class.forName(classname);
                Constructor<?>[] constructorArray = c.getConstructors();
                int n = constructorArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Class<?>[] parms;
                    Constructor<?> ct = constructorArray[n2];
                    if (icon == null) {
                        parms = ct.getParameterTypes();
                        if (parms.length == 2 && parms[0] == String.class && parms[1] == WindowInterface.class) {
                            JmriAbstractAction a = (JmriAbstractAction)ct.newInstance(name, wi);
                            a.setName(name);
                            a.setContext(context);
                            GuiUtilBase.setParameters(a, parameters);
                            return a;
                        }
                    } else {
                        parms = ct.getParameterTypes();
                        if (parms.length == 3 && parms[0] == String.class && parms[1] == Icon.class && parms[2] == WindowInterface.class) {
                            JmriAbstractAction a = (JmriAbstractAction)ct.newInstance(name, icon, wi);
                            a.setName(name);
                            a.setContext(context);
                            GuiUtilBase.setParameters(a, parameters);
                            return a;
                        }
                    }
                    ++n2;
                }
                log.warn("Did not find suitable ctor for {}{} icon", (Object)classname, (Object)(icon != null ? " with" : " without"));
                return GuiUtilBase.createEmptyMenuItem(icon, name);
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | InvocationTargetException e) {
                log.warn("failed to load GUI adapter class: {} due to: {}", (Object)classname, (Object)e);
                return GuiUtilBase.createEmptyMenuItem(icon, name);
            }
        }
        if (child.getChild("panel") != null) {
            try {
                JmriNamedPaneAction act = icon == null ? new JmriNamedPaneAction(name, wi, child.getChild("panel").getText()) : new JmriNamedPaneAction(name, icon, wi, child.getChild("panel").getText());
                act.setContext(context);
                GuiUtilBase.setParameters(act, parameters);
                return act;
            }
            catch (Exception ex) {
                log.warn("could not load toolbar adapter class: {} due to {}", (Object)child.getChild("panel").getText(), (Object)ex);
                return GuiUtilBase.createEmptyMenuItem(icon, name);
            }
        }
        if (child.getChild("help") != null) {
            String reference = child.getChild("help").getText();
            return HelpUtil.getHelpAction(name, icon, reference);
        }
        if (child.getChild("current") != null) {
            String[] method = new String[]{child.getChild("current").getText()};
            return GuiUtilBase.createActionInCallingWindow(context, method, name, icon);
        }
        return GuiUtilBase.createEmptyMenuItem(icon, name);
    }

    static Action createActionInCallingWindow(Object obj, String[] args, String name, Icon icon) {
        Method method = null;
        try {
            method = obj.getClass().getDeclaredMethod("remoteCalls", String[].class);
        }
        catch (NullPointerException nullPointerException) {
            log.error("Null object passed");
            return GuiUtilBase.createEmptyMenuItem(icon, name);
        }
        catch (SecurityException securityException) {
            log.error("security exception unable to find remoteCalls for {}", (Object)obj.getClass().getName());
            GuiUtilBase.createEmptyMenuItem(icon, name);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            log.error("No such method remoteCalls for {}", (Object)obj.getClass().getName());
            return GuiUtilBase.createEmptyMenuItem(icon, name);
        }
        CallingAbstractAction act = new CallingAbstractAction(name, icon);
        act.setMethod(method);
        act.setArgs(args);
        act.setObject(obj);
        act.setEnabled(true);
        return act;
    }

    static Action createEmptyMenuItem(Icon icon, String name) {
        if (icon != null) {
            AbstractAction act = new AbstractAction(name, icon){

                @Override
                public void actionPerformed(ActionEvent e) {
                }

                public String toString() {
                    return (String)this.getValue("Name");
                }
            };
            act.setEnabled(false);
            return act;
        }
        AbstractAction act = new AbstractAction(name){

            @Override
            public void actionPerformed(ActionEvent e) {
            }

            public String toString() {
                return (String)this.getValue("Name");
            }
        };
        act.setEnabled(false);
        return act;
    }

    static void setParameters(JmriAbstractAction act, HashMap<String, String> parameters) {
        parameters.entrySet().stream().forEach(map -> act.setParameter((String)map.getKey(), (String)map.getValue()));
    }

    protected static Element rootFromName(String name) {
        try {
            return new XmlFile(){}.rootFromName(name);
        }
        catch (IOException | JDOMException e) {
            log.error("Could not parse file \"{}\" due to: {}", (Object)name, (Object)e);
            return null;
        }
    }

    static class CallingAbstractAction
    extends AbstractAction {
        Method method = null;
        Object obj;
        Object args;

        public CallingAbstractAction(String name, Icon icon) {
            super(name, icon);
        }

        public void setArgs(Object[] args) {
            this.args = args;
        }

        public void setMethod(Method method) {
            this.method = method;
        }

        public void setObject(Object obj) {
            this.obj = obj;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                this.method.invoke(this.obj, this.args);
            }
            catch (IllegalAccessException | IllegalArgumentException | NullPointerException | InvocationTargetException ex) {
                log.error("Exception in actionPerformed", (Throwable)ex);
            }
        }
    }
}

