/*
 * Decompiled with CFR 0.152.
 */
package jmri.util.swing;

import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Window;
import java.util.Objects;
import javax.annotation.CheckForNull;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.border.EmptyBorder;
import jmri.util.swing.Bundle;
import jmri.util.swing.ExceptionContext;

public class ExceptionDisplayFrame
extends JDialog {
    private final transient ExceptionContext context;
    private JPanel contentPane;
    JTextArea stackTraceTextArea;
    private JPanel buttonPanel;
    private JButton copyButton;
    private JButton closeButton;
    private JLabel stackTraceLabel;
    private JButton showDetailsButton;
    private JPanel panel;
    private JPanel panel_2;
    private JLabel lblNewLabel;
    private JLabel lblNewLabel_2;
    private JTextArea operationTextArea;
    private JTextArea messageTextArea;
    private JTextArea hintTextArea;
    private JPanel summaryPanel;
    private JPanel panel_4;
    private JLabel lblNewLabel_3;
    private JLabel lblNewLabel_4;
    private JTextArea summaryTextArea2;
    private JPanel panel_5;
    private JLabel lblNewLabel_5;
    private JTextArea typeTextArea;
    private JPanel panel_6;
    private JLabel lblNewLabel_6;
    private JTextArea toStringTextArea;
    private JPanel panel_7;
    private JLabel lblNewLabel_7;
    private JTextArea causeTextArea;
    private JPanel detailsPanel;
    private JLabel lblNewLabel_1;

    public ExceptionDisplayFrame(ExceptionContext context, @CheckForNull Window owner) {
        super(owner, context.getTitle(), Dialog.ModalityType.DOCUMENT_MODAL);
        Objects.requireNonNull(context, "ExceptionContext argument passed to ErrorDisplayFrame constructor cannot be null.");
        this.context = context;
        this.initComponents();
    }

    public ExceptionDisplayFrame(Exception ex, @CheckForNull Window owner) {
        this(new ExceptionContext(ex, Bundle.getMessage("ExceptionDisplayDefaultOperation"), Bundle.getMessage("ExceptionDisplayDefaultHint")), owner);
    }

    private void initComponents() {
        this.contentPane = new JPanel();
        this.contentPane.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.contentPane.setLayout(new BoxLayout(this.contentPane, 1));
        this.setContentPane(this.contentPane);
        this.lblNewLabel_1 = new JLabel(Bundle.getMessage("ExceptionDisplayWarning"));
        this.lblNewLabel_1.setAlignmentX(0.5f);
        this.contentPane.add(this.lblNewLabel_1);
        this.summaryPanel = new JPanel();
        this.contentPane.add(this.summaryPanel);
        this.lblNewLabel_3 = new JLabel(Bundle.getMessage("ExceptionDisplaySummary"));
        this.summaryPanel.add(this.lblNewLabel_3);
        this.summaryTextArea2 = new JTextArea();
        this.summaryPanel.add(this.summaryTextArea2);
        this.showDetailsButton = new JButton(Bundle.getMessage("ExceptionDisplayDetailsButton"));
        this.showDetailsButton.setAlignmentX(0.5f);
        this.showDetailsButton.addActionListener(arg0 -> {
            this.detailsPanel.setVisible(true);
            this.pack();
        });
        this.contentPane.add(this.showDetailsButton);
        this.detailsPanel = new JPanel();
        this.detailsPanel.setLayout(new BoxLayout(this.detailsPanel, 1));
        this.detailsPanel.setVisible(false);
        this.contentPane.add(this.detailsPanel);
        this.stackTraceTextArea = new JTextArea();
        this.stackTraceTextArea.setToolTipText(Bundle.getMessage("ExceptionDisplayStackTraceToolTip"));
        this.stackTraceLabel = new JLabel(Bundle.getMessage("ExceptionDisplayStackTraceLabel"));
        this.stackTraceLabel.setAlignmentX(0.5f);
        this.stackTraceLabel.setHorizontalAlignment(2);
        this.detailsPanel.add(this.stackTraceLabel);
        this.detailsPanel.add(this.stackTraceTextArea);
        this.panel = new JPanel();
        this.detailsPanel.add(this.panel);
        this.lblNewLabel = new JLabel(Bundle.getMessage("ExceptionDisplayOperationLabel"));
        this.panel.add(this.lblNewLabel);
        this.operationTextArea = new JTextArea();
        this.panel.add(this.operationTextArea);
        this.panel_4 = new JPanel();
        this.detailsPanel.add(this.panel_4);
        this.lblNewLabel_4 = new JLabel(Bundle.getMessage("ExceptionDisplayMessageLabel"));
        this.panel_4.add(this.lblNewLabel_4);
        this.messageTextArea = new JTextArea();
        this.panel_4.add(this.messageTextArea);
        this.panel_2 = new JPanel();
        this.detailsPanel.add(this.panel_2);
        this.lblNewLabel_2 = new JLabel(Bundle.getMessage("ExceptionDisplayHintLabel"));
        this.panel_2.add(this.lblNewLabel_2);
        this.hintTextArea = new JTextArea();
        this.panel_2.add(this.hintTextArea);
        this.panel_5 = new JPanel();
        this.detailsPanel.add(this.panel_5);
        this.lblNewLabel_5 = new JLabel(Bundle.getMessage("ExceptionDisplayExceptionTypeLabel"));
        this.panel_5.add(this.lblNewLabel_5);
        this.typeTextArea = new JTextArea();
        this.panel_5.add(this.typeTextArea);
        this.panel_6 = new JPanel();
        this.detailsPanel.add(this.panel_6);
        this.lblNewLabel_6 = new JLabel(Bundle.getMessage("ExceptionDisplayToStringLabel"));
        this.panel_6.add(this.lblNewLabel_6);
        this.toStringTextArea = new JTextArea();
        this.panel_6.add(this.toStringTextArea);
        this.panel_7 = new JPanel();
        this.detailsPanel.add(this.panel_7);
        this.lblNewLabel_7 = new JLabel(Bundle.getMessage("ExceptionDisplayCauseLabel"));
        this.panel_7.add(this.lblNewLabel_7);
        this.causeTextArea = new JTextArea();
        this.panel_7.add(this.causeTextArea);
        this.buttonPanel = new JPanel();
        this.buttonPanel.setAlignmentX(0.0f);
        this.contentPane.add(this.buttonPanel);
        this.buttonPanel.setLayout(new FlowLayout(2, 5, 5));
        this.copyButton = new JButton(Bundle.getMessage("ExceptionDisplayCopyButton"));
        this.copyButton.setEnabled(false);
        this.buttonPanel.add(this.copyButton);
        this.closeButton = new JButton(Bundle.getMessage("ButtonClose"));
        this.closeButton.addActionListener(arg0 -> this.dispose());
        this.buttonPanel.add(this.closeButton);
        this.stackTraceTextArea.setText(this.context.getStackTraceAsString(10));
        this.operationTextArea.setText(this.context.getOperation());
        this.messageTextArea.setText(this.context.getException().getMessage());
        this.hintTextArea.setText(this.context.getHint());
        this.summaryTextArea2.setText(this.context.getSummary());
        this.typeTextArea.setText(this.context.getException().getClass().getName());
        this.toStringTextArea.setText(this.context.getException().toString());
        Throwable cause = this.context.getException().getCause();
        if (cause != null) {
            this.causeTextArea.setText(cause.toString());
        } else {
            this.causeTextArea.setText("null");
        }
        this.pack();
        this.setModal(true);
        this.setLocationRelativeTo(this.getOwner());
    }
}

