/*
 * Decompiled with CFR 0.152.
 */
package jmri.util.swing;

public class ExceptionContext {
    protected Exception _exception;
    protected String _preface = "An error occurred during the following operation.";
    protected String _operation;
    protected String _hint = "No hint";
    protected String _nl = System.getProperty("line.separator");

    public Exception getException() {
        return this._exception;
    }

    public String getPreface() {
        return this._preface;
    }

    public String getOperation() {
        return this._operation;
    }

    public String getHint() {
        return this._hint;
    }

    public String getTitle() {
        return this._exception.getClass().getSimpleName();
    }

    public String getSummary() {
        return String.valueOf(this._preface) + this._nl + this._operation + this._nl + this._exception.getMessage() + this._nl + this._hint;
    }

    public ExceptionContext(Exception ex, String operation, String hint) {
        this._exception = ex;
        this._operation = operation;
        this._hint = hint;
    }

    public String getStackTraceAsString(int maxLevels) {
        String eol = System.getProperty("line.separator");
        StringBuilder sb = new StringBuilder();
        StackTraceElement[] stElements = this._exception.getStackTrace();
        int limit = Math.min(maxLevels, stElements.length);
        int i = 0;
        while (i < limit) {
            sb.append(" at ");
            sb.append(stElements[i].toString());
            sb.append(eol);
            ++i;
        }
        if (stElements.length > limit) {
            sb.append(" plus ");
            sb.append(stElements.length - limit);
            sb.append(" more.");
        }
        return sb.toString();
    }

    public String getStackTraceString() {
        return this.getStackTraceAsString(Integer.MAX_VALUE);
    }
}

