/*
 * Decompiled with CFR 0.152.
 */
package jmri.util.swing;

import java.awt.Desktop;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URI;
import java.util.Arrays;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import jmri.util.FileUtil;
import jmri.util.iharder.dnd.URIDrop;
import jmri.util.swing.Bundle;
import jmri.util.swing.ResizableImagePanel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EditableResizableImagePanel
extends ResizableImagePanel
implements URIDrop.Listener {
    private transient MyMouseAdapter myMouseAdapter = null;
    private String dropFolder;
    private static final Logger log = LoggerFactory.getLogger(EditableResizableImagePanel.class);

    public EditableResizableImagePanel() {
        this.setDnd(true);
    }

    public EditableResizableImagePanel(String imagePath) {
        super(imagePath);
        this.setDnd(true);
    }

    public EditableResizableImagePanel(String imagePath, int w, int h) {
        super(imagePath, w, h);
        this.setDnd(true);
    }

    public final void setDnd(boolean dnd) {
        if (dnd) {
            new URIDrop(this, this);
            if (this.myMouseAdapter == null) {
                this.myMouseAdapter = new MyMouseAdapter(this);
            }
            this.addMouseListener(this.myMouseAdapter);
        } else {
            URIDrop.remove(this);
            if (this.myMouseAdapter != null) {
                this.removeMouseListener(this.myMouseAdapter);
            }
        }
    }

    public JMenuItem addMenuItemBrowseFolder(String menuEntry, String path) {
        if (this.myMouseAdapter == null) {
            return null;
        }
        JMenuItem mi = new JMenuItem(menuEntry);
        mi.addActionListener(e -> {
            try {
                Desktop.getDesktop().open(new File(path));
            }
            catch (IOException ex) {
                log.error("Browse to action " + ex.getMessage());
            }
        });
        this.myMouseAdapter.addMenuItem(mi);
        return mi;
    }

    public void removeMenuItemBrowseFolder(JMenuItem mi) {
        if (this.myMouseAdapter == null) {
            return;
        }
        this.myMouseAdapter.removeMenuItem(mi);
    }

    public void setDropFolder(String s) {
        this.dropFolder = s;
    }

    public String getDropFolder() {
        return this.dropFolder;
    }

    @Override
    public void URIsDropped(URI[] uris) {
        File dest;
        block44: {
            if (uris == null) {
                log.error("URIsDropped: no URI");
                return;
            }
            if (uris.length == 0) {
                log.error("URIsDropped: no URI");
                return;
            }
            if (uris[0].getPath() == null) {
                log.error("URIsDropped: not a valid URI path: ", (Object)uris[0]);
                return;
            }
            File src = new File(uris[0].getPath());
            dest = new File(uris[0].getPath());
            if (this.dropFolder != null) {
                dest = new File(String.valueOf(this.dropFolder) + File.separatorChar + src.getName());
                if (src.getParent().compareTo(dest.getParent()) != 0) {
                    BufferedInputStream in = null;
                    BufferedInputStream out = null;
                    FileOutputStream fileOutputStream = null;
                    try {
                        try {
                            boolean srcIsFile;
                            FileUtil.createDirectory(dest.getParentFile().getPath());
                            if (uris[0].getScheme() != null && (uris[0].getScheme().equals("content") || uris[0].getScheme().equals("file"))) {
                                in = new BufferedInputStream(uris[0].toURL().openStream());
                                srcIsFile = true;
                            } else {
                                HttpURLConnection httpcon = (HttpURLConnection)uris[0].toURL().openConnection();
                                httpcon.addRequestProperty("User-Agent", "Mozilla/4.0");
                                in = new BufferedInputStream(httpcon.getInputStream());
                                srcIsFile = false;
                            }
                            int i = 0;
                            while (dest.exists()) {
                                boolean alreadyThere = false;
                                if (srcIsFile && dest.length() == src.length()) {
                                    int bytesReadIn;
                                    out = new BufferedInputStream(dest.toURI().toURL().openStream());
                                    byte[] dataBufferIn = new byte[4096];
                                    byte[] dataBufferOut = new byte[4096];
                                    alreadyThere = true;
                                    while ((bytesReadIn = in.read(dataBufferIn, 0, 4096)) != -1) {
                                        int bytesReadOut = out.read(dataBufferOut, 0, 4096);
                                        if (bytesReadIn == bytesReadOut && Arrays.equals(dataBufferIn, dataBufferOut)) continue;
                                        alreadyThere = false;
                                        break;
                                    }
                                    out.close();
                                }
                                if (alreadyThere) break;
                                dest = new File(String.valueOf(this.dropFolder) + File.separatorChar + ++i + "-" + src.getName());
                            }
                            if (!dest.exists()) {
                                int bytesRead;
                                fileOutputStream = new FileOutputStream(dest);
                                byte[] dataBuffer = new byte[4096];
                                while ((bytesRead = in.read(dataBuffer, 0, 4096)) != -1) {
                                    fileOutputStream.write(dataBuffer, 0, bytesRead);
                                }
                            }
                        }
                        catch (IOException e) {
                            log.error("URIsDropped: error while copying new file, using original file");
                            log.error("URIsDropped: Error : {}", (Object)e.getMessage());
                            log.error("URIsDropped: URI : {}", (Object)uris[0]);
                            dest = src;
                            try {
                                if (fileOutputStream != null) {
                                    fileOutputStream.close();
                                }
                            }
                            catch (IOException ex) {
                                log.error("URIsDropped: error while closing copy destination file : ", (Object)ex.getMessage());
                            }
                            try {
                                if (in != null) {
                                    in.close();
                                }
                            }
                            catch (IOException ex) {
                                log.error("URIsDropped: error while closing copy source file : ", (Object)ex.getMessage());
                            }
                            try {
                                if (out != null) {
                                    out.close();
                                }
                                break block44;
                            }
                            catch (IOException ex) {
                                log.error("URIsDropped: error while closing duplicate check file : ", (Object)ex.getMessage());
                            }
                            break block44;
                        }
                    }
                    catch (Throwable throwable) {
                        try {
                            if (fileOutputStream != null) {
                                fileOutputStream.close();
                            }
                        }
                        catch (IOException ex) {
                            log.error("URIsDropped: error while closing copy destination file : ", (Object)ex.getMessage());
                        }
                        try {
                            if (in != null) {
                                in.close();
                            }
                        }
                        catch (IOException ex) {
                            log.error("URIsDropped: error while closing copy source file : ", (Object)ex.getMessage());
                        }
                        try {
                            if (out != null) {
                                out.close();
                            }
                        }
                        catch (IOException ex) {
                            log.error("URIsDropped: error while closing duplicate check file : ", (Object)ex.getMessage());
                        }
                        throw throwable;
                    }
                    try {
                        if (fileOutputStream != null) {
                            fileOutputStream.close();
                        }
                    }
                    catch (IOException ex) {
                        log.error("URIsDropped: error while closing copy destination file : ", (Object)ex.getMessage());
                    }
                    try {
                        if (in != null) {
                            in.close();
                        }
                    }
                    catch (IOException ex) {
                        log.error("URIsDropped: error while closing copy source file : ", (Object)ex.getMessage());
                    }
                    try {
                        if (out != null) {
                            out.close();
                        }
                    }
                    catch (IOException ex) {
                        log.error("URIsDropped: error while closing duplicate check file : ", (Object)ex.getMessage());
                    }
                }
            }
        }
        this.setImagePath(dest.getPath());
    }

    private static class MyMouseAdapter
    implements MouseListener {
        private JPopupMenu popUpMenu = new JPopupMenu();
        private final JMenuItem removeMenuItem = new JMenuItem(Bundle.getMessage("Remove"));

        public MyMouseAdapter(ResizableImagePanel resizableImagePanel) {
            this.removeMenuItem.addActionListener(e -> resizableImagePanel.setImagePath(null));
            this.popUpMenu.add(this.removeMenuItem);
        }

        public void addMenuItem(JMenuItem item) {
            if (item != null) {
                this.popUpMenu.add(item);
            }
        }

        public void removeMenuItem(JMenuItem item) {
            if (item != null) {
                this.popUpMenu.remove(item);
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        private void maybeShowPopup(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this.popUpMenu.show(e.getComponent(), e.getX(), e.getY());
            }
        }
    }
}

