/*
 * Decompiled with CFR 0.152.
 */
package jmri.util.swing;

import java.awt.Color;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.colorchooser.AbstractColorChooserPanel;
import jmri.util.swing.Bundle;

public class ComboBoxColorChooserPanel
extends AbstractColorChooserPanel {
    private String[] colorText = new String[]{"Black", "DarkGray", "Gray", "LightGray", "White", "Red", "Pink", "Orange", "Yellow", "Green", "Blue", "Magenta", "Cyan"};
    private Color[] colorCode = new Color[]{Color.black, Color.darkGray, Color.gray, Color.lightGray, Color.white, Color.red, Color.pink, Color.orange, Color.yellow, Color.green, Color.blue, Color.magenta, Color.cyan};
    private int numColors = 13;
    private JComboBox<String> colorCombo = null;

    @Override
    public void updateChooser() {
        Color color = this.getColorFromModel();
        int i = 0;
        while (i < this.numColors) {
            if (color.equals(this.colorCode[i])) {
                this.colorCombo.setSelectedIndex(i);
                return;
            }
            ++i;
        }
    }

    @Override
    protected void buildChooser() {
        this.removeAll();
        this.colorCombo = new JComboBox();
        int i = 0;
        while (i < this.numColors) {
            this.colorCombo.addItem(Bundle.getMessage(this.colorText[i]));
            ++i;
        }
        this.colorCombo.setMaximumRowCount(this.numColors);
        this.colorCombo.addActionListener(e -> {
            int index = this.colorCombo.getSelectedIndex();
            this.getColorSelectionModel().setSelectedColor(this.colorCode[index]);
        });
        this.add(this.colorCombo);
    }

    @Override
    public String getDisplayName() {
        return Bundle.getMessage("ComboBoxColorChooserName");
    }

    @Override
    public Icon getSmallDisplayIcon() {
        return null;
    }

    @Override
    public Icon getLargeDisplayIcon() {
        return null;
    }
}

