/*
 * Decompiled with CFR 0.152.
 */
package jmri.util.swing;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.colorchooser.ColorSelectionModel;
import jmri.util.ColorUtil;
import jmri.util.swing.Bundle;
import jmri.util.swing.JmriColorChooser;

public class ColorListPopupMenu
extends JPopupMenu {
    private static final int ICON_DIMENSION = 20;
    private Color[] colorCode = new Color[]{Color.black, Color.darkGray, Color.gray, Color.lightGray, Color.white, Color.red, Color.pink, Color.orange, Color.yellow, Color.green, Color.blue, Color.magenta, Color.cyan, ColorUtil.BROWN};
    private int numColors = 14;
    private ColorSelectionModel model;

    public ColorListPopupMenu(ColorSelectionModel m) {
        this.model = m;
        this.addRecentColors();
        this.addSeparator();
        this.addStandardColors();
    }

    private void addRecentColors() {
        this.add(new JLabel(Bundle.getMessage("RecentColorLabel")));
        for (Color color : JmriColorChooser.getRecentColors()) {
            this.add(this.createMenuItem(color, false));
        }
    }

    private void addStandardColors() {
        this.add(new JLabel(Bundle.getMessage("StandardColorLabel")));
        int i = 0;
        while (i < this.numColors) {
            this.add(this.createMenuItem(this.colorCode[i], true));
            ++i;
        }
    }

    private JMenuItem createMenuItem(Color swatchColor, boolean isStdColor) {
        BufferedImage image = new BufferedImage(20, 20, 2);
        Graphics g = image.getGraphics();
        g.setColor(new Color(swatchColor.getRed(), swatchColor.getGreen(), swatchColor.getBlue(), swatchColor.getAlpha()));
        g.fillRect(0, 0, 20, 20);
        g.setColor(Color.black);
        g.drawRect(0, 0, 19, 19);
        ImageIcon icon = new ImageIcon(image);
        g.dispose();
        String colorName = "";
        String colorTip = String.format("r=%d, g=%d, b=%d, a=%d", swatchColor.getRed(), swatchColor.getGreen(), swatchColor.getBlue(), swatchColor.getAlpha());
        colorName = isStdColor ? ColorUtil.colorToLocalizedName(swatchColor) : colorTip;
        JMenuItem colorMenuItem = new JMenuItem(colorName, icon);
        if (isStdColor) {
            colorMenuItem.setToolTipText(colorTip);
        }
        colorMenuItem.addActionListener(e -> this.model.setSelectedColor(swatchColor));
        return colorMenuItem;
    }
}

