/*
 * Decompiled with CFR 0.152.
 */
package jmri.util.swing;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JLabel;
import javax.swing.colorchooser.AbstractColorChooserPanel;
import jmri.util.swing.Bundle;

public class ButtonSwatchColorChooserPanel
extends AbstractColorChooserPanel {
    private JLabel swatch = null;
    private JButton setButton = null;
    private static final int ICON_DIMENSION = 20;

    @Override
    public void updateChooser() {
        Color color = this.getColorFromModel();
        BufferedImage image = new BufferedImage(20, 20, 1);
        Graphics g = image.getGraphics();
        g.setColor(color);
        g.fillRect(0, 0, 20, 20);
        g.setColor(Color.black);
        g.drawRect(0, 0, 19, 19);
        ImageIcon icon = new ImageIcon(image);
        g.dispose();
        this.swatch.setIcon(icon);
    }

    @Override
    protected void buildChooser() {
        BufferedImage image = new BufferedImage(20, 20, 1);
        Graphics g = image.getGraphics();
        g.setColor(this.getColorFromModel());
        g.fillRect(0, 0, 20, 20);
        ImageIcon icon = new ImageIcon(image);
        g.dispose();
        this.swatch = new JLabel(icon);
        this.add(this.swatch);
        this.setButton = new JButton(Bundle.getMessage("SetColor"));
        this.setButton.addActionListener(e -> {
            Color desiredColor = JColorChooser.showDialog(this, Bundle.getMessage("SetColor"), this.getColorFromModel());
            if (desiredColor != null) {
                this.getColorSelectionModel().setSelectedColor(desiredColor);
            }
        });
        this.add(this.setButton);
    }

    @Override
    public String getDisplayName() {
        return Bundle.getMessage("ButtonSwatchColorChooserName");
    }

    @Override
    public Icon getSmallDisplayIcon() {
        return null;
    }

    @Override
    public Icon getLargeDisplayIcon() {
        return null;
    }
}

