/*
 * Decompiled with CFR 0.152.
 */
package jmri.util.swing;

import java.awt.FlowLayout;
import javax.annotation.Nonnull;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import jmri.Manager;
import jmri.NamedBean;
import jmri.swing.NamedBeanComboBox;
import jmri.util.swing.JComboBoxUtil;

public class BeanSelectPanel<E extends NamedBean>
extends JPanel {
    E _selection;
    NamedBeanComboBox<E> _beanComboBox;
    NamedBean.DisplayOptions _display;

    public BeanSelectPanel(@Nonnull Manager<E> manager, E selection) {
        this(manager, selection, NamedBean.DisplayOptions.DISPLAYNAME);
    }

    public BeanSelectPanel(@Nonnull Manager<E> manager, E selection, NamedBean.DisplayOptions display) {
        this(manager, selection, display, true);
    }

    public BeanSelectPanel(@Nonnull Manager<E> manager, E selection, NamedBean.DisplayOptions display, boolean maxRows) {
        this._selection = selection;
        this._display = display == null ? NamedBean.DisplayOptions.DISPLAYNAME : display;
        this._beanComboBox = new NamedBeanComboBox<E>(manager, selection, this._display);
        this._beanComboBox.setAllowNull(true);
        if (maxRows) {
            JComboBoxUtil.setupComboBoxMaxRows(this._beanComboBox);
        }
        JPanel bean = new JPanel();
        bean.setLayout(new FlowLayout(1, 5, 0));
        bean.add(this._beanComboBox);
        super.setLayout(new BoxLayout(this, 1));
        super.add(bean);
    }

    public NamedBeanComboBox getBeanCombo() {
        return this._beanComboBox;
    }

    public E getNamedBean() {
        return (E)this._beanComboBox.getSelectedItem();
    }

    public void setDefaultNamedBean(E nBean) {
        this._selection = nBean;
        this._beanComboBox.setSelectedItem(this._selection);
    }

    public boolean isEmpty() {
        return this._beanComboBox.getSelectedIndex() < 1;
    }

    public void dispose() {
        this._beanComboBox.dispose();
    }
}

