/*
 * Decompiled with CFR 0.152.
 */
package jmri.util.startup;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jmri.Disposable;
import jmri.InstanceManager;
import jmri.SystemConnectionMemo;
import jmri.beans.Bean;
import jmri.jmrix.swing.SystemConnectionAction;
import jmri.util.LoggingUtil;
import jmri.util.startup.StartupActionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StartupActionModelUtil
extends Bean
implements Disposable {
    private HashMap<Class<?>, ActionAttributes> actions = null;
    private HashMap<String, Class<?>> overrides = null;
    private ArrayList<String> actionNames = null;
    private final PropertyChangeListener memosListener = this::memoChanged;
    private final PropertyChangeListener actionFactoryListener = this::actionFactoryChanged;
    private static final Logger log = LoggerFactory.getLogger(StartupActionModelUtil.class);

    @Nonnull
    public static StartupActionModelUtil getDefault() {
        return InstanceManager.getOptionalDefault(StartupActionModelUtil.class).orElseGet(() -> InstanceManager.setDefault(StartupActionModelUtil.class, new StartupActionModelUtil()));
    }

    public StartupActionModelUtil() {
        InstanceManager.addPropertyChangeListener(InstanceManager.getListPropertyName(SystemConnectionMemo.class), this.memosListener);
    }

    @CheckForNull
    public String getActionName(@Nonnull Class<?> clazz) {
        this.prepareActionsHashMap();
        ActionAttributes attrs = this.actions.get(clazz);
        return attrs != null ? attrs.name : null;
    }

    @CheckForNull
    public String getActionName(@Nonnull String className) {
        if (!className.isEmpty()) {
            try {
                return this.getActionName(Class.forName(className));
            }
            catch (ClassNotFoundException classNotFoundException) {
                log.error("Did not find class \"{}\"", (Object)className);
            }
        }
        return null;
    }

    public boolean isSystemConnectionAction(@Nonnull Class<?> clazz) {
        this.prepareActionsHashMap();
        if (this.actions.containsKey(clazz)) {
            return this.actions.get(clazz).isSystemConnectionAction;
        }
        return false;
    }

    public boolean isSystemConnectionAction(@Nonnull String className) {
        if (!className.isEmpty()) {
            try {
                return this.isSystemConnectionAction(Class.forName(className));
            }
            catch (ClassNotFoundException classNotFoundException) {
                log.error("Did not find class \"{}\"", (Object)className);
            }
        }
        return false;
    }

    @CheckForNull
    public String getClassName(@CheckForNull String name) {
        if (name != null && !name.isEmpty()) {
            this.prepareActionsHashMap();
            for (Map.Entry<Class<?>, ActionAttributes> entry : this.actions.entrySet()) {
                if (!entry.getValue().name.equals(name)) continue;
                return entry.getKey().getName();
            }
        }
        return null;
    }

    @CheckForNull
    public String[] getNames() {
        this.prepareActionsHashMap();
        if (this.actionNames == null) {
            this.actionNames = new ArrayList();
            this.actions.values().stream().forEach(attrs -> this.actionNames.add(attrs.name));
            this.actionNames.sort(null);
        }
        return this.actionNames.toArray(new String[this.actionNames.size()]);
    }

    @Nonnull
    public Class<?>[] getClasses() {
        this.prepareActionsHashMap();
        return this.actions.keySet().toArray(new Class[this.actions.size()]);
    }

    @Deprecated
    public void addAction(@Nonnull String strClass, @Nonnull String name) throws ClassNotFoundException {
        Class<?> clazz;
        this.prepareActionsHashMap();
        this.actionNames = null;
        try {
            clazz = Class.forName(strClass);
        }
        catch (ClassNotFoundException ex) {
            log.error("Did not find class \"{}\"", (Object)strClass);
            throw ex;
        }
        ActionAttributes attrs = new ActionAttributes(name, clazz);
        this.actions.put(clazz, attrs);
        this.firePropertyChange("length", null, null);
    }

    @Deprecated
    public void removeAction(@Nonnull String strClass) throws ClassNotFoundException {
        Class<?> clazz;
        this.prepareActionsHashMap();
        this.actionNames = null;
        try {
            clazz = Class.forName(strClass);
        }
        catch (ClassNotFoundException ex) {
            log.error("Did not find class \"{}\"", (Object)strClass);
            throw ex;
        }
        this.actions.remove(clazz);
        this.firePropertyChange("length", null, null);
    }

    private void prepareActionsHashMap() {
        if (this.actions == null) {
            this.actions = new HashMap();
            this.overrides = new HashMap();
            ServiceLoader<apps.startup.StartupActionFactory> asLoader = ServiceLoader.load(apps.startup.StartupActionFactory.class);
            asLoader.forEach(factory -> {
                this.addActions((StartupActionFactory)factory);
                LoggingUtil.deprecationWarning(log, factory.getClass().getName());
            });
            asLoader.reload();
            ServiceLoader<StartupActionFactory> jusLoader = ServiceLoader.load(StartupActionFactory.class);
            jusLoader.forEach(factory -> this.addActions((StartupActionFactory)factory));
            jusLoader.reload();
            InstanceManager.getList(SystemConnectionMemo.class).forEach(memo -> this.addActions(memo.getActionFactory()));
            InstanceManager.getList(SystemConnectionMemo.class).forEach(memo -> memo.addPropertyChangeListener("actionFactory", this.actionFactoryListener));
            this.firePropertyChange("length", 0, this.actions.size());
        }
    }

    private void addActions(StartupActionFactory factory) {
        Arrays.stream(factory.getActionClasses()).forEach(clazz -> {
            this.actions.put((Class<?>)clazz, new ActionAttributes(factory.getTitle((Class<?>)clazz), (Class<?>)clazz));
            Arrays.stream(factory.getOverriddenClasses((Class<?>)clazz)).forEach(overridden -> {
                Class clazz2 = this.overrides.put((String)overridden, (Class<?>)clazz);
            });
        });
    }

    private void removeActions(StartupActionFactory factory) {
        Arrays.stream(factory.getActionClasses()).forEach(this.actions::remove);
    }

    @CheckForNull
    public String getOverride(@CheckForNull String name) {
        this.prepareActionsHashMap();
        if (name != null && this.overrides.containsKey(name)) {
            return this.overrides.get(name).getName();
        }
        return null;
    }

    @Override
    public void dispose() {
        InstanceManager.removePropertyChangeListener(InstanceManager.getListPropertyName(SystemConnectionMemo.class), this.memosListener);
    }

    private void memoChanged(PropertyChangeEvent evt) {
        this.prepareActionsHashMap();
        this.actionNames = null;
        int size = this.actions.size();
        Object src = evt.getNewValue();
        if (src instanceof SystemConnectionMemo) {
            SystemConnectionMemo memo = (SystemConnectionMemo)src;
            this.addActions(memo.getActionFactory());
            memo.addPropertyChangeListener("actionFactory", this.actionFactoryListener);
        } else {
            src = evt.getOldValue();
            if (src instanceof SystemConnectionMemo) {
                SystemConnectionMemo memo = (SystemConnectionMemo)src;
                this.removeActions(memo.getActionFactory());
                memo.removePropertyChangeListener("actionFactory", this.actionFactoryListener);
            }
        }
        this.firePropertyChange("length", size, this.actions.size());
    }

    private void actionFactoryChanged(PropertyChangeEvent evt) {
        this.prepareActionsHashMap();
        this.actionNames = null;
        int size = this.actions.size();
        Object value = evt.getOldValue();
        if (value instanceof StartupActionFactory) {
            this.removeActions((StartupActionFactory)value);
        }
        if ((value = evt.getNewValue()) instanceof StartupActionFactory) {
            this.addActions((StartupActionFactory)value);
        }
        this.firePropertyChange("length", size, this.actions.size());
    }

    private static class ActionAttributes {
        final String name;
        final boolean isSystemConnectionAction;

        ActionAttributes(String name, Class<?> clazz) {
            this.name = name;
            this.isSystemConnectionAction = SystemConnectionAction.class.isAssignableFrom(clazz);
        }
    }
}

