/*
 * Decompiled with CFR 0.152.
 */
package jmri.util.startup;

import java.awt.Component;
import java.io.IOException;
import javax.swing.JFileChooser;
import jmri.InstanceManager;
import jmri.util.startup.Bundle;
import jmri.util.startup.StartupActionsManager;
import jmri.util.startup.StartupModel;
import jmri.util.startup.StartupModelFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractFileModelFactory
implements StartupModelFactory {
    private JFileChooser chooser = null;
    private static final Logger log = LoggerFactory.getLogger(AbstractFileModelFactory.class);

    @Override
    public String getDescription() {
        return Bundle.getMessage(this.getModelClass().getCanonicalName());
    }

    protected abstract JFileChooser setFileChooser();

    @Override
    public String getActionText() {
        return Bundle.getMessage("EditableStartupAction", this.getDescription());
    }

    @Override
    public void editModel(StartupModel model, Component parent) {
        if (this.getModelClass().isInstance(model)) {
            if (this.chooser == null) {
                this.chooser = this.setFileChooser();
                this.chooser.setDialogTitle(this.getDescription());
                this.chooser.setDialogType(2);
            }
            if (this.chooser.showOpenDialog(parent) == 0) {
                try {
                    String name = model.getName();
                    if (name == null || !name.equals(this.chooser.getSelectedFile().getCanonicalPath())) {
                        model.setName(this.chooser.getSelectedFile().getCanonicalPath());
                        InstanceManager.getDefault(StartupActionsManager.class).setRestartRequired();
                    }
                }
                catch (IOException iOException) {
                    log.error("File {} does not exist.", (Object)this.chooser.getSelectedFile());
                }
            }
        }
    }

    @Override
    public void initialize() {
    }
}

