/*
 * Decompiled with CFR 0.152.
 */
package jmri.util.startup;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.swing.Action;
import jmri.JmriException;
import jmri.SystemConnectionMemo;
import jmri.jmrix.SystemConnectionMemoManager;
import jmri.jmrix.swing.SystemConnectionAction;
import jmri.util.ConnectionNameFromSystemName;
import jmri.util.ThreadingUtil;
import jmri.util.startup.Bundle;
import jmri.util.startup.StartupActionModelUtil;
import jmri.util.startup.StartupModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractActionModel
implements StartupModel {
    private String systemPrefix = "";
    private String className = "";
    private final List<Exception> exceptions = new ArrayList<Exception>();
    private static final Logger log = LoggerFactory.getLogger(AbstractActionModel.class);

    public String getClassName() {
        return this.className;
    }

    @Override
    public String getName() {
        if (this.className != null) {
            return StartupActionModelUtil.getDefault().getActionName(this.className);
        }
        return null;
    }

    @Override
    public void setName(String n) {
        log.debug("setName(\"{}\")", (Object)n);
        this.className = StartupActionModelUtil.getDefault().getClassName(n);
    }

    public void setClassName(@Nonnull String n) {
        log.debug("setClassName(\"{}\")", (Object)n);
        Objects.requireNonNull(n, "Class name cannot be null");
        this.className = n;
    }

    @Nonnull
    public String getSystemPrefix() {
        return this.systemPrefix;
    }

    public void setSystemPrefix(@CheckForNull String prefix) {
        this.systemPrefix = prefix == null ? "" : prefix;
    }

    public boolean isSystemConnectionAction() {
        String name = this.getClassName();
        if (name != null) {
            return StartupActionModelUtil.getDefault().isSystemConnectionAction(name);
        }
        return false;
    }

    @Override
    public boolean isValid() {
        if (this.className != null && !this.className.isEmpty()) {
            try {
                Class.forName(this.className);
                if (this.isSystemConnectionAction()) {
                    return SystemConnectionMemoManager.getDefault().getSystemConnectionMemoForSystemPrefix(this.systemPrefix) != null;
                }
                return true;
            }
            catch (ClassNotFoundException classNotFoundException) {
                return false;
            }
        }
        return false;
    }

    public String toString() {
        String name = this.getName();
        if (name != null) {
            if (!this.systemPrefix.isEmpty()) {
                return Bundle.getMessage("AbstractActionModel.ToolTip", name, ConnectionNameFromSystemName.getConnectionName(this.systemPrefix));
            }
            return name;
        }
        if (this.className != null && this.isValid()) {
            return Bundle.getMessage("AbstractActionModel.UnknownClass", this.className);
        }
        if (this.className != null && !this.className.isEmpty()) {
            return Bundle.getMessage("AbstractActionModel.InvalidClass", this.className);
        }
        return Bundle.getMessage("AbstractActionModel.InvalidAction", super.toString());
    }

    @Override
    public void performAction() throws JmriException {
        log.debug("Invoke Action from {}", (Object)this.className);
        try {
            Action action = (Action)Class.forName(this.className).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            if (SystemConnectionAction.class.isAssignableFrom(action.getClass())) {
                SystemConnectionMemo memo = ConnectionNameFromSystemName.getSystemConnectionMemoFromSystemPrefix(this.getSystemPrefix());
                if (memo != null) {
                    ((SystemConnectionAction)((Object)action)).setSystemConnectionMemo(memo);
                } else {
                    log.warn("Connection \"{}\" does not exist and cannot be assigned to action {}\nThis warning can be silenced by configuring the connection associated with the startup action.", (Object)this.getSystemPrefix(), (Object)this.className);
                }
            }
            ThreadingUtil.runOnLayout(() -> {
                try {
                    this.performAction(action);
                }
                catch (JmriException ex) {
                    log.error("Error while performing startup action for class: {}", (Object)this.className, (Object)ex);
                }
            });
        }
        catch (ClassNotFoundException classNotFoundException) {
            log.error("Could not find specified class: {}", (Object)this.className);
        }
        catch (IllegalAccessException ex) {
            log.error("Unexpected access exception for class: {}", (Object)this.className, (Object)ex);
            throw new JmriException(ex);
        }
        catch (InstantiationException ex) {
            log.error("Could not instantiate specified class: {}", (Object)this.className, (Object)ex);
            throw new JmriException(ex);
        }
        catch (InvocationTargetException ex) {
            log.error("Error while invoking startup action for class: {}", (Object)this.className, (Object)ex);
            throw new JmriException(ex);
        }
        catch (NoSuchMethodException ex) {
            log.error("Could not locate specified method: {}", (Object)this.className, (Object)ex);
            throw new JmriException(ex);
        }
        catch (Exception ex) {
            log.error("Error while performing startup action for class: {}", (Object)this.className, (Object)ex);
            throw new JmriException(ex);
        }
    }

    @Override
    public List<Exception> getExceptions() {
        return new ArrayList<Exception>(this.exceptions);
    }

    @Override
    public void addException(Exception exception) {
        this.exceptions.add(exception);
    }

    protected abstract void performAction(Action var1) throws JmriException;
}

