/*
 * Decompiled with CFR 0.152.
 */
package jmri.util.prefs;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import jmri.profile.AuxiliaryConfiguration;
import jmri.util.FileUtil;
import jmri.util.xml.XMLUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public abstract class JmriConfiguration
implements AuxiliaryConfiguration {
    private static final Logger log = LoggerFactory.getLogger(JmriConfiguration.class);

    JmriConfiguration() {
    }

    protected abstract File getConfigurationFile(boolean var1);

    protected abstract boolean isSharedBackedUp();

    protected abstract void setSharedBackedUp(boolean var1);

    protected abstract boolean isPrivateBackedUp();

    protected abstract void setPrivateBackedUp(boolean var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Element getConfigurationFragment(String elementName, String namespace, boolean shared) {
        JmriConfiguration jmriConfiguration = this;
        synchronized (jmriConfiguration) {
            File file = this.getConfigurationFile(shared);
            if (file != null && file.canRead()) {
                try {
                    Throwable throwable = null;
                    Object var7_9 = null;
                    try (FileInputStream is = new FileInputStream(file);){
                        InputSource input = new InputSource(is);
                        input.setSystemId(file.toURI().toURL().toString());
                        Element root = XMLUtil.parse(input, false, true, null, null).getDocumentElement();
                        return XMLUtil.findElement(root, elementName, namespace);
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (IOException | IllegalArgumentException | SAXException ex) {
                    log.warn("Cannot parse {}", (Object)file, (Object)ex);
                }
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putConfigurationFragment(Element fragment, boolean shared) throws IllegalArgumentException {
        JmriConfiguration jmriConfiguration = this;
        synchronized (jmriConfiguration) {
            Element root;
            Element oldFragment;
            String elementName = fragment.getLocalName();
            String namespace = fragment.getNamespaceURI();
            if (namespace == null) {
                throw new IllegalArgumentException();
            }
            File file = this.getConfigurationFile(shared);
            Document doc = null;
            if (file != null && file.canRead()) {
                try {
                    Throwable throwable = null;
                    Object var9_11 = null;
                    try (FileInputStream is = new FileInputStream(file);){
                        InputSource input = new InputSource(is);
                        input.setSystemId(file.toURI().toURL().toString());
                        doc = XMLUtil.parse(input, false, true, null, null);
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (IOException | SAXException ex) {
                    log.warn("Cannot parse {}", (Object)file, (Object)ex);
                }
            }
            if (doc == null) {
                doc = XMLUtil.createDocument("auxiliary-configuration", "http://www.netbeans.org/ns/auxiliary-configuration/1", null, null);
            }
            if ((oldFragment = XMLUtil.findElement(root = doc.getDocumentElement(), elementName, namespace)) != null) {
                root.removeChild(oldFragment);
            }
            Node ref = null;
            NodeList list = root.getChildNodes();
            int i2 = 0;
            while (i2 < list.getLength()) {
                Node node = list.item(i2);
                if (node.getNodeType() == 1) {
                    int comparison = node.getNodeName().compareTo(elementName);
                    if (comparison == 0) {
                        comparison = node.getNamespaceURI().compareTo(namespace);
                    }
                    if (comparison > 0) {
                        ref = node;
                        break;
                    }
                }
                ++i2;
            }
            root.insertBefore(root.getOwnerDocument().importNode(fragment, true), ref);
            try {
                this.backup(shared);
                Throwable i2 = null;
                Object var13_19 = null;
                try (FileOutputStream os = new FileOutputStream(file);){
                    XMLUtil.write(doc, os, StandardCharsets.UTF_8.name());
                }
                catch (Throwable throwable) {
                    if (i2 == null) {
                        i2 = throwable;
                    } else if (i2 != throwable) {
                        i2.addSuppressed(throwable);
                    }
                    throw i2;
                }
            }
            catch (IOException ex) {
                log.error("Cannot write {}", (Object)file, (Object)ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean removeConfigurationFragment(String elementName, String namespace, boolean shared) throws IllegalArgumentException {
        JmriConfiguration jmriConfiguration = this;
        synchronized (jmriConfiguration) {
            File file = this.getConfigurationFile(shared);
            if (!file.canWrite()) return false;
            try {
                block21: {
                    Document doc;
                    Throwable throwable = null;
                    Object var8_8 = null;
                    try (FileInputStream is = new FileInputStream(file);){
                        InputSource input = new InputSource(is);
                        input.setSystemId(file.toURI().toURL().toString());
                        doc = XMLUtil.parse(input, false, true, null, null);
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                            throw throwable;
                        }
                        if (throwable == throwable2) throw throwable;
                        throwable.addSuppressed(throwable2);
                        throw throwable;
                    }
                    Element root = doc.getDocumentElement();
                    Element toRemove = XMLUtil.findElement(root, elementName, namespace);
                    if (toRemove == null) return false;
                    root.removeChild(toRemove);
                    this.backup(shared);
                    if (root.getElementsByTagName("*").getLength() > 0) {
                        Throwable throwable3 = null;
                        Object var10_12 = null;
                        try (FileOutputStream os = new FileOutputStream(file);){
                            XMLUtil.write(doc, os, StandardCharsets.UTF_8.name());
                            break block21;
                        }
                        catch (Throwable throwable4) {
                            if (throwable3 == null) {
                                throwable3 = throwable4;
                                throw throwable3;
                            }
                            if (throwable3 == throwable4) throw throwable3;
                            throwable3.addSuppressed(throwable4);
                            throw throwable3;
                        }
                    }
                    if (file.delete()) return true;
                    log.debug("Unable to delete {}", (Object)file);
                }
                return true;
            }
            catch (IOException | DOMException | SAXException ex) {
                log.error("Cannot remove {} from {}", new Object[]{elementName, file, ex});
            }
            return false;
        }
    }

    private void backup(boolean shared) {
        File file = this.getConfigurationFile(shared);
        if ((shared ? !this.isSharedBackedUp() : !this.isPrivateBackedUp()) && file.exists()) {
            log.debug("Backing up {}", (Object)file);
            try {
                FileUtil.backup(file);
                if (shared) {
                    this.setSharedBackedUp(true);
                } else {
                    this.setPrivateBackedUp(true);
                }
            }
            catch (IOException ex) {
                log.error("Error backing up {}", (Object)file, (Object)ex);
            }
        }
    }
}

