/*
 * Decompiled with CFR 0.152.
 */
package jmri.util.prefs;

import java.io.File;
import java.io.IOException;
import jmri.profile.AuxiliaryConfiguration;
import jmri.profile.Profile;
import jmri.profile.ProfileUtils;
import jmri.util.FileUtil;
import jmri.util.node.NodeIdentity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractConfigurationProvider {
    protected final Profile project;
    private boolean privateBackedUp = false;
    private boolean sharedBackedUp = false;
    private static final Logger log = LoggerFactory.getLogger(AbstractConfigurationProvider.class);

    public AbstractConfigurationProvider(Profile project) {
        this.project = project;
    }

    protected abstract AuxiliaryConfiguration getConfiguration();

    protected abstract File getConfigurationFile(boolean var1);

    public File getConfigurationDirectory(boolean shared) {
        File dir;
        if (this.project == null) {
            dir = new File(FileUtil.getPreferencesPath(), "preferences");
        } else {
            dir = new File(this.project.getPath(), "profile");
            if (!shared) {
                File nodeDir = new File(dir, NodeIdentity.storageIdentity());
                if (!nodeDir.exists()) {
                    try {
                        if (!ProfileUtils.copyPrivateContentToCurrentIdentity(this.project)) {
                            log.debug("Starting profile with new private configuration.");
                        }
                    }
                    catch (IOException iOException) {
                        log.debug("Copying existing private configuration failed.");
                    }
                }
                dir = new File(dir, NodeIdentity.storageIdentity());
            }
        }
        FileUtil.createDirectory(dir);
        return dir;
    }

    protected boolean isPrivateBackedUp() {
        return this.privateBackedUp;
    }

    protected void setPrivateBackedUp(boolean privateBackedUp) {
        this.privateBackedUp = privateBackedUp;
    }

    protected boolean isSharedBackedUp() {
        return this.sharedBackedUp;
    }

    protected void setSharedBackedUp(boolean sharedBackedUp) {
        this.sharedBackedUp = sharedBackedUp;
    }
}

