/*
 * Decompiled with CFR 0.152.
 */
package jmri.util.node;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import jmri.profile.Profile;
import jmri.profile.ProfileManager;
import jmri.util.FileUtil;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeIdentity {
    private final Set<String> formerIdentities = new HashSet<String>();
    private UUID uuid = null;
    private String networkIdentity = null;
    private String storageIdentity = null;
    private final Map<Profile, String> profileStorageIdentities = new HashMap<Profile, String>();
    private static NodeIdentity instance = null;
    private static final Logger log = LoggerFactory.getLogger(NodeIdentity.class);
    private static final String ROOT_ELEMENT = "nodeIdentityConfig";
    private static final String UUID_ELEMENT = "uuid";
    private static final String NODE_IDENTITY = "nodeIdentity";
    private static final String STORAGE_IDENTITY = "storageIdentity";
    private static final String FORMER_IDENTITIES = "formerIdentities";
    private static final String IDENTITY_PREFIX = "jmri-";
    protected static final String URL_SAFE_CHARACTERS = "abcdefghijklmnopqrstuvwxyz_ABCDEFGHIJKLMNOPQRSTUVWXYZ-0123456789";

    private NodeIdentity() {
        this.init();
    }

    private synchronized void init() {
        File identityFile = this.identityFile();
        if (identityFile.exists()) {
            try {
                Element si;
                boolean save = false;
                this.formerIdentities.clear();
                Document doc = new SAXBuilder().build(identityFile);
                Element ue = doc.getRootElement().getChild(UUID_ELEMENT);
                if (ue != null) {
                    try {
                        String attr = ue.getAttributeValue(UUID_ELEMENT);
                        this.uuid = NodeIdentity.uuidFromCompactString(attr);
                        this.storageIdentity = this.uuid.toString();
                        this.formerIdentities.add(this.storageIdentity);
                        this.formerIdentities.add(IDENTITY_PREFIX + attr);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {}
                }
                if ((si = doc.getRootElement().getChild(STORAGE_IDENTITY)) != null) {
                    try {
                        this.storageIdentity = si.getAttributeValue(STORAGE_IDENTITY);
                        if (this.uuid == null || !this.storageIdentity.equals(this.uuid.toString())) {
                            this.uuid = UUID.fromString(this.storageIdentity);
                            save = true;
                        }
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        save = true;
                    }
                } else {
                    save = true;
                }
                if (this.storageIdentity == null) {
                    save = true;
                    this.getStorageIdentity(false);
                }
                String id = null;
                try {
                    id = doc.getRootElement().getChild(NODE_IDENTITY).getAttributeValue(NODE_IDENTITY);
                    doc.getRootElement().getChild(FORMER_IDENTITIES).getChildren().stream().forEach(e -> {
                        boolean bl = this.formerIdentities.add(e.getAttributeValue(NODE_IDENTITY));
                    });
                }
                catch (NullPointerException nullPointerException) {}
                if (!this.validateNetworkIdentity(id)) {
                    log.warn("Node identity {} is invalid. Generating new node identity.", (Object)id);
                    save = true;
                    this.getNetworkIdentity(false);
                } else {
                    this.networkIdentity = id;
                }
                if (save) {
                    this.saveIdentity();
                }
            }
            catch (IOException | JDOMException ex) {
                log.error("Unable to read node identities: {}", (Object)ex.getLocalizedMessage());
                this.getNetworkIdentity(true);
            }
        } else {
            this.getNetworkIdentity(true);
        }
    }

    public static synchronized String networkIdentity() {
        String uniqueId = "";
        Profile profile = ProfileManager.getDefault().getActiveProfile();
        if (profile != null) {
            uniqueId = "-" + profile.getUniqueId();
        }
        if (instance == null) {
            instance = new NodeIdentity();
            log.info("Using {}{} as the JMRI Node identity", (Object)instance.getNetworkIdentity(), (Object)uniqueId);
        }
        return String.valueOf(instance.getNetworkIdentity()) + uniqueId;
    }

    public static synchronized String storageIdentity() {
        return NodeIdentity.storageIdentity(ProfileManager.getDefault().getActiveProfile());
    }

    public static synchronized String storageIdentity(Profile profile) {
        if (instance == null) {
            instance = new NodeIdentity();
        }
        String id = instance.getStorageIdentity();
        if (profile != null) {
            if (!NodeIdentity.instance.profileStorageIdentities.containsKey(profile)) {
                String oldId = IDENTITY_PREFIX + NodeIdentity.uuidToCompactString(NodeIdentity.instance.uuid) + "-" + profile.getUniqueId();
                File local = new File(new File(profile.getPath(), "profile"), oldId);
                if (local.exists() && local.isDirectory()) {
                    id = oldId;
                }
                NodeIdentity.instance.profileStorageIdentities.put(profile, id);
                log.info("Using {} as the JMRI storage identity for profile id {}", (Object)id, (Object)profile.getUniqueId());
            }
            id = NodeIdentity.instance.profileStorageIdentities.get(profile);
        }
        return id;
    }

    public static synchronized List<String> formerIdentities() {
        if (instance == null) {
            instance = new NodeIdentity();
            log.info("Using {} as the JMRI Node identity", (Object)instance.getNetworkIdentity());
        }
        return instance.getFormerIdentities();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private synchronized boolean validateNetworkIdentity(String identity) {
        try {
            String nicIdentity;
            NetworkInterface nic;
            Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
            do {
                if (enumeration.hasMoreElements()) continue;
                return false;
            } while ((nic = enumeration.nextElement()).isVirtual() || nic.isLoopback() || (nicIdentity = this.createNetworkIdentity(nic.getHardwareAddress())) == null || !nicIdentity.equals(identity));
            return true;
        }
        catch (SocketException ex) {
            log.error("Error accessing interface", (Throwable)ex);
        }
        return false;
    }

    private synchronized void getNetworkIdentity(boolean save) {
        block8: {
            try {
                NetworkInterface.getByInetAddress(InetAddress.getLocalHost());
                try {
                    this.networkIdentity = this.createNetworkIdentity(NetworkInterface.getByInetAddress(InetAddress.getLocalHost()).getHardwareAddress());
                }
                catch (NullPointerException nullPointerException) {
                    this.networkIdentity = null;
                }
                if (this.networkIdentity != null) break block8;
                Enumeration<NetworkInterface> nics = NetworkInterface.getNetworkInterfaces();
                while (nics.hasMoreElements()) {
                    NetworkInterface nic = nics.nextElement();
                    if (nic.isLoopback() || nic.isVirtual() || nic.getHardwareAddress() == null) continue;
                    this.networkIdentity = this.createNetworkIdentity(nic.getHardwareAddress());
                    if (this.networkIdentity == null) {
                        continue;
                    }
                    break;
                }
            }
            catch (SocketException | UnknownHostException iOException) {
                this.networkIdentity = null;
            }
        }
        if (this.networkIdentity == null) {
            log.info("No MAC addresses found, generating a random multicast MAC address as per RFC 4122.");
            byte[] randBytes = new byte[6];
            ThreadLocalRandom.current().nextBytes(randBytes);
            randBytes[0] = (byte)(randBytes[0] | 1);
            this.networkIdentity = this.createNetworkIdentity(randBytes);
        }
        this.formerIdentities.add(this.networkIdentity);
        if (save) {
            this.saveIdentity();
        }
    }

    private synchronized void getStorageIdentity(boolean save) {
        if (this.storageIdentity == null) {
            if (this.uuid == null) {
                this.uuid = UUID.randomUUID();
            }
            this.storageIdentity = this.uuid.toString();
            this.formerIdentities.add(this.storageIdentity);
        }
        if (save) {
            this.saveIdentity();
        }
    }

    private void saveIdentity() {
        Document doc = new Document();
        doc.setRootElement(new Element(ROOT_ELEMENT));
        Element networkIdentityElement = new Element(NODE_IDENTITY);
        Element storageIdentityElement = new Element(STORAGE_IDENTITY);
        Element formerIdentitiesElement = new Element(FORMER_IDENTITIES);
        Element uuidElement = new Element(UUID_ELEMENT);
        if (this.networkIdentity == null) {
            this.getNetworkIdentity(false);
        }
        if (this.storageIdentity == null) {
            this.getStorageIdentity(false);
        }
        this.formerIdentities.add(this.networkIdentity);
        this.formerIdentities.add(this.storageIdentity);
        if (this.uuid != null) {
            this.formerIdentities.add(IDENTITY_PREFIX + NodeIdentity.uuidToCompactString(this.uuid));
        }
        networkIdentityElement.setAttribute(NODE_IDENTITY, this.networkIdentity);
        storageIdentityElement.setAttribute(STORAGE_IDENTITY, this.storageIdentity);
        this.formerIdentities.stream().forEach(formerIdentity -> {
            log.debug("Retaining former node identity {}", formerIdentity);
            Element e = new Element(NODE_IDENTITY);
            e.setAttribute(NODE_IDENTITY, formerIdentity);
            formerIdentitiesElement.addContent((Content)e);
        });
        doc.getRootElement().addContent((Content)networkIdentityElement);
        doc.getRootElement().addContent((Content)storageIdentityElement);
        if (this.uuid != null) {
            uuidElement.setAttribute(UUID_ELEMENT, NodeIdentity.uuidToCompactString(this.uuid));
            doc.getRootElement().addContent((Content)uuidElement);
        }
        doc.getRootElement().addContent((Content)formerIdentitiesElement);
        try {
            Throwable throwable = null;
            Object var7_9 = null;
            try (OutputStreamWriter w = new OutputStreamWriter((OutputStream)new FileOutputStream(this.identityFile()), StandardCharsets.UTF_8);){
                XMLOutputter fmt = new XMLOutputter();
                fmt.setFormat(Format.getPrettyFormat().setLineSeparator(System.getProperty("line.separator")).setTextMode(Format.TextMode.PRESERVE));
                fmt.output(doc, (Writer)w);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException ex) {
            log.error("Unable to store node identities: {}", (Object)ex.getLocalizedMessage());
        }
    }

    private String createNetworkIdentity(byte[] mac) {
        StringBuilder sb = new StringBuilder(IDENTITY_PREFIX);
        try {
            int i = 0;
            while (i < mac.length) {
                sb.append(String.format("%02X", mac[i]));
                ++i;
            }
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
        return sb.toString();
    }

    private File identityFile() {
        return new File(String.valueOf(FileUtil.getPreferencesPath()) + "nodeIdentity.xml");
    }

    private synchronized String getNetworkIdentity() {
        if (this.networkIdentity == null) {
            this.getNetworkIdentity(false);
        }
        return this.networkIdentity;
    }

    private synchronized String getStorageIdentity() {
        if (this.storageIdentity == null) {
            this.getStorageIdentity(false);
        }
        return this.storageIdentity;
    }

    protected static String uuidToCompactString(UUID uuid) {
        char[] c = new char[22];
        long buffer = 0L;
        StringBuilder sb = new StringBuilder();
        int i = 1;
        while (i <= 22) {
            switch (i) {
                case 1: {
                    buffer = uuid.getLeastSignificantBits();
                    break;
                }
                case 12: {
                    buffer = uuid.getMostSignificantBits();
                    break;
                }
            }
            int val6 = (int)(buffer & 0x3FL);
            c[22 - i] = URL_SAFE_CHARACTERS.charAt(val6);
            buffer >>>= 6;
            ++i;
        }
        return sb.append(c).toString();
    }

    protected static UUID uuidFromCompactString(String compact) {
        long mostSigBits = 0L;
        long leastSigBits = 0L;
        long buffer = 0L;
        int i = 0;
        while (i <= 21) {
            switch (i) {
                case 0: {
                    buffer = 0L;
                    break;
                }
                case 11: {
                    mostSigBits = buffer;
                    buffer = 0L;
                    break;
                }
                default: {
                    buffer <<= 6;
                }
            }
            int val6 = URL_SAFE_CHARACTERS.indexOf(compact.charAt(i));
            buffer |= (long)(val6 & 0x3F);
            ++i;
        }
        leastSigBits = buffer;
        return new UUID(mostSigBits, leastSigBits);
    }

    public List<String> getFormerIdentities() {
        return new ArrayList<String>(this.formerIdentities);
    }
}

