/*
 * Decompiled with CFR 0.152.
 */
package jmri.util.iharder.dnd;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Reader;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.TooManyListenersException;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.border.Border;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class URIDrop {
    private transient Border normalBorder;
    private transient DropTargetListener dropListener;
    private static Color defaultBorderColor = new Color(0.0f, 0.0f, 1.0f, 0.25f);
    private static String ZERO_CHAR_STRING = "\u0000";
    private static final Logger log = LoggerFactory.getLogger(URIDrop.class);

    public URIDrop(Component c, Listener listener) {
        this(null, c, BorderFactory.createMatteBorder(2, 2, 2, 2, defaultBorderColor), true, listener);
    }

    public URIDrop(Component c, boolean recursive, Listener listener) {
        this(null, c, BorderFactory.createMatteBorder(2, 2, 2, 2, defaultBorderColor), recursive, listener);
    }

    public URIDrop(PrintStream out, Component c, boolean recursive, Listener listener) {
        this(out, c, BorderFactory.createMatteBorder(2, 2, 2, 2, defaultBorderColor), recursive, listener);
    }

    public URIDrop(Component c, Border dragBorder, Listener listener) {
        this(null, c, dragBorder, false, listener);
    }

    public URIDrop(Component c, Border dragBorder, boolean recursive, Listener listener) {
        this(null, c, dragBorder, recursive, listener);
    }

    public URIDrop(PrintStream out, Component c, Border dragBorder, Listener listener) {
        this(out, c, dragBorder, false, listener);
    }

    public URIDrop(PrintStream out, final Component c, final Border dragBorder, boolean recursive, final Listener listener) {
        this.dropListener = new DropTargetListener(){

            @Override
            public void dragEnter(DropTargetDragEvent evt) {
                log.debug("URIDrop: dragEnter event.");
                if (URIDrop.this.isDragOk(evt)) {
                    if (c instanceof JComponent) {
                        JComponent jc = (JComponent)c;
                        URIDrop.this.normalBorder = jc.getBorder();
                        log.debug("URIDrop: normal border saved.");
                        jc.setBorder(dragBorder);
                        log.debug("URIDrop: drag border set.");
                    }
                    evt.acceptDrag(1);
                    log.debug("URIDrop: event accepted.");
                } else {
                    evt.rejectDrag();
                    log.debug("URIDrop: event rejected.");
                }
            }

            @Override
            public void dragOver(DropTargetDragEvent evt) {
            }

            @Override
            public void drop(DropTargetDropEvent evt) {
                log.debug("URIDrop: drop event.");
                try {
                    try {
                        Transferable tr = evt.getTransferable();
                        boolean handled = false;
                        if (!handled && tr.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                            evt.acceptDrop(1);
                            log.debug("FileDrop: file list accepted.");
                            List fileList = (List)tr.getTransferData(DataFlavor.javaFileListFlavor);
                            if (listener != null) {
                                listener.URIsDropped(URIDrop.createURIArray(fileList));
                            }
                            evt.getDropTargetContext().dropComplete(true);
                            handled = true;
                            log.debug("FileDrop: drop complete as files.");
                        }
                        if (!handled && tr.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                            evt.acceptDrop(1);
                            log.debug("URIDrop: string accepted.");
                            String uristr = (String)tr.getTransferData(DataFlavor.stringFlavor);
                            if (listener != null) {
                                listener.URIsDropped(URIDrop.createURIArray(uristr));
                            }
                            evt.getDropTargetContext().dropComplete(true);
                            handled = true;
                            log.debug("URIDrop: drop complete as URIs.");
                        }
                        if (!handled) {
                            DataFlavor[] flavors;
                            DataFlavor[] dataFlavorArray = flavors = tr.getTransferDataFlavors();
                            int n = flavors.length;
                            int n2 = 0;
                            while (n2 < n) {
                                DataFlavor flavor = dataFlavorArray[n2];
                                if (flavor.isRepresentationClassReader()) {
                                    evt.acceptDrop(1);
                                    log.debug("URIDrop: reader accepted.");
                                    Reader reader = flavor.getReaderForText(tr);
                                    BufferedReader br = new BufferedReader(reader);
                                    if (listener != null) {
                                        listener.URIsDropped(URIDrop.createURIArray(br));
                                    }
                                    evt.getDropTargetContext().dropComplete(true);
                                    log.debug("URIDrop: drop complete as ", (Object)flavor.getHumanPresentableName());
                                    handled = true;
                                    break;
                                }
                                ++n2;
                            }
                        }
                        if (!handled) {
                            log.debug("URIDrop: not droppable.");
                            evt.rejectDrop();
                        }
                    }
                    catch (IOException io) {
                        log.error("URIDrop: IOException - abort:", (Throwable)io);
                        evt.rejectDrop();
                        if (c instanceof JComponent) {
                            JComponent jc = (JComponent)c;
                            jc.setBorder(URIDrop.this.normalBorder);
                            log.debug("URIDrop: normal border restored.");
                        }
                    }
                    catch (UnsupportedFlavorException ufe) {
                        log.error("URIDrop: UnsupportedFlavorException - abort:", (Throwable)ufe);
                        evt.rejectDrop();
                        if (c instanceof JComponent) {
                            JComponent jc = (JComponent)c;
                            jc.setBorder(URIDrop.this.normalBorder);
                            log.debug("URIDrop: normal border restored.");
                        }
                    }
                }
                finally {
                    if (c instanceof JComponent) {
                        JComponent jc = (JComponent)c;
                        jc.setBorder(URIDrop.this.normalBorder);
                        log.debug("URIDrop: normal border restored.");
                    }
                }
            }

            @Override
            public void dragExit(DropTargetEvent evt) {
                log.debug("URIDrop: dragExit event.");
                if (c instanceof JComponent) {
                    JComponent jc = (JComponent)c;
                    jc.setBorder(URIDrop.this.normalBorder);
                    log.debug("URIDrop: normal border restored.");
                }
            }

            @Override
            public void dropActionChanged(DropTargetDragEvent evt) {
                log.debug("URIDrop: dropActionChanged event.");
                if (URIDrop.this.isDragOk(evt)) {
                    evt.acceptDrag(1);
                    log.debug("URIDrop: event accepted.");
                } else {
                    evt.rejectDrag();
                    log.debug("URIDrop: event rejected.");
                }
            }
        };
        this.makeDropTarget(c, recursive);
    }

    private static URI[] createURIArray(BufferedReader bReader) {
        try {
            String line;
            ArrayList<URI> list = new ArrayList<URI>();
            while ((line = bReader.readLine()) != null) {
                try {
                    if (ZERO_CHAR_STRING.equals(line)) continue;
                    URI uri = new URI(line);
                    list.add(uri);
                }
                catch (URISyntaxException uRISyntaxException) {
                    log.error("URIDrop: URISyntaxException");
                    log.debug("URIDrop: line for URI : ", (Object)line);
                }
            }
            return list.toArray(new URI[list.size()]);
        }
        catch (IOException iOException) {
            log.debug("URIDrop: IOException");
            return new URI[0];
        }
    }

    private static URI[] createURIArray(String str) {
        String[] lines;
        ArrayList<URI> list = new ArrayList<URI>();
        String[] stringArray = lines = str.split("(\\r|\\n)");
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            if (!ZERO_CHAR_STRING.equals(line)) {
                try {
                    URI uri = new URI(line);
                    list.add(uri);
                }
                catch (URISyntaxException uRISyntaxException) {
                    log.error("URIDrop: URISyntaxException");
                }
            }
            ++n2;
        }
        return list.toArray(new URI[list.size()]);
    }

    private static URI[] createURIArray(List<File> fileList) {
        ArrayList list = new ArrayList();
        fileList.forEach(f -> list.add(f.toURI()));
        return list.toArray(new URI[list.size()]);
    }

    private void makeDropTarget(Component c, boolean recursive) {
        DropTarget dt = new DropTarget();
        try {
            dt.addDropTargetListener(this.dropListener);
        }
        catch (TooManyListenersException e) {
            log.error("URIDrop: Drop will not work due to previous error. Do you have another listener attached?", (Throwable)e);
        }
        c.addHierarchyListener(evt -> {
            log.debug("URIDrop: Hierarchy changed.");
            Container parent = c.getParent();
            if (parent == null) {
                c.setDropTarget(null);
                log.debug("URIDrop: Drop target cleared from component.");
            } else {
                new DropTarget(c, this.dropListener);
                log.debug("URIDrop: Drop target added to component.");
            }
        });
        if (c.getParent() != null) {
            new DropTarget(c, this.dropListener);
        }
        if (recursive && c instanceof Container) {
            Component[] comps;
            Container cont = (Container)c;
            Component[] componentArray = comps = cont.getComponents();
            int n = comps.length;
            int n2 = 0;
            while (n2 < n) {
                Component comp = componentArray[n2];
                this.makeDropTarget(comp, recursive);
                ++n2;
            }
        }
    }

    private boolean isDragOk(DropTargetDragEvent evt) {
        boolean ok = false;
        DataFlavor[] flavors = evt.getCurrentDataFlavors();
        int i = 0;
        while (!ok && i < flavors.length) {
            DataFlavor curFlavor = flavors[i];
            if (curFlavor.equals(DataFlavor.javaFileListFlavor) || curFlavor.isRepresentationClassReader()) {
                ok = true;
            }
            ++i;
        }
        if (log.isDebugEnabled()) {
            if (flavors.length == 0) {
                log.debug("URIDrop: no data flavors.");
            }
            i = 0;
            while (i < flavors.length) {
                log.debug(flavors[i].toString());
                ++i;
            }
        }
        return ok;
    }

    public static boolean remove(Component c) {
        return URIDrop.remove(c, true);
    }

    public static boolean remove(Component c, boolean recursive) {
        log.debug("URIDrop: Removing drag-and-drop hooks.");
        c.setDropTarget(null);
        if (recursive && c instanceof Container) {
            Component[] comps;
            Component[] componentArray = comps = ((Container)c).getComponents();
            int n = comps.length;
            int n2 = 0;
            while (n2 < n) {
                Component comp = componentArray[n2];
                URIDrop.remove(comp, recursive);
                ++n2;
            }
            return true;
        }
        return false;
    }

    public static interface Listener {
        public void URIsDropped(URI[] var1);
    }
}

