/*
 * Decompiled with CFR 0.152.
 */
package jmri.util.exceptionhandler;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.awt.GraphicsEnvironment;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.swing.JOptionPane;
import jmri.util.exceptionhandler.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UncaughtExceptionHandler
implements Thread.UncaughtExceptionHandler {
    private static final Logger log = LoggerFactory.getLogger(UncaughtExceptionHandler.class);

    @Override
    @SuppressFBWarnings(value={"DM_EXIT"}, justification="Errors should terminate the application")
    public void uncaughtException(Thread t, Throwable e) {
        if (e instanceof ThreadDeath) {
            log.info("Thread has stopped: {}", (Object)t.getName());
            return;
        }
        log.error("Uncaught Exception caught by jmri.util.exceptionhandler.UncaughtExceptionHandler", e);
        if (e instanceof Error) {
            if (!GraphicsEnvironment.isHeadless()) {
                JOptionPane.showMessageDialog(null, Bundle.getMessage("UnrecoverableErrorMessage", UncaughtExceptionHandler.generateStackTrace(e)), Bundle.getMessage("UnrecoverableErrorTitle"), 0);
            }
            System.exit(126);
        }
    }

    protected static String generateStackTrace(Throwable e) {
        StringWriter writer = new StringWriter();
        e.printStackTrace(new PrintWriter(writer));
        return writer.toString();
    }
}

