/*
 * Decompiled with CFR 0.152.
 */
package jmri.util.davidflanagan;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.JobAttributes;
import java.awt.PageAttributes;
import java.awt.PrintJob;
import java.awt.Toolkit;
import java.io.IOException;
import java.io.Writer;
import java.text.DateFormat;
import java.util.Date;
import java.util.TimeZone;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.JWindow;
import javax.swing.border.EmptyBorder;
import jmri.util.JmriJFrame;
import jmri.util.davidflanagan.Bundle;

public class HardcopyWriter
extends Writer {
    protected PrintJob job;
    protected Graphics page;
    protected String jobname;
    protected String line;
    protected int fontsize;
    protected String time;
    protected Dimension pagesize = new Dimension(612, 792);
    protected int pagedpi = 72;
    protected Font font;
    protected Font headerfont;
    protected String fontName = "Monospaced";
    protected int fontStyle = 0;
    protected FontMetrics metrics;
    protected FontMetrics headermetrics;
    protected int x0;
    protected int y0;
    protected int height;
    protected int width;
    protected int headery;
    protected int charwidth;
    protected int lineheight;
    protected int lineascent;
    protected int chars_per_line;
    protected int lines_per_page;
    protected int charnum = 0;
    protected int linenum = 0;
    protected int charoffset = 0;
    protected int pagenum = 0;
    protected int prFirst = 1;
    protected Color color = Color.black;
    protected boolean printHeader = true;
    protected boolean isPreview;
    protected Image previewImage;
    protected Vector<Image> pageImages = new Vector(3, 3);
    protected JmriJFrame previewFrame;
    protected JPanel previewPanel;
    protected ImageIcon previewIcon = new ImageIcon();
    protected JLabel previewLabel = new JLabel();
    protected JToolBar previewToolBar = new JToolBar();
    protected Frame frame;
    protected JButton nextButton;
    protected JButton previousButton;
    protected JButton closeButton;
    protected JLabel pageCount = new JLabel();
    private boolean last_char_was_return = false;
    JobAttributes jobAttributes = new JobAttributes();
    PageAttributes pageAttributes = new PageAttributes();

    public HardcopyWriter(Frame frame, String jobname, int fontsize, double leftmargin, double rightmargin, double topmargin, double bottommargin, boolean preview) throws PrintCanceledException {
        this.hardcopyWriter(frame, jobname, fontsize, leftmargin, rightmargin, topmargin, bottommargin, preview);
    }

    public HardcopyWriter(Frame frame, String jobname, int fontsize, double leftmargin, double rightmargin, double topmargin, double bottommargin, boolean preview, String printerName, boolean landscape, boolean printHeader, Dimension pagesize) throws PrintCanceledException {
        this.printHeader = printHeader;
        this.jobAttributes.setPrinter(printerName);
        if (landscape) {
            this.pageAttributes.setOrientationRequested(PageAttributes.OrientationRequestedType.LANDSCAPE);
            if (preview) {
                this.pagesize = new Dimension(792, 612);
            }
        } else if (preview && pagesize != null) {
            this.pagesize = pagesize;
        }
        this.hardcopyWriter(frame, jobname, fontsize, leftmargin, rightmargin, topmargin, bottommargin, preview);
    }

    private void hardcopyWriter(Frame frame, String jobname, int fontsize, double leftmargin, double rightmargin, double topmargin, double bottommargin, boolean preview) throws PrintCanceledException {
        this.isPreview = preview;
        this.frame = frame;
        this.pageAttributes.setColor(PageAttributes.ColorType.COLOR);
        if (!this.isPreview) {
            Toolkit toolkit = frame.getToolkit();
            this.job = toolkit.getPrintJob(frame, jobname, this.jobAttributes, this.pageAttributes);
            if (this.job == null) {
                throw new PrintCanceledException("User cancelled print request");
            }
            this.pagesize = this.job.getPageDimension();
            this.pagedpi = this.job.getPageResolution();
            if (this.jobAttributes.getDefaultSelection().equals(JobAttributes.DefaultSelectionType.RANGE)) {
                this.prFirst = this.jobAttributes.getPageRanges()[0][0];
            }
        }
        this.x0 = (int)(leftmargin * (double)this.pagedpi);
        this.y0 = (int)(topmargin * (double)this.pagedpi);
        this.width = this.pagesize.width - (int)((leftmargin + rightmargin) * (double)this.pagedpi);
        this.height = this.pagesize.height - (int)((topmargin + bottommargin) * (double)this.pagedpi);
        this.font = new Font(this.fontName, this.fontStyle, fontsize);
        this.metrics = frame.getFontMetrics(this.font);
        this.lineheight = this.metrics.getHeight();
        this.lineascent = this.metrics.getAscent();
        this.charwidth = this.metrics.charWidth('m');
        this.chars_per_line = this.width / this.charwidth;
        this.lines_per_page = this.height / this.lineheight;
        this.headerfont = new Font("SansSerif", 2, fontsize);
        this.headermetrics = frame.getFontMetrics(this.headerfont);
        this.headery = this.y0 - (int)(0.125 * (double)this.pagedpi) - this.headermetrics.getHeight() + this.headermetrics.getAscent();
        DateFormat df = DateFormat.getDateTimeInstance(1, 3);
        df.setTimeZone(TimeZone.getDefault());
        this.time = df.format(new Date());
        this.jobname = jobname;
        this.fontsize = fontsize;
        if (this.isPreview) {
            this.previewFrame = new JmriJFrame(String.valueOf(Bundle.getMessage("PrintPreviewTitle")) + " " + jobname);
            this.previewFrame.getContentPane().setLayout(new BorderLayout());
            this.toolBarInit();
            this.previewToolBar.setFloatable(false);
            this.previewFrame.getContentPane().add((Component)this.previewToolBar, "North");
            this.previewPanel = new JPanel();
            this.previewPanel.setSize(this.pagesize.width, this.pagesize.height);
            this.previewFrame.getContentPane().add((Component)new JScrollPane(this.previewPanel), "Center");
            this.previewFrame.setSize(this.pagesize.width + 48, this.pagesize.height + 100);
            this.previewFrame.setVisible(true);
        }
    }

    protected void toolBarInit() {
        this.previousButton = new JButton(Bundle.getMessage("ButtonPreviousPage"));
        this.previewToolBar.add(this.previousButton);
        this.previousButton.addActionListener(actionEvent -> {
            --this.pagenum;
            this.displayPage();
        });
        this.nextButton = new JButton(Bundle.getMessage("ButtonNextPage"));
        this.previewToolBar.add(this.nextButton);
        this.nextButton.addActionListener(actionEvent -> {
            ++this.pagenum;
            this.displayPage();
        });
        this.pageCount = new JLabel(Bundle.getMessage("HeaderPageNum", this.pagenum, this.pageImages.size()));
        this.pageCount.setBorder(new EmptyBorder(0, 10, 0, 10));
        this.previewToolBar.add(this.pageCount);
        this.closeButton = new JButton(Bundle.getMessage("ButtonClose"));
        this.previewToolBar.add(this.closeButton);
        this.closeButton.addActionListener(actionEvent -> {
            if (this.page != null) {
                this.page.dispose();
            }
            this.previewFrame.dispose();
        });
    }

    protected void displayPage() {
        if (this.pagenum > this.pageImages.size()) {
            this.pagenum = this.pageImages.size();
        }
        if (this.pagenum < 1) {
            this.pagenum = 1;
        }
        this.previousButton.setEnabled(true);
        this.nextButton.setEnabled(true);
        if (this.pagenum == this.pageImages.size()) {
            this.nextButton.setEnabled(false);
        }
        if (this.pagenum == 1) {
            this.previousButton.setEnabled(false);
        }
        this.previewImage = this.pageImages.elementAt(this.pagenum - 1);
        this.previewFrame.setVisible(false);
        this.previewIcon.setImage(this.previewImage);
        this.previewLabel.setIcon(this.previewIcon);
        this.previewPanel.add(this.previewLabel);
        this.pageCount.setText(Bundle.getMessage("HeaderPageNum", this.pagenum, this.pageImages.size()));
        this.previewFrame.invalidate();
        this.previewFrame.revalidate();
        this.previewFrame.setVisible(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(char[] buffer, int index, int len) {
        Object object = this.lock;
        synchronized (object) {
            this.line = "";
            int i = index;
            while (i < index + len) {
                if (this.page == null) {
                    this.newpage();
                }
                if (buffer[i] == '\n') {
                    if (!this.last_char_was_return) {
                        this.newline();
                    }
                } else if (buffer[i] == '\r') {
                    this.newline();
                    this.last_char_was_return = true;
                } else {
                    this.last_char_was_return = false;
                    if (buffer[i] == '\f') {
                        this.pageBreak();
                    }
                    if (!Character.isWhitespace(buffer[i]) || Character.isSpaceChar(buffer[i]) || buffer[i] == '\t') {
                        if (this.charoffset >= this.width) {
                            this.newline();
                            if (this.page == null) {
                                this.newpage();
                            }
                        }
                        if (buffer[i] == '\t') {
                            int tab = 8 - this.charnum % 8;
                            this.charnum += tab;
                            this.charoffset = this.charnum * this.metrics.charWidth('m');
                            int t = 0;
                            while (t < tab) {
                                this.line = String.valueOf(this.line) + " ";
                                ++t;
                            }
                        } else {
                            this.line = String.valueOf(this.line) + buffer[i];
                            ++this.charnum;
                            this.charoffset += this.metrics.charWidth(buffer[i]);
                        }
                    }
                }
                ++i;
            }
            if (this.page != null && this.pagenum >= this.prFirst) {
                this.page.drawString(this.line, this.x0, this.y0 + this.linenum * this.lineheight + this.lineascent);
            }
        }
    }

    public void write(Color c, String s) throws IOException {
        this.charoffset = 0;
        if (this.page == null) {
            this.newpage();
        }
        if (this.page != null) {
            this.page.setColor(c);
        }
        this.write(s);
        if (this.page != null) {
            this.page.setColor(this.color);
        }
    }

    @Override
    public void flush() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = this.lock;
        synchronized (object) {
            if (this.isPreview) {
                this.pageImages.addElement(this.previewImage);
                this.pagenum = 1;
                this.displayPage();
            }
            if (this.page != null) {
                this.page.dispose();
            }
            if (this.job != null) {
                this.job.end();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        Object object = this.lock;
        synchronized (object) {
            if (this.page != null) {
                this.page.dispose();
            }
            this.previewFrame.dispose();
            if (this.job != null) {
                this.job.end();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFontStyle(int style) {
        Object object = this.lock;
        synchronized (object) {
            Font current = this.font;
            try {
                this.font = new Font(this.fontName, style, this.fontsize);
                this.fontStyle = style;
            }
            catch (Exception exception) {
                this.font = current;
            }
            if (this.page != null) {
                this.page.setFont(this.font);
            }
        }
    }

    public int getLineHeight() {
        return this.lineheight;
    }

    public int getFontSize() {
        return this.fontsize;
    }

    public int getCharWidth() {
        return this.charwidth;
    }

    public int getLineAscent() {
        return this.lineascent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFontName(String name) {
        Object object = this.lock;
        synchronized (object) {
            Font current = this.font;
            try {
                this.font = new Font(name, this.fontStyle, this.fontsize);
                this.fontName = name;
                this.metrics = this.frame.getFontMetrics(this.font);
                this.lineheight = this.metrics.getHeight();
                this.lineascent = this.metrics.getAscent();
                this.charwidth = this.metrics.charWidth('m');
                this.chars_per_line = this.width / this.charwidth;
                this.lines_per_page = this.height / this.lineheight;
            }
            catch (RuntimeException runtimeException) {
                this.font = current;
            }
            if (this.page != null) {
                this.page.setFont(this.font);
            }
        }
    }

    public void setTextColor(Color c) {
        this.color = c;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pageBreak() {
        Object object = this.lock;
        synchronized (object) {
            if (this.isPreview) {
                this.pageImages.addElement(this.previewImage);
            }
            if (this.page != null) {
                this.page.dispose();
            }
            this.page = null;
            this.newpage();
        }
    }

    public int getCharactersPerLine() {
        return this.chars_per_line;
    }

    public int getLinesPerPage() {
        return this.lines_per_page;
    }

    protected void newline() {
        if (this.page != null && this.pagenum >= this.prFirst) {
            this.page.drawString(this.line, this.x0, this.y0 + this.linenum * this.lineheight + this.lineascent);
        }
        this.line = "";
        this.charnum = 0;
        this.charoffset = 0;
        ++this.linenum;
        if (this.linenum >= this.lines_per_page) {
            if (this.isPreview) {
                this.pageImages.addElement(this.previewImage);
            }
            if (this.page != null) {
                this.page.dispose();
            }
            this.page = null;
            this.newpage();
        }
    }

    protected void newpage() {
        ++this.pagenum;
        this.linenum = 0;
        this.charnum = 0;
        if (this.page == null) {
            if (!this.isPreview) {
                if (this.pagenum >= this.prFirst) {
                    this.page = this.job.getGraphics();
                } else {
                    JFrame f = new JFrame();
                    f.pack();
                    this.page = f.createImage(this.pagesize.width, this.pagesize.height).getGraphics();
                }
            } else {
                this.previewImage = this.previewPanel.createImage(this.pagesize.width, this.pagesize.height);
                this.page = this.previewImage.getGraphics();
                this.page.setColor(Color.white);
                this.page.fillRect(0, 0, this.previewImage.getWidth(this.previewPanel), this.previewImage.getHeight(this.previewPanel));
                this.page.setColor(this.color);
            }
        }
        if (this.printHeader && this.page != null && this.pagenum >= this.prFirst) {
            this.page.setFont(this.headerfont);
            this.page.drawString(this.jobname, this.x0, this.headery);
            String s = "- " + this.pagenum + " -";
            int w = this.headermetrics.stringWidth(s);
            this.page.drawString(s, this.x0 + (this.width - w) / 2, this.headery);
            w = this.headermetrics.stringWidth(this.time);
            this.page.drawString(this.time, this.x0 + this.width - w, this.headery);
            int y = this.headery + this.headermetrics.getDescent() + 1;
            this.page.drawLine(this.x0, y, this.x0 + this.width, y);
        }
        if (this.page != null) {
            this.page.setFont(this.font);
        }
    }

    public void write(Image c, Component i) {
        if (this.page == null) {
            this.newpage();
        }
        int x = this.x0 + this.width - (c.getWidth(null) * 2 / 3 + this.charwidth);
        int y = this.y0 + this.linenum * this.lineheight + this.lineascent;
        if (this.page != null && this.pagenum >= this.prFirst) {
            this.page.drawImage(c, x, y, c.getWidth(null) * 2 / 3, c.getHeight(null) * 2 / 3, null);
        }
    }

    public void writeNoScale(Image c, Component i) {
        if (this.page == null) {
            this.newpage();
        }
        int x = this.x0 + this.width - (c.getWidth(null) + this.charwidth);
        int y = this.y0 + this.linenum * this.lineheight + this.lineascent;
        if (this.page != null && this.pagenum >= this.prFirst) {
            this.page.drawImage(c, x, y, c.getWidth(null), c.getHeight(null), null);
        }
    }

    public void write(JWindow jW) {
        if (this.page == null) {
            this.newpage();
        }
        if (this.page != null && this.pagenum >= this.prFirst) {
            int x = this.x0;
            int y = this.y0 + this.linenum * this.lineheight;
            this.page.translate(x, y);
            jW.setVisible(true);
            jW.printAll(this.page);
            jW.setVisible(false);
            jW.dispose();
            this.page.translate(-x, -y);
        }
    }

    public void write(int rowStart, int colStart, int rowEnd, int colEnd) {
        if (this.page == null) {
            this.newpage();
        }
        int xStart = this.x0 + (colStart - 1) * this.charwidth + this.charwidth / 2;
        int xEnd = this.x0 + (colEnd - 1) * this.charwidth + this.charwidth / 2;
        int yStart = this.y0 + rowStart * this.lineheight + (this.lineheight - this.lineascent) / 2;
        int yEnd = this.y0 + rowEnd * this.lineheight + (this.lineheight - this.lineascent) / 2;
        if (this.page != null && this.pagenum >= this.prFirst) {
            this.page.drawLine(xStart, yStart, xEnd, yEnd);
        }
    }

    public int getCurrentLineNumber() {
        return this.linenum;
    }

    public void writeBorders() {
        this.write(this.linenum, 0, this.linenum + 1, 0);
        this.write(this.linenum, this.chars_per_line + 1, this.linenum + 1, this.chars_per_line + 1);
    }

    public void increaseLineSpacing(int percent) {
        int delta = this.lineheight * percent / 100;
        this.lineheight += delta;
        this.lineascent += delta;
        this.lines_per_page = this.height / this.lineheight;
    }

    public static class PrintCanceledException
    extends Exception {
        public PrintCanceledException(String msg) {
            super(msg);
        }
    }
}

